package com.gtis.archive.service;

import com.gtis.archive.entity.Permission;

import java.util.List;
import java.util.Set;

/**
 * 权限项管理接口.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-12-8
 */
public interface PermissionService {

    /**
     * 分配权限
     *
     * @param permissions permissions
     */
    void grant(Permission[] permissions);

    /**
     * 取消权限
     *
     * @param permissions permissions
     */
    void revoke(Permission[] permissions);

    /**
     * 检查是否拥有权限
     *
     * @param resourceId 资源id
     * @param operation  操作
     * @return 是否拥有权限
     */
    boolean hasPermission(String resourceId, String operation);

    /**
     * 获取权限列表
     *
     * @param resourceId 资源id
     * @param roleId     角色Id
     * @return 权限列表
     */
    List<Permission> getPermissions(String resourceId, String roleId);


    Set<String> getReadableRoleIds(String resourceId);
}
