package com.gtis.archive.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * <p>
 * 原文权限
 * Generated 2011-05-11 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_original_permission")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class OriginalPermission {
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 用户id
     */
    @Column(length = 100, nullable = false)
    private String userId;

    /**
     * 用户名
     */
    @Column(length = 100)
    private String userName;

    /**
     * 授权人名
     */
    @Column(length = 100)
    private String authorizer;

    /**
     * 原文id
     */
    @Column(length = 100, nullable = false)
    private String originalId;

    /**
     * 授权日期
     */
    private Date createTime;

    /**
     * 到期时间
     */
    private Date expireTime;

    /**
     * 操作
     */
    @Column(length = 100, nullable = false)
    private String operation;

    @ManyToOne
    @JoinColumn(name = "originalId", insertable = false, updatable = false)
    private Original original;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAuthorizer() {
        return authorizer;
    }

    public void setAuthorizer(String authorizer) {
        this.authorizer = authorizer;
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    @JSONField(format = "yyyy-MM-dd")
    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Original getOriginal() {
        return original;
    }

    public void setOriginal(Original original) {
        this.original = original;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OriginalPermission))
            return false;
        OriginalPermission p = (OriginalPermission) obj;
        return userId != null && userId.equals(p.getUserId()) &&
                operation != null && operation.equals(p.getOperation()) &&
                originalId != null && originalId.equals(p.getOriginalId());
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + userId.hashCode();
        hash = hash * 31 + originalId.hashCode();
        hash = hash * 31 + operation.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        return "[" + userId + "," + originalId + "," + operation + "]";
    }
}