package com.gtis.archive.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * 原文
 * <p/>
 * Generated 2010-08-13 13:17:16 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_original")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Original {
    public static final String MODEL_NAME = Original.class.getSimpleName();
    public static final String[] IMAGE_POSTFIX = {"gif", "bmp", "jpg", "jpeg", "png"};
    public static final String[] THUMB_POSTFIX = {"gif", "bmp", "jpg", "jpeg", "png", "psd", "dwg", "tif"};
    public static final String[] X_OFFICE_POSTFIX = {"docx", "xlsx", "pptx"};
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 文件名
     */
    @Column(length = 1000)
    private String name;

    /**
     * 存放路径
     */
    @Column(length = 1000, nullable = false)
    private String path;

    /**
     * 文件大小
     */
    @Column(nullable = false)
    private long fileSize;

    /**
     * 全文
     */
    @Column(length = 4000)
    private String fullText;

    /**
     * 更新时间
     */
    @Column
    private Date updateTime;

    /**
     * 接收时间
     */
    @Column
    private Date receiveTime;

    /**
     * 所有者序号
     */
    @Column(length = 32)
    private String ownerId;

    @Column(length = 10)
    private String ownerModelName;

    /**
     *权限状态，若为空值则具有所有权限，readOnly为只读
     */
    @Column(length = 10)
    private String status;

    /**
     * 宽高比
     */
    @Column
    private Double kgb = 0.00;

    /**
     *原文挂接状态，若为0则未挂接档案，1为挂接档案
     */
    @Column(length = 10)
    private String linktype;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JSONField(serialize = false)
    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getFileSize() {
        return fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFullText() {
        return fullText;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerModelName() {
        return ownerModelName;
    }

    public void setOwnerModelName(String ownerModelName) {
        this.ownerModelName = ownerModelName;
    }

    public void setStatus(String status){
        this.status=status;
    }

    public String getStatus(){
        return  status;
    }

    public Double getKgb() {
        return kgb;
    }

    public void setKgb(Double kgb) {
        this.kgb = kgb;
    }

    public String getLinktype() {
        return linktype;
    }

    public void setLinktype(String linktype) {
        this.linktype = linktype;
    }

    public boolean isImage() {
        String postfix = getExtension();
        for (String s : IMAGE_POSTFIX)
            if (s.equals(postfix))
                return true;
        return false;
    }

    public boolean isXOffice() {
        String postfix = getExtension();
        for (String s : X_OFFICE_POSTFIX) {
            if (s.equals(postfix))
                return true;
        }
        return false;
    }

    public String getExtension() {
        int index = getName().lastIndexOf('.');
        return index > -1 ? getName().substring(index + 1).toLowerCase() : "";
    }

    public boolean canMakeThumb() {
        String postfix = getExtension();
        for (String s : THUMB_POSTFIX)
            if (s.equals(postfix))
                return true;
        return false;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }
}