package com.gtis.archive.core.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.SearchUtils;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.Hibernate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 模型实体对象集合基础action.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-1
 */
public class BaseModelAction<T> extends BaseAction {
    public static final String DIR_ASC = "asc";
    public static final String DIR_DESC = "desc";
    private static final Map<String, String[]> idsCaches = Collections.synchronizedMap(new LRUMap(500));
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    protected DictService dictService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private SecurityService securityService;
    /**
     * 分页位置
     */
    protected int start = 0;
    /**
     * 分页大小
     */
    protected int limit = Constants.DEFAULT_PAGE_SIZE;
    /**
     * 排序字段
     */
    protected String sort;
    /**
     * 排序方向
     */
    protected String dir;
    /**
     * 模型名
     */
    protected String modelName;
    /**
     * 打印类型
     */
    protected String printType;
    /**
     * 模糊检索关键字
     */
    protected String query;
    /**
     * 高级检索关键字
     */
    protected String condition;
    /**
     * id列表
     */
    protected String[] ids;
    /**
     * 数据
     */
    protected String idsKey;
    /**
     * 实体对象列表
     */
    protected List<T> entities;
    /**
     * 列表要显示的字段
     */
    private Map showFields;
    /**
     * 移交列表列表要显示的字段
     */
    private Map yjShowFields;
    /**
     * 当前是否为打印状态
     */
    private boolean isPrint;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 当前用户
     */
    private String curUsername;

    /**
     * 当前系统时间
     */
    private String curSystemTime;

    /**
     * 当前用户单位代码
     */
    private String curRegionCode;

    /**
     * 当前用户角色
     */
    private String curUserRole;

    /**
     * 当前用户部门
     */
    private String curUserRegion;

    /**
     * 系统权限列表
     */
    private Map<String, Boolean> sysPerms;

    public String getUserName() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCurUsername(String curUsername) {
        this.curUsername = curUsername;
    }

    /**
     * 获取当前用户
     * @return
     */
    public String getCurUsername() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setCurSystemTime(String curSystemTime) {
        this.curSystemTime = curSystemTime;
    }

    public String getCurSystemTime() {
        return SessionUtil.getCurTime();
    }

    public void setCurcurRegionCode(String curRegionCode) {
        this.curRegionCode = curRegionCode;
    }

    public String getCurRegionCode() {
        return SessionUtil.getCurrentUser().getRegionCode();
    }

    public void setCurUserRole(String curUserRole) {
        this.curUserRole = curUserRole;
    }

    public Map<String, Boolean> getSysPerms() {
        sysPerms = new HashMap<String, Boolean>();
        for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
            if (securityService.isPermitted("sys", item.getName()))
                sysPerms.put(item.getName(), true);
        }
        return sysPerms;
    }

    /**
     * 获取角色名称
     * @return
     */
    public String getCurUserRole() {
        List<PfRoleVo> roles = SessionUtil.getCurrentUser().getLstRole();
        List<String> rolenames = new ArrayList<String>();
        if(roles == null){
            return "无角色";
        }else {
            for(PfRoleVo prv : roles){
                rolenames.add(prv.getRoleName());
            }
            return rolenames.toString().substring(1, rolenames.toString().length() - 1);
        }
    }


    public void setCurUserRegion(String curUserRegion) {
        this.curUserRegion = curUserRegion;
    }

    /**
     * 获取部门名称
     */
    public String getCurUserRegion() {
        List<PfOrganVo> organs = SessionUtil.getCurrentUser().getLstOragn();
        List<String> organNames = new ArrayList<String>();
        for(PfOrganVo pov : organs){
            organNames.add(pov.getOrganName());
        }
        return organNames.toString().substring(1,organNames.toString().length()-1);
    }

    public BaseModelAction() {
        Type genType = getClass().getGenericSuperclass();
        if (genType instanceof ParameterizedType) {
            Type params = (((ParameterizedType) genType).getActualTypeArguments())[0];
            if (params instanceof Class) {
                setModelName(((Class) params).getSimpleName());
            }
        }
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setModelName(String modelName) {
        if (modelName.startsWith(Constants.ARCHIVE_PREFIX)) {
            this.modelName = modelName.substring(2);
        } else {
            this.modelName = modelName;
        }
    }

    public void setPrintType(String printType) {
        this.printType = printType;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setId(String[] ids) {
        this.ids = ids;
    }

    public void setIdsKey(String idsKey) {
        this.idsKey = idsKey;
    }

    public int getLimit() {
        if (limit == Constants.DEFAULT_PAGE_SIZE) {
            String pageSize = getEntityModel().getEnv().get("pageSize");
            if (StringUtils.isNotBlank(pageSize))
                limit = Integer.parseInt(pageSize);
        }
        return limit;
    }

    public String getModelName() {
        return modelName;
    }

    public List<T> getEntities() {
        if (entities == null) {
            entities = getEntityPage().getItems();
            if (modelName.toLowerCase().equals("ythsw") && EnvHolder.isEnable(Switch.JIANGYIN) && isPrint) {
                try {
                    PropertyUtils.setProperty(entities.get(0), "oragn", getRagon());
                } catch (Exception ex) {
                    logger.error(ex.toString());
                }
            }
        }
        return entities;
    }

    /**
     * 获取实体对象模型
     *
     * @return 实体对象模型
     */
    public Model getEntityModel() {
        return modelService.getModel(modelName);
    }

    /**
     * 获取字段列表
     *
     * @return 字段列表
     */
    public Map<String, Field> getFields() {
        return getEntityModel().getInheritfieldsMap();
    }

    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    /**
     * 获取移交清单显示字段
     *
     * @return 字段列表
     */
    public Map getYjShowFields() {
        if (yjShowFields == null) {
            yjShowFields = JSON.parseObject(getEntityTemplate("yjShowFields"), LinkedHashMap.class);
        }
        return yjShowFields == null ? Collections.emptyMap() : yjShowFields;
    }

    public Map getConfigCondition(){
        Map map = new HashMap();
        try {
            String fields = getEntityTemplate("configCondition");
            map.put("num",fields.split(",").length);
            map.put("fields", JSONArray.toJSON(Arrays.asList(fields.split(","))));
        }catch (Exception ex){
            map.put("num",0);
        }
        return map;
    }

    public String getId() {
        return ids == null ? null : ids[0];
    }

    public void list() throws Exception {
        try {
            renderJson(getEntityPage());
        } catch (Exception e) {
            renderJson(new Page());
        }
    }

    public String cacheIds() {
        String key = UUIDHexGenerator.generate();
        idsCaches.put(key, ids);
        return renderJson(Collections.singletonMap("idsKey", key));
    }

    public String print() throws Exception {
        isPrint = true;
        return renderTemplate(getEntityModel().getTemplate("print"));
    }

    public String fr3() throws Exception {
        sendFile(getEntityModel().getPrintFr3(printType));
        return null;
    }

    public String export() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=" + modelName + "-export.xls");
        entities = getEntityPage().getItems();
        return renderModelTemplate("export");
    }

    public String remove() throws Exception {
        entityService.remove(modelName, ids);
        return null;
    }

    protected Page<T> getEntityPage() {
        if (StringUtils.isNotEmpty(idsKey)) {
            ids = idsCaches.get(idsKey);
        }
        if(EnvHolder.isEnable(Switch.SIHONG)) {
            if (ids != null && !(isPrint == true && modelName.contains("_jn"))) {
                entities = new ArrayList<T>(ids.length);
                for (String id : ids) {
                    entities.add(entityService.<T>load(modelName, id));
                }
                return new Page<T>(entities);
            }
            if (ids != null && isPrint == true && modelName.contains("_jn")) {
                entities = new ArrayList<T>();
                for (String id : ids) {
                    List<T> en = new ArrayList<T>();
                    List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
                    List<Order> orders = createOrders(new ArrayList<Order>());
                    en = searchDocentity(criterions, orders, id).getItems();
                    for (int i = 0; i < en.size(); i++) {
                        entities.add(en.get(i));
                    }
                    int j=0;
                    if((en.size()%18)!=0) {
                          j = 18 - (en.size() % 18);
                    }
                    for (int i = 0;i<j;i++){
                        Document document = entityService.newInstance(modelName);
                        document.setArchiveId(id);
                        try {
                            entities.add((T)document);
                        } catch (Exception e) {
                            logger.error("插入空白信息异常"+e.toString());
                        }
                    }
                }
                return new Page<T>(entities);
            }
        }
        else {
            if (ids != null) {
                entities = new ArrayList<T>(ids.length);
                for (String id : ids) {
                    entities.add(entityService.<T>load(modelName, id));
                }
                return new Page<T>(entities);
            }
        }
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        return searchEntity(criterions, orders);
    }

    protected Page<T> searchEntity(List<Criterion> criterions, List<Order> orders) {
        return entityService.search(modelName, criterions, orders, start, limit);
    }

    protected Page<T> searchDocentity(List<Criterion> criterions, List<Order> orders,String archiveid) {
        return entityService.search(modelName, criterions, orders, start, limit);
    }

    protected List<Order> createOrders(final ArrayList<Order> orders) {
        if (StringUtils.isNotEmpty(sort)) {
            if (DIR_ASC.equalsIgnoreCase(dir)) {
                orders.add(Order.asc(sort));
            } else {
                orders.add(Order.desc(sort));
            }
        }
        if (orders.isEmpty()) {
            for (Map.Entry<String, String> entry : getOrderFields().entrySet()) {
                orders.add(entry.getValue().equalsIgnoreCase(DIR_ASC) ? Order.asc(entry.getKey()) : Order.desc(entry.getKey()));
            }
        }
        return orders;
    }

    protected List<Criterion> createCriterions(final ArrayList<Criterion> criterions) {
        if (StringUtils.isNotBlank(condition))
            criterions.addAll(SearchUtils.conditionToCriterion(getFields(), condition));
        if (StringUtils.isNotBlank(query)) {
            if(query.contains("_")){
                query = query.replace("_","\\_");
            }else if(query.contains("%")){
                query = query.replace("%","\\%");
            }
            String[] fields = getQueryFields();
            Model model = modelService.getModel(modelName);
            Model modelParent = modelService.getModel(modelName).getParent();
            Set<Field> fieldSet = model.getFields();
            Set<Field> parentFieldSet = modelParent.getFields();
            ArrayList<Field> fieldList = new ArrayList<Field>();
            fieldList.addAll(fieldSet);
            fieldList.addAll(parentFieldSet);
            ArrayList<String> containDateTimeTypeField = new ArrayList<String>();
            ArrayList<String> containDateTypeField = new ArrayList<String>();
            for(Field f : fieldList) {
                String temp = f.getName();
                if(f.getType() == Field.Type.DATE || f.getType() == Field.Type.DATETIME){
                    if(!temp.matches("^[a-z]$")){
                        String[] sArr = temp.split("(?=[A-Z])");
                        StringBuilder builder = new StringBuilder();
                        for(int i = 0;i < sArr.length-1;i++) {
                            builder.append(sArr[i]).append("_");
                        }
                        builder.append(sArr[sArr.length-1]);
                        temp = builder.toString().toLowerCase();
                    }
                    if(f.getType() == Field.Type.DATE){
                        containDateTypeField.add(temp);
                    }else{
                        containDateTimeTypeField.add(temp);
                    }
                }
            }
            if (fields != null) {
                Criterion cr = null;
                for (String field : fields) {
                    if(!field.matches("^[a-z]$")){
                        String[] sArr = field.split("(?=[A-Z])");
                        StringBuilder builder = new StringBuilder();
                        for(int i = 0;i < sArr.length-1;i++) {
                            builder.append(sArr[i]).append("_");
                        }
                        builder.append(sArr[sArr.length-1]);
                        field = builder.toString().toLowerCase();
                    }
                    if(!containDateTimeTypeField.contains(field) && !containDateTypeField.contains(field)){
                        if("id".equals(field)){
                            cr = cr == null ? Restrictions.like(field, "%" + query + "%") : Restrictions.or(cr, Restrictions.like(field, "%" + query + "%"));
                        }else{
                            cr = cr == null? Restrictions.sqlRestriction("to_char("+field+") like '%"+query+"%' escape '\\'") : Restrictions.or(cr , Restrictions.sqlRestriction("to_char("+field+") like '%"+query+"%' escape '\\'"));
                        }
                    }else if(containDateTypeField.contains(field)){
                        cr = cr == null? Restrictions.sqlRestriction("to_char("+field+",'yyyy-mm-dd') like '%"+query+"%'") : Restrictions.or(cr , Restrictions.sqlRestriction("to_char("+field+",'yyyy-mm-dd') like '%"+query+"%'"));
                    }else if(containDateTimeTypeField.contains(field)){
                        cr = cr == null? Restrictions.sqlRestriction("to_char("+field+",'yyyy-mm-dd hh24:mi:ss') like '%"+query+"%'") : Restrictions.or(cr , Restrictions.sqlRestriction("to_char("+field+",'yyyy-mm-dd hh24:mi:ss') like '%"+query+"%'"));
                    }
                }
                if (cr != null) {
                    criterions.add(cr);
                }
            }
        }
        String dwdm = getDwdm();
//        if (dwdm != null)
//            criterions.add(Restrictions.or(Restrictions.eq("dwdm",dwdm),Restrictions.isNull("dwdm")));
        return criterions;
    }

    /**
     * 高级查询字段过滤
     */
    public Map<String, Field> getAdvSearchFields() {
        Map<String, Field> allFields = getFields();
        Map<String, Field> fields = new LinkedHashMap<String, Field>();
        try {
            String[] filters = StringUtils.split(getEntityTemplate("advSearchFields"), ",");
            if (filters.length == 0) return fields;
            for (String name : filters) {
                if (allFields.containsKey(name))
                    fields.put(name, allFields.get(name));
            }
        } catch (TemplateNotFoundException e) {
            return allFields;
        }
        return fields;
    }

    @SuppressWarnings("unchecked")
    protected LinkedHashMap<String, String> getOrderFields() {
        try {
            if (isPrint) {
                isPrint = false;
                return JSON.parseObject(getEntityTemplate("printOrderFields"), LinkedHashMap.class);
            } else
                return JSON.parseObject(getEntityTemplate("orderFields"), LinkedHashMap.class);
        } catch (TemplateNotFoundException ex) {
            return JSON.parseObject(getEntityTemplate("orderFields"), LinkedHashMap.class);
        }
    }

    protected String[] getQueryFields() {
        return StringUtils.split(getEntityTemplate("queryFields"), ",");
    }

    protected String getEntityTemplate(String name) {
        return getEntityModel().getTemplate(name);
    }

    protected String renderModelTemplate(String name) throws Exception {
        return renderTemplate(getEntityTemplate(name));
    }


    //暨办单组织机构
    private String getRagon() {
        String oragn = "";
        String dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
        try {
            List<Item> items = dictService.getItems(Constants.ORAGN);
            for (Item item : items) {
                if (dwdm.equals(item.getName())) {
                    oragn = item.getValue();
                    break;
                }
            }
        } catch (Exception ex) {
            logger.info("未配置[{}]组织机构字典项", Constants.ORAGN);
        }
        return oragn;
    }
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }
}
