package com.gtis.archive.core.support.hibernate;

import org.hibernate.*;
import org.hibernate.classic.Session;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.NamingException;
import javax.naming.Reference;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-7-29
 */
public class ReloadableSessionFactory implements SessionFactory {
    private static final long serialVersionUID = 1590291600523676145L;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private SessionFactory sessionFactory;
    private ReloadableLocalSessionFactoryBean fb;

    public ReloadableSessionFactory(SessionFactory sessionFactory, ReloadableLocalSessionFactoryBean reloadableLocalSessionFactoryBean) {
        this.sessionFactory = sessionFactory;
        this.fb = reloadableLocalSessionFactoryBean;
    }

    public Reference getReference() throws NamingException {
        return sessionFactory.getReference();
    }

    public Session openSession(Connection connection) {
        return sessionFactory.openSession(connection);
    }

    public Session openSession(Interceptor sessionLocalInterceptor) throws HibernateException {
        return sessionFactory.openSession(sessionLocalInterceptor);
    }

    public Session openSession(Connection connection, Interceptor sessionLocalInterceptor) {
        return sessionFactory.openSession(connection, sessionLocalInterceptor);
    }

    public Session openSession() throws HibernateException {
        return sessionFactory.openSession();
    }

    public Session getCurrentSession() throws HibernateException {
        return sessionFactory.getCurrentSession();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return sessionFactory.getClassMetadata(persistentClass);
    }

    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return sessionFactory.getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return sessionFactory.getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return sessionFactory.getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return sessionFactory.getAllCollectionMetadata();
    }

    public Statistics getStatistics() {
        return sessionFactory.getStatistics();
    }

    public void close() throws HibernateException {
        sessionFactory.close();
    }

    public boolean isClosed() {
        return sessionFactory.isClosed();
    }

    public Cache getCache() {
        return sessionFactory.getCache();
    }

    public void evict(Class persistentClass) throws HibernateException {
        sessionFactory.evict(persistentClass);
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        sessionFactory.evict(persistentClass, id);
    }

    public void evictEntity(String entityName) throws HibernateException {
        sessionFactory.evictEntity(entityName);
    }

    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        sessionFactory.evictEntity(entityName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        sessionFactory.evictCollection(roleName);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        sessionFactory.evictCollection(roleName, id);
    }

    public void evictQueries() throws HibernateException {
        sessionFactory.evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        sessionFactory.evictQueries(cacheRegion);
    }

    public StatelessSession openStatelessSession() {
        return sessionFactory.openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return sessionFactory.openStatelessSession(connection);
    }

    public Set getDefinedFilterNames() {
        return sessionFactory.getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return sessionFactory.getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return sessionFactory.containsFetchProfileDefinition(name);
    }

    public TypeHelper getTypeHelper() {
        return sessionFactory.getTypeHelper();
    }

    @SuppressWarnings("unchecked")
    public synchronized void reload() {
        SessionFactory newSessionFactory = null;
        try {
            newSessionFactory = fb.rebuildSessionFactory();
        } catch (Exception e) {
            logger.error("reload hibernate error", e);
            throw new RuntimeException("reload hibernate error:{}", e);
        } finally {
            SessionFactory oldSessionFactory = sessionFactory;
            if (newSessionFactory != null) {
                sessionFactory = newSessionFactory;
                logger.info("reload hibernate successed:{}", sessionFactory.getAllClassMetadata());
                try {
                    oldSessionFactory.close();
                } catch (HibernateException e) {
                    logger.error("close hibernate error", e);
                }
            }
        }
    }
}
