/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class MainAction
extends BaseModelAction {
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private SecurityService securityService;
    private String treeId;
    private String id;
    private Map showFields;
    private Map docShowFields;
    private List<Item> operations;
    private Map<String, String> topMenu;

    public String execute() {
        this.operations = this.dictService.getItems("operationPerm");
        return "success";
    }

    public String node() throws Exception {
        List ress = StringUtils.isBlank((String)this.id) ? this.resourceService.getChildrenResource(this.resourceService.getResource(null, new String[]{"model"}).getId(), new String[0]) : this.resourceService.getChildrenResource(this.id, new String[0]);
        ArrayList list = new ArrayList();
        for (Resource res : ress) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", res.getId());
            String text = res.getName();
            if (!res.getParentId().equals(this.resourceService.getResource(null, new String[]{"model"}).getId()) && StringUtils.isNotEmpty((String)res.getTitle())) {
                text = res.getTitle();
            }
            map.put("text", text);
            map.put("name", res.getName());
            map.put("title", res.getTitle());
            map.put("content", res.getContent());
            map.put("parentId", res.getParentId());
            map.put("flh", res.getFlh());
            map.put("orderNumber", res.getOrderNumber());
            map.put("iconCls", "model");
            list.add(map);
        }
        Struts2Utils.renderJson(list, (String[])new String[0]);
        return null;
    }

    public Map getShowFields() {
        if (this.showFields == null) {
            this.showFields = (Map)JSON.parseObject((String)this.getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        Map fileds = this.getFields();
        StringBuilder sb = new StringBuilder("{\"result\":[");
        Iterator iter = this.showFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            StringBuilder content = new StringBuilder("{\"fieldName\":");
            String key = entry.getKey().toString();
            content.append("\"" + key + "\",\"title\":\"" + ((Field)fileds.get(key)).getTitle() + "\",");
            Map val = (Map)entry.getValue();
            Iterator it = val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = it.next();
                String keyV = en.getKey().toString();
                String value = en.getValue().toString();
                content.append("\"" + keyV + "\":\"" + value + "\"");
                if (!it.hasNext()) continue;
                content.append(",");
            }
            if (iter.hasNext()) {
                content.append("},");
                sb.append(content.toString());
                continue;
            }
            content.append("}");
            sb.append(content.toString() + "]}");
        }
        Struts2Utils.renderJson((String)sb.toString(), (String[])new String[0]);
        return null;
    }

    public Map getDocShowFields() {
        if (this.docShowFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docShowFields = (Map)JSON.parseObject((String)doc.getTemplate("showFields"), LinkedHashMap.class);
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docShowFields = (Map)JSON.parseObject((String)this.getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        Map fileds = this.getDocFields();
        StringBuilder sb = new StringBuilder("{\"result\":[");
        Iterator iter = this.docShowFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            StringBuilder content = new StringBuilder("{\"fieldName\":");
            String key = entry.getKey().toString();
            content.append("\"" + key + "\",\"title\":\"" + ((Field)fileds.get(key)).getTitle() + "\",");
            Map val = (Map)entry.getValue();
            Iterator it = val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = it.next();
                String keyV = en.getKey().toString();
                String value = en.getValue().toString();
                content.append("\"" + keyV + "\":\"" + value + "\"");
                if (!it.hasNext()) continue;
                content.append(",");
            }
            if (iter.hasNext()) {
                content.append("},");
                sb.append(content.toString());
                continue;
            }
            content.append("}");
            sb.append(content.toString() + "]}");
        }
        Struts2Utils.renderJson((String)sb.toString(), (String[])new String[0]);
        return null;
    }

    public Map getDocFields() {
        Map docFields = null;
        try {
            Model doc = this.archiveService.getDocumentModel(this.modelName);
            docFields = doc.getInheritfieldsMap();
        }
        catch (ModelNotFoundException modelNotFoundException) {
            // empty catch block
        }
        return docFields;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getTopMenu() {
        if (this.topMenu == null) {
            this.topMenu = new LinkedHashMap();
            for (Item item : this.dictService.getItems("archiveMenu")) {
                if (!"true".equalsIgnoreCase(item.getValue())) continue;
                this.topMenu.put(item.getName(), item.getRemark());
            }
        }
        return this.topMenu;
    }

    public String getPermJson() {
        HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
        if (this.operations == null) {
            this.operations = this.dictService.getItems("operationPerm");
        }
        for (Item item : this.operations) {
            if (!this.securityService.isPermitted(this.treeId, item.getName())) continue;
            perm.put(item.getName(), true);
        }
        if (this.treeId != null) {
            Struts2Utils.renderJson(perm, (String[])new String[0]);
        }
        return null;
    }

    public List<Item> getOperations() {
        return this.operations;
    }
}

