/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.web;

import com.gtis.archive.core.web.BaseAction;
import com.gtis.archive.core.web.FreemarkerRenderSupport;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.Action;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public abstract class BaseAction
extends FreemarkerRenderSupport
implements Action {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }

    public String execute() throws Exception {
        return "success";
    }

    protected void sendFile(File file) throws IOException {
        HttpServletResponse response = ServletActionContext.getResponse();
        if (file != null && file.exists()) {
            long modified = file.lastModified();
            long modifiedSince = ServletActionContext.getRequest().getDateHeader("If-Modified-Since");
            if (modifiedSince > 0L) {
                long modDate = modified / 1000L * 1000L;
                if (modDate <= modifiedSince) {
                    response.setStatus(304);
                    return;
                }
                response.setDateHeader("Last-Modified", modified);
            }
            response.setContentLength((int)file.length());
            FileCopyUtils.copy((InputStream)new FileInputStream(file), (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, "file not found");
        }
    }

    protected String renderJson(Object obj) {
        Struts2Utils.renderJson((Object)obj, (String[])new String[0]);
        return null;
    }

    protected String renderSuccess() {
        this.renderJson(Collections.singletonMap("success", true));
        return null;
    }

    protected String renderFailure(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("msg", message);
        map.put("success", false);
        this.renderJson(map);
        return null;
    }

    protected String renderJs(Runner runner, String successMessage, String failuremessage, String fn) {
        if (fn == null) {
            fn = "onComplete";
        }
        try {
            runner.run();
            if (successMessage == null) {
                successMessage = "";
            }
            Struts2Utils.renderJs((String)("(opener||parent)." + fn + "(true,'" + successMessage + "');"), (String[])new String[0]);
        }
        catch (Exception e) {
            this.logger.error("error", (Throwable)e);
            if (failuremessage == null) {
                failuremessage = "\u5931\u8d25 " + e.getMessage();
            }
            Struts2Utils.renderJs((String)("(opener||parent)." + fn + "(false,'" + failuremessage + "');"), (String[])new String[0]);
        }
        return null;
    }

    protected String renderJs(Runner runner, String fn) {
        return this.renderJs(runner, null, null, fn);
    }

    protected String renderJs(Runner runner) {
        return this.renderJs(runner, null);
    }
}

