package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-11-9
 */
public class LoanEntityAction extends BaseEntityAction<Loan> {

    @Autowired
    private SysUserService userService;

    @Autowired
    private LoanService loanService;

    @Autowired
    private EntityService entityService;


    public String save() throws Exception {
        return renderJs(new Runner() {
            public void run() {
                String[] archiveIds = StringUtils.split(entity.getArchiveId(), ",");
                String[] loanIds=new String[archiveIds.length];
                for (int i=0;i<archiveIds.length;i++) {
                    try {
                        Loan loan = entity.clone();
                        loan.setArchiveId(StringUtils.trim(archiveIds[i]));
                        if(EnvHolder.isEnable(Switch.DWDM)) loan.setDwdm(getDwdm());
                        loan.setPch(loan.getJyr()+loan.getJyrq());
                        entityService.save(loan);
                        loanIds[i]=loan.getId();
                    } catch (CloneNotSupportedException ignored) {
                    }
                }
                if(entity.isBackNow())
                    returnLoan(loanIds);
                if(EnvHolder.isEnable(Switch.JIANGYIN)){
                    String[] loanCartIds=StringUtils.split(entity.getLoanCartId(), ",");
                    for(String id:loanCartIds){
                        loanService.removeFromCart(entityService.load(LoanCart.class,id.trim()));
                    }
                }
            }
        }, "保存成功", null, getJsCallBack());
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    //归还
    public String returnLoan(String[] ids) {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Loan loan = entityService.load(Loan.class, id);
            loan.setState(1);
            entityService.save(loan);
        }
        return null;
    }
}
