package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-3-20
 */
public class GenericAction extends BaseModelAction<Object> {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private ArchiveService archiveService;

    private AjhRange ajhRange;

    private Integer sbjh;

    private String linkField;

    /**
     * 年度
     */
    private String nd;


    /**
     * tree id
     */
    private String treeId;
    
    private String tplName;
    
    private String status;

    private String printType;

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }
    
    public void setTplName(String tplName){
        this.tplName = tplName;
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString(treeService.getTree2(treeId));
    }

    public int getLimit() {
        return limit;
    }

    public String getPrintType() {
        return printType;
    }

    public void setPrintType(String printType) {
        this.printType = printType;
    }

    @Override
    public void setId(String[] ids) {
        this.ids=ids;
    }

    @Override
    public void setStart(int start) {
       super.setStart(start);
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    @Override
    public Map getShowFields(){
        Map showFields = null;
        try{
            showFields = super.getShowFields();
        }catch(TemplateNotFoundException ex){
            logger.error(ex.getMessage());
        }
        return showFields;
    }

    @Override
    protected String[] getQueryFields() {
        String[] qFields = null;
        try{
            qFields = super.getQueryFields();
        }catch(TemplateNotFoundException ex){
            logger.error(ex.getMessage());
        }
        return qFields;
    }

    @Override
    public String execute() {
        if (treeId == null) {
            Resource res = resourceService.findChildResource(null, Constants.GENERIC, Constants.MODEL_ROOT);
            treeId = res.getId();
        }
        /*if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
            throw new NoPermissionException(treeId);
        }*/
        return Action.SUCCESS;
    }

    /**
     *
     * @return
     */
    public String tpl() {
        try {
            if(tplName.indexOf("list")>-1){
                try{
                    renderModelTemplate(tplName);
                }catch(TemplateNotFoundException e){
                    renderModelTemplate("Generic-list");
                }
            }else{
                    renderModelTemplate(tplName);
            }
        } catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return null;
    }


    public  String modify(){
        try{
            if("ygd".equals(status)){
                List<Object> entities=orderEntities();
                    for(Object entity:entities){
                        String mlh=PropertyUtils.getProperty(entity,"qzh")+"-"+PropertyUtils.getProperty(entity,"nd")+"-"+PropertyUtils.getProperty(entity,"bgqx")+"-"+PropertyUtils.getProperty(entity,"flh");
                        PropertyUtils.setProperty(entity,"sbjh",String.valueOf(getSbjh(mlh)));
                        PropertyUtils.setProperty(entity,"status",status);
                        entityService.save(entity);
                        if(sbjh!=null){
                            ajhRange.setCurrentValue(sbjh);
                            ajhRangeService.saveAjhRange(ajhRange);
                        }
                     }
            }else {
                    modifyAuto();
            }
        }catch (Exception ex){
                logger.error(ex.toString());
        }
        return null;
    }

    private String modifyAuto() throws Exception{
        for(String id : ids){
            Object entity = entityService.load(modelName,id);
            if(PropertyUtils.getProperty(entity,"status").equals(status)){
                return "";
            }
             PropertyUtils.setProperty(entity,"status",status);
            entityService.save(entity);
        }
        return "";
    }
    
    public String modify2(){
        for(String id : ids){
            Object entity = entityService.load(modelName,id);
            try {
                if(PropertyUtils.getProperty(entity,"status").equals(status)){
                    return "";
                }
                if("ygd".equals(status)){
                    String mlh=PropertyUtils.getProperty(entity,"qzh")+"-"+PropertyUtils.getProperty(entity,"nd")+"-"+PropertyUtils.getProperty(entity,"bgqx")+"-"+PropertyUtils.getProperty(entity,"flh");
                    PropertyUtils.setProperty(entity,"sbjh",String.valueOf(getSbjh(mlh)));
                }
                PropertyUtils.setProperty(entity,"status",status);
            } catch (Exception e) {
                logger.error(e.toString());
            }
            entityService.save(entity);
            if(sbjh!=null){
                ajhRange.setCurrentValue(sbjh);
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return "";
    }

    private List orderEntities(){
        List<Object> entities=new ArrayList<Object>();
        for(String id:ids){
            Object entity = entityService.load(modelName,id);
            entities.add(entity);
        }
        return  addAll(entities,null,null);
    }

    public String years(){
        List<Criterion> criterions=new ArrayList<Criterion>();
        criterions.add(Restrictions.eq("status","xgd"));
        Page<Object> page=searchEntityAll(criterions,null);
        List<Object> list=page.getItems();
        List<String> years=new ArrayList<String>();
        for (Object object:list){
            try{
                String year=PropertyUtils.getProperty(object,"nd").toString();
                if(!years.contains(year)){
                    years.add(year);
                }
            }catch (Exception ex){
            }
        }
        renderJson(years);
        return null;
    }


    public String   modifyAll(){
        if(StringUtils.isBlank(nd)) return null;
        List<Criterion> criterions=new ArrayList<Criterion>();
        criterions.add(Restrictions.eq("nd",nd));
        criterions.add(Restrictions.eq("status","xgd"));
        List<Order> orders=new ArrayList<Order>();
        orders.add(Order.asc("cwrq"));
        Page<Object> page=searchEntityAll(criterions,orders);
        try{
            gd(page);
        }catch (Exception ex){
            logger.error(ex.toString());
        }
        return "";
    }

    /**
     * 将所有需归档的档案进行归档操作
     * @param page
     * @return
     * @throws Exception
     */
    public String gd(Page<Object> page) throws Exception{
        for(int i=0;i<page.getTotalCount();i++){
            Object entity=page.getItem(i);
            String mlh=PropertyUtils.getProperty(entity,"qzh")+"-"+PropertyUtils.getProperty(entity,"nd")+"-"+PropertyUtils.getProperty(entity,"bgqx")+"-"+PropertyUtils.getProperty(entity,"flh");
            PropertyUtils.setProperty(entity,"sbjh",String.valueOf(getSbjh(mlh)));
            PropertyUtils.setProperty(entity,"status","ygd");
            entityService.save(entity);
            if(sbjh!=null){
                ajhRange.setCurrentValue(sbjh);
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return null;
    }

    /**
     * 检索收文，发文，内文中的档案，并根据成文日期排序
     * @param criterions
     * @param orders
     * @return
     */
    private Page<Object> searchEntityAll(List<Criterion> criterions, List<Order> orders){
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        if (EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin()) {
            try{
                boolean hasDwdm=PropertyUtils.getProperty(entityService.<Object>newInstance(modelName),"dwdm")==null;
                list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
            }catch (Exception ex){
                logger.error(ex.toString()+"{该业务没有设置单位代码}");
            }
        }
        Page page=new Page();
        List all=addAll(entityService.search("ythsw", list, orders, start, limit).getItems(),
                entityService.search("ythfw", list, orders, start, limit).getItems(),
                entityService.search("ythnw", list, orders, start, limit).getItems());
        int totalCount=all.size();
        page.setItems(all);
        page.setTotalCount(totalCount);
        return page;
    }

    @Override
    protected Page<Object> searchEntity(List<Criterion> criterions, List<Order> orders) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        if (EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin()) {
            try{
                if(modelName.equals("ygd")){
                    boolean hasDwdm=PropertyUtils.getProperty(entityService.<Object>newInstance("ythsw"),"dwdm")==null;
                }else{
                    boolean hasDwdm=PropertyUtils.getProperty(entityService.<Object>newInstance(modelName),"dwdm")==null;
                }
                list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
            }catch (Exception ex){
             logger.error(ex.toString()+"{该业务没有设置单位代码}");
            }
        }
        if(modelName.equals("ygd")) {
            list.add(Restrictions.eq("status","ygd"));
            Page page=new Page();
            List all=addAll(entityService.search("ythsw", list, orders, start, limit).getItems(),
                    entityService.search("ythfw", list, orders, start, limit).getItems(),
                    entityService.search("ythnw", list, orders, start, limit).getItems());
            int totalCount=all.size();
            page.setItems(all);
            page.setTotalCount(totalCount);
            return page;
        }
        return entityService.search(modelName, list, orders, start, limit);
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if(StringUtils.isNotBlank(status))
            criterions.add(Restrictions.eq("status",status));
        return super.createCriterions(criterions);
    }


    @Override
    public String fr3() throws Exception {
        if(StringUtils.isBlank(printType)){
            String basePath = getEntityModel().getEnv().getExpr("${.vars['web.root']}/print");
            File file = new File(basePath, modelName+".fr3");
            if(file.exists()){
                sendFile(file);
            }else {
                try{
                    basePath = getEntityModel().getEnv().getExpr("${.vars['egov.conf']}/archive/print");
                    file = ResourceUtils.getFile(basePath + "/" + modelName+".fr3");
                    if(file.exists()){
                        sendFile(file);
                    }else{
                        file = ResourceUtils.getFile(basePath + "/" +modelName+".fr3");
                        if(file.exists())
                            sendFile(file);
                    }
                }catch (FileNotFoundException ignored)  {
                }
            }
        }else{
            String basePath = getEntityModel().getEnv().getExpr("${.vars['web.root']}/print");
            File file = new File(basePath, modelName+"-"+printType+".fr3");
            if(file.exists()){
                sendFile(file);
            }else {
                try{
                    basePath = getEntityModel().getEnv().getExpr("${.vars['egov.conf']}/archive/print");
                    file = ResourceUtils.getFile(basePath + "/" + modelName+"-"+printType+".fr3");
                    if(file.exists()){
                        sendFile(file);
                    }else{
                        file = ResourceUtils.getFile(basePath + "/" +modelName+"-"+printType+".fr3");
                        if(file.exists())
                            sendFile(file);
                    }
                }catch (FileNotFoundException ignored)  {
                }
            }
        }
        return null;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    @Override
    public Model getEntityModel() {
        if(modelName.equals("ygd"))
            return modelService.getModel("ythsw");
        return modelService.getModel(modelName);
    }


    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getArchiveModel(modelName).getTemplate("linkField");
            }catch (Exception ex){
                linkField="tm";
            }
        }
        return linkField;
    }

    /**
     * 为收文生成室编件号
     * @param mlh
     * @return
     */
    private int getSbjh(String mlh){
        try{
         ajhRange=ajhRangeService.getAjhRangesForGeneric("Wdyth",mlh);
        }catch (Exception ex){
            AjhRange ajhRangeTemp=new AjhRange();
            if(EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
                ajhRangeTemp.setDwdm(getDwdm());
            ajhRangeTemp.setMlh(mlh);
            ajhRangeTemp.setCurrentValue(0);
            ajhRangeTemp.setMinValue(0);
            ajhRangeTemp.setMaxValue(1000);
            ajhRangeTemp.setModelName("Wdyth");
            ajhRangeService.saveAjhRange(ajhRangeTemp);
            ajhRange=ajhRangeService.getAjhRangesForGeneric("Wdyth",mlh);
        }
        if(ajhRange.hasExhausted()){
            ajhRange.setMaxValue(ajhRange.getMaxValue()+100);
            ajhRangeService.saveAjhRange(ajhRange);
        }
        if(ajhRange!=null){
            sbjh=ajhRange.getNextValue();
        }
        return sbjh;
    }

    /**
     * 获取当前用户的单位代码
     *
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    /**
     * 将检索结果合并，并根据成文日期升序排序，日期相同则根据登记号升序排序，若日期为null,则放到后面
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    private List addAll(List ythSw,List ythFw,List ythNw){
        ArrayList<Object> tempList=new ArrayList<Object>();
        if(ythSw!=null)
            tempList.addAll(ythSw);
        if(ythFw!=null)
            tempList.addAll(ythFw);
        if(ythNw!=null)
            tempList.addAll(ythNw);
        Collections.sort(tempList, new Comparator() {
            public int compare(Object a, Object b) {
                int value=0;
                DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try{
                    Date  one =null;
                    if(PropertyUtils.getProperty(a,"cwrq")!=null)
                            one=dateFormat.parse(PropertyUtils.getProperty(a,"cwrq").toString());
                    Date  two =null;
                    if(PropertyUtils.getProperty(b,"cwrq")!=null)
                            two=dateFormat.parse(PropertyUtils.getProperty(b,"cwrq").toString());
                    if(one==null&&two!=null){
                        value=1;
                    }else if(one!=null&&two==null){
                        value=-1;
                    }else if(one!=null&&two!=null){
                        value=one.compareTo(two);
                        if(value==0){
                          int djh1=Integer.parseInt(PropertyUtils.getProperty(a,"djh").toString());
                          int djh2=Integer.parseInt(PropertyUtils.getProperty(b,"djh").toString());
                            value=djh1-djh2 < 0 ? -1:1;
                        }
                    }
                }catch (Exception ex){
                    logger.error(ex.toString());
                }
                return value ;
            }
        });
        return tempList;
    }
}
