package com.gtis.archive.service;

import com.gtis.archive.entity.Original;
import com.gtis.common.Page;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

import java.io.File;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-11-30
 */
public interface OriginalService {
    /**
     * 根据id获取原文
     *
     * @param id 原文id
     * @return 原文
     */
    Original getOriginal(String id);

    /**
     * 删除原文
     *
     * @param ids 原文id列表
     */
    void removeOriginal(String[] ids);

    /**
     * 保存原文
     *
     * @param original 原文
     */
    void saveOriginal(Original original);

    /**
     * 根据所有者获取原文
     *
     * @param ownerId 所有者id
     * @return 原文列表
     */
    List<Original> getOriginals(String ownerId);

    /**
     * 获取原文的所有者对象
     *
     * @param id 原文id
     * @return 所有者对象
     */
    Object getOriginalOwner(String id);

    /**
     * 获取原文文件
     *
     *
     * @param id 原文id
     * @param action
     * @return 预览文件
     */
    File getOriginalFile(String id, String action);

    /**
     * 获取原文的预览文件
     *
     * @param id 原文id
     * @return 预览文件
     */
    File getOriginalThumbFile(String id);

    /**
     * 保存原文文件
     *
     * @param original  原文
     * @param file      文件
     * @param overWrite 是否覆盖
     */
    void saveOriginalFile(Original original, File file, boolean overWrite);

    /**
     * 检索原文
     *
     * @param ownerId 所属
     * @param name     名称
     * @param start      位置
     * @param limit      分页大小
     * @return 原文分页对象
     */
    Page<Original> searchOriginal(String ownerId, String name, int start, int limit);

    /**
     * 是否存在原文
     * @param ownerId
     * @return
     */
    boolean hasOriginal(String ownerId);
}
