package com.gtis.archive.core.support.freemarker;

import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.apache.struts2.views.freemarker.StrutsClassTemplateLoader;
import org.springframework.util.Assert;

import javax.servlet.ServletContext;
import java.io.IOException;
import java.util.Locale;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-5
 */
public class FreemarkerManager extends org.apache.struts2.views.freemarker.FreemarkerManager {
    public static final String PREFIX = "s__";
    protected Configuration configuration;
    protected StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Template getTemplate(String name) throws IOException {
        return configuration.getTemplate(name);
    }

    public Template getTemplate(String name, Locale locale) throws IOException {
        return configuration.getTemplate(name, locale);
    }

    public Template getStringTemplate(String content) throws IOException {
        Assert.notNull(content);
        String key = stringToKey(content);
        if (stringTemplateLoader.findTemplateSource(key) == null) {
            stringTemplateLoader.putTemplate(key, content);
        }
        return getTemplate(key);
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    /**
     * 为了避免模板名冲突
     *
     * @param s
     * @return s
     */
    protected String stringToKey(String s) {
        return PREFIX + s;
    }

    @Override
    protected Configuration createConfiguration(ServletContext servletContext) throws TemplateException {
        if (configuration == null) {
            configuration = super.createConfiguration(servletContext);
        }
        return configuration;
    }

    @Override
    protected TemplateLoader createTemplateLoader(ServletContext servletContext, String templatePath) {
        TemplateLoader templateLoader = configuration.getTemplateLoader();
        return templateLoader != null ?
                new MultiTemplateLoader(new TemplateLoader[]{
                        new WebappTemplateLoader(servletContext),
                        new StrutsClassTemplateLoader(),
                        templateLoader,
                        stringTemplateLoader
                }) :
                new MultiTemplateLoader(new TemplateLoader[]{
                        new WebappTemplateLoader(servletContext),
                        new StrutsClassTemplateLoader(),
                        stringTemplateLoader
                });
    }
}
