<@layout.main import="jquery,ext">
<style type="text/css">
    .selected{
        background: rgba(176, 176, 176, 0.67);
    }
    .models{
        width: 140px;
        height: 250px;
        overflow: auto;
        border-bottom:solid  1px #dfdfdf;
        border-left: solid  1px #dfdfdf;
        border-top: solid  1px #dfdfdf;
    }
    .model{
        border-bottom: dashed  1px #dfdfdf;
    }
</style>
<@layout.script name="js/ext/ux/ComboPageSize.js"/>
<table>
    <tr>
        <td class="archiveLeftPanel">
            <div class="a-box">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="min-height:500px;_height:500px;padding-top:10px;">
                            <dl class="a-side">
                                <dt>全文检索</dt>
                                <dd>
                                    <form action="${ctx.env['solr.url']}" method="get" target="_blank">
                                        <input type="hidden" name="bid" value="archive"/>
                                        <table id="search-box" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td class="input">
                                                    <input type="text" name="keyword" class="text" style="width:120px;"/>
                                                    <input type="submit" class="sub" value=""/>
                                                    <input type="hidden" name="cid" value="a_${modelName}"/>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                </dd>
                            </dl>
                            <dl class="a-side">
                                <dt>切换档案分类</dt>
                                <#if ctx.env['classifyViewMode']=='normal'>
                                    <dd>
                                        <select style="width:140px;" onchange="location.href='archive.action?modelName='+this.value">
                                            <#list tree as res>
                                                <#if res.children??><#list res.children as res>
                                                    <option value="${res.name}"<#if res.id==treeId> selected="selected"</#if>>${res.text}</option>
                                                </#list></#if>
                                            </#list>
                                        </select>
                                    </dd>
                                <#else>
                                    <dd>
                                        <div class="models">
                                            <table style="width:100%;" class="a-table"  cellpadding="0" cellspacing="0">
                                                <#list tree as res>
                                                    <#if res.children??>
                                                        <#list res.children as res>
                                                            <tr <#if res.id==treeId> class="selected"</#if>>
                                                                <td class="model"><a href="archive.action?modelName=${res.name}">${res.text}</a></td>
                                                            </tr>
                                                        </#list>
                                                    </#if>
                                                </#list>
                                            </table>
                                        </div>
                                    </dd>
                                </#if>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </td>
        <td class="archiveRightPanel">
            <div class="a-box">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="height:70px;padding-top:10px;">
                            <div class="a-tab clearfix">
                                <a href="archive.action?modelName=${modelName?substring(0,modelName?index_of("_jn"))}" class="tab">案 卷</a>
                                <a href="#" class="tab on">卷 内</a>
                                <#if ctx.env['classifyViewMode']=='checkbox'>
                                    <input type="checkbox" checked="true" onclick="changeDocByCheck()" id="wljCheck" style="margin:6px 0 5px 5px;float:left;">
                                    <a href="#" class="btn" id="wlj-btn">未立卷</a>
                                    <input type="checkbox" checked="true" onclick="changeDocByCheck()" id="yljCheck" style="margin:6px 0 5px 5px;float:left;">
                                    <a href="#" class="btn" id="ylj-btn">已立卷</a>
                                <#else>
                                <a href="#" class="btn active" onclick="return changeDocType('wlj');" id="wlj-btn" style="margin-left: 10px;">未立卷</a><div class="sep">|</div>
                                <a href="#" class="btn" onclick="return changeDocType('ylj');" id="ylj-btn">已立卷</a>
                                </#if>
                                <a href="#" onclick="return showAdvancedSearch();" style="display:block;float:right;margin:0 10px 0 5px;line-height: 20px;">高级检索</a>
                                <div id="searchBox"></div>
                            </div>
                            <div class="a-opt clearfix" id="opt-box">
                                <a class="a-btn a-ctl" href="#" onclick="return showDocument();" id="addDocument">添加</a>

                                <#--<#if ctx.hasEnv('jiangyin.enable')>-->
                                    <#--<#if ctx.isAdmin()>-->
                                        <#--<a class="a-btn a-ctl" href="#" onclick="return editDocument();" id="editDocument">修改</a>-->
                                        <#--<a class="a-btn a-ctl" href="#" onclick="return delDocument();" id="delDocument">删除</a>-->
                                    <#--</#if><#else>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return editDocument();" id="editDocument">修改</a>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return delDocument();" id="delDocument">删除</a>-->
                                <#--</#if>-->
                                <a class="a-btn a-ctl" href="#" onclick="return editDocument();" id="editDocument">修改</a>
                                <a class="a-btn a-ctl" href="#" onclick="return delDocument();" id="delDocument">删除</a>

                                <a class="a-btn" href="#" onclick="return showOriginal();">原文管理</a>
                                <#--<a class="a-btn" href="#" onclick="return ljDocument();" id="ljDocument" style="display:none;">立卷</a>-->

                                <#if ctx.hasEnv('jiangyin.enable')>
                                    <a class="a-btn a-ctl" href="#" onclick="return showLoan();" id="showLoan">借阅登记</a>
                                    <a class="a-btn a-ctl" href="#" onclick="return loanCar();" id="loanCar">添加到借阅车</a>
                                </#if>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="a-box" id="search-item" style="display:none;">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame clearfix"
                             style="margin-top:10px;padding:5px 0 5px 5px;position:relative;">
                            <span class="search-item-close" onclick="hideAdvancedSearch();"></span>
                            <div style="float:right;padding:3px 25px 8px 0;">
                                <a class="a-btn" href="#" onclick="return addSearchItem();">增加过滤</a>
                                <a class="a-btn" href="#" onclick="return advancedSearch();">检 索</a>
                            </div>
                            <form class="clearfix" id="search-item-box"></form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="a-box" style="margin-top:10px;">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="min-height:422px;_height:422px;">
                            <div id="documentsCt"></div>
                            <div id="pagingToolbar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </td>
    </tr>
</table>
<textarea style="display:none;" id="documentTpl">
    <table style="width:100%;" class="a-table" cellpadding="0" cellspacing="0">
        <tr>
            <th style="width:1px;"><input type="checkbox" onclick="changeSelect(this);" value=""></th>
            <#--<#if ctx.hasEnv('jiangyin.enable')>-->
                <#--<th style="width: 40px">全宗号</th>-->
                <#--<th style="width: 40px">目录号</th>-->
                <#--<th style="width: 40px">案卷号</th>-->
            <#--</#if>-->
            <#list showFields?keys as name>
                <#assign width=showFields[name]['width']!-1/>
                <th<#if width!=-1> style="width:${width}px;"</#if>><a href="#" onclick="return archiveSortBy('${name}');" title="点击标题排序"><#if name=='archiveId'><#if ctx.env['classifyViewMode']=='checkbox'>卷内状态</#if><#else>${fields[name].title}</#if></a></th>
            </#list>
            <th style="width:30px;"></th>
            <#if ctx.hasEnv('jiangyin.enable')><th style="width:30px;"></th></#if>
            <#--<th>题名</th>-->
            <#--<th>页号</th>-->
            <#--<th>责任者</th>-->
            <#--<th style="width:120px;">日期</th>-->
        </tr>
        <tpl for=".">
            <tr class='{[xindex%2==0?"even":"odd"]}'>
                <td style="width:1px;"><input type="checkbox" value="{id}"></td>
                <#--<#if ctx.hasEnv('jiangyin.enable')>-->
                    <#--<td>{archive:qzh}</td>-->
                    <#--<td>{archive:mlh}</td>-->
                    <#--<td>{archive:ajh}</td>-->
                <#--</#if>-->
                <#list showFields?keys as name>
                    <#assign fd=showFields[name]/>
                    <#assign max=fd['max']!-1/>
                    <td>
                        <#if name==linkField>
                            <a href="#" onclick="return showDocument('{id}','{archiveId}');" >{${name}:def("无"<#if max!=-1>,${max}</#if>)}</a>
                        <#elseif name=='archiveId'><#if ctx.env['classifyViewMode']=='checkbox'>{archiveId:format}</#if>
                        <#else>{${name}:<#if fd['date']??>renderDate("${fd['date']}")<#else>def<#if max!=-1>("",${max})</#if></#if>}
                        </#if>
                    </td>
                </#list>
                <td><a class="jn-btn" href="#"  onclick="return showOriginal('{id}');" title="原文管理">原文</a></td>
                <#if ctx.hasEnv('jiangyin.enable')><td>{hasOriginal:style}</td>
                </#if>
                <#--<td><a href="#" onclick="return showDocument('{id}');">{tm:def("无题名",20)}</a></td>-->
                <#--<td>{yh:this.def}</td>-->
                <#--<td>{zrz:this.def}</td>-->
                <#--<td>{rq:def}</td>-->
            </tr>
        </tpl>
    </table>

</textarea>
<textarea style="display:none;" id="searchTpl">
    <div class="search-item">
        <select name="name" style="width:120px;">
            <#if fields??><#list fields?values as field>
                <option value="${field.name}">${field.title}</option>
            </#list></#if>
        </select>
        <select name="cd" style="width:50px;">
            <option value="like">类似</option>
            <option value="eq">等于</option>
            <option value="ne">不等于</option>
            <option value="gt">大于</option>
            <option value="lt">小于</option>
            <option value="notNull">不为空</option>
            <option value="isNull">为空</option>
        </select>
        <input type="text" name="value" size="13"/>
        <span class="search-item-close" onclick="$(this).parent().remove();"></span></div>
</textarea>
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript">
var win, store,_type,modelName=getModelName('${modelName}'),treeId='${treeId}',archiveWin;
var perm = ${permJson!'{}'};
var _jsessionid = '${sessionId}';
var type='win';

/**
 * 立卷状态的render
 * @param v
 */
Ext.util.Format.format=function(v){
    if (v!=null&&v!="") return "<img src=\"/archive/img/ygd.png\" alt=\"已立卷\" title=\"已立卷\" class='img' />";
    else return "<img src=\"/archive/img/wgd.png\" alt=\"未立卷\" title=\"未立卷\" class='img' />";

}

Ext.util.Format.style=function(v){
    if(!v)
        return "<img src=\"/archive/img/wuog.png\" alt=\"未上传原文\" onclick=\"return showOriginal(null,null);\" title=\"未上传原文\" class='img' />";
    return null;
}

Ext.util.Format.mlh=function(v){
    debugger;
    var mlh;
    if(v!=null){
        if(v.mlh==null){
            var archive=getObject(v);
            mlh=archive.mlh;
        }else{
            mlh= v.mlh;
        }
    }
    return mlh;
}
Ext.util.Format.ajh=function(v){
    var ajh;
    if(v!=null){
        if(v.ajh==null){
            var archive=getObject(v);
            ajh=archive.ajh;
        }else{
            ajh= v.ajh;
        }
    }
    return ajh;
}
Ext.util.Format.qzh=function(v){
    var qzh;
    if(v!=null){
        if(v.qzh==null){
            var archive=getObject(v);
            qzh=archive.qzh;
        }else{
            qzh= v.qzh;
        }
    }
    return qzh;
}


function getObject(archive){
    if(archive.$ref!=null){
        var ref=archive.$ref;
        var index=ref.substring(ref.indexOf("[")+1,ref.indexOf("]"));
        var temp=store.data.items[index].data.archive;
        return getObject(temp);
    }else{
        return archive;
    }
}

function getJsessionidUrl(url) {
    var index = url.indexOf('?');
    if (index > -1) {
        return url.substring(0, index) + ';jsessionid=' + _jsessionid + url.substr(index);
    } else {
        return url + ';jsessionid=' + _jsessionid;
    }
}
function addSearchItem() {
    var item = $('#search-item-box').append($('#searchTpl').val()).children(":last");
    item.hover(
            function () {
                $(this).addClass("hover");
            },
            function () {
                $(this).removeClass("hover");
            });
}

/**
 * checkbox方式选择立卷状态
 */
function changeDocByCheck(){
    if ($('#wljCheck').attr("checked") && !$('#yljCheck').attr("checked"))
        changeDocType('wlj');
    else if (!$('#wljCheck').attr("checked") && $('#yljCheck').attr("checked"))
        changeDocType('ylj');
    else
        changeDocType('all');

}

function changeDocType(type, notReload) {
    if (type == 'ylj') {
        $('#addDocument,#ljDocument').hide();
        $('#wlj-btn').removeClass('active');
        $('#ylj-btn').addClass('active');
    } else if(type == 'wlj') {
        $('#wlj-btn').addClass('active');
        $('#ylj-btn').removeClass('active');
        if (perm.edit) {
            $('#addDocument,#ljDocument').show();
        }
    }
    else {
        if (perm.edit) {
            $('#addDocument,#ljDocument').show();
        }
        $('#wlj-btn').addClass('active');
        $('#ylj-btn').addClass('active');
    }
    _type = type;
    store.setBaseParam('type', type);
    if (!notReload){
        store.removeListener('load', showProgressBar,this);
        store.load();
    }
}

function changeArchiveType(type, reload) {
    if (type == 'ylj') {
        $('#addDocument,#ljDocument').hide();
        $('#wlj-btn').removeClass('active');
        $('#ylj-btn').addClass('active');
    } else {
        if (perm.edit) {
            $('#addDocument,#ljDocument').show();
        }
        $('#wlj-btn').addClass('active');
        $('#ylj-btn').removeClass('active');
    }
    _type = type;
    store.setBaseParam('type', type);
    if (reload)
        store.load();
}

var aOrder = 'ASC';

function archiveSortBy(field) {
    debugger;
    store.singleSort(field, aOrder);
    aOrder = aOrder == 'ASC' ? 'DESC' : 'ASC';
    return false;
}

function onPermChange(perm) {
    if (perm.edit) {
        $('#opt-box a.a-ctl').show();
    } else {
        $('#opt-box a.a-ctl').hide();
    }
//    changeArchiveType(_type);
    changeDocType(_type);
}

function showAdvancedSearch() {
    if ($("#search-item-box .search-item").length == 0) {
        addSearchItem();
    }
    $('#search-item').toggle();
}

function showProgressBar(){
    Ext.MessageBox.progress( '正在检索数据请稍后.......') ;
    setTimeout(function(){
        for(var i=0;i<6;i++)
            update(i);
    },100);
}
function update(v){
    Ext.MessageBox.updateProgress(v);
}
function advancedSearch() {
    var condition = Ext.lib.Ajax.serializeForm('search-item-box');
    store.addListener('load', showProgressBar,this);
    store.setBaseParam('condition',condition.replace(/=/g, ',').replace(/&/g, ';'));
    store.load({callback:function(a,b,c){
        if(c){
            setTimeout(function () {
                Ext.MessageBox.hide();
                store.removeListener('load', showProgressBar,this);
            },500) ;

        }
    }});
}

function hideAdvancedSearch() {
    $('#search-item').hide();
    store.setBaseParam('condition', '');
    store.load();
}
var ogDs;
function showOriginal(id) {
    if(!id){
        var ids = getSelectIds();
        if (ids.length > 1 || ids.length == 0) {
            alert('请选择一个档案!');
            return;
        }
        id = ids[0];
    }
    ogDs = new Ext.data.JsonStore({
        url: 'og!list.action?ownerId=' + id,
        autoLoad:true,
        root: 'items',
        fields: [
            'id', 'name','fileSize','updateTime'
        ]
    });
    var ogSm = new Ext.grid.CheckboxSelectionModel();
    var formatSize = function(size, p, record) {
        return Ext.util.Format.fileSize(size);
    };
    var ogGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds: ogDs,
        height:250,
        sm: ogSm,
        loadMask: true,
        stripeRows: true,
        region: 'center',
        bbar: new Ext.PagingToolbar({
            pageSize: 20, //每页显示几条数据
            store: ogDs,
            displayInfo: true,
            displayMsg: '{0} - {1} 共 {2} 条',
            emptyMsg: "没有记录返回" }),
        cm: new Ext.grid.ColumnModel([
            //new Ext.grid.RowNumberer(),//显示行号
            ogSm,
            {header: "名称", width: 400, sortable: true, dataIndex: 'name'},
            {header: "大小", width: 100, sortable: true, dataIndex: 'fileSize',renderer: formatSize},
            {header: "上传时间", width: 150, sortable: true, dataIndex: 'updateTime'}
        ]),
        tbar: [
            {
                text     :'查看',
                iconCls:'preview',
                handler  : function() {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    }
                    var nids = [];
                    for (var i = 0; i < ogSm.getSelections().length; i++) {
                        nids.push(ogSm.getSelections()[i].data.id);
                    }
                    showPreview(nids, ogSm.getSelections()[0].data.id);
                }
            },
            {
                text     :'上传',
                iconCls:'upload',
                hidden:!perm.edit,
                handler  : function() {
                    var getUrl = function(url) {
                        return getJsessionidUrl(url + "?modelName=${modelName}");
                    };
                    var uploadDialog = new UploadDialog({
                        getUrl:getUrl,
                        maxSize:5368709120,
                        typeDescription:'所有文件',
                        autoClose:this.autoClose || true,
                        fileTypes:'*.*'
                    });
                    uploadDialog.on('close', function() {
                        ogDs.reload();
                    });
                    uploadDialog.show(id);
                }
            },
            {
                text     :'关联',
                iconCls:'reset',
                hidden:!perm.edit,
                handler  : function() {
                    if (linkWin != null) {
                        linkWin.show();
                    }
                    else
                        showLinkWin(id);
                }
            },
            {
                text     :'打印',
                iconCls:'print',
                hidden:!perm.print,
                handler  : function() {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    }
                    showPrint(ogSm.getSelections()[0].data.id);
                }
            },
            {
                text  :'下载'  ,
                iconCls:'download',
                hidden:!perm.download,
                handler: function() {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    }
                    window.open('og!get.action?id=' + ogSm.getSelections()[0].data.id);
                }
            },
            {
                text  :'权限'  ,
                iconCls:'download',
            hidden:<#if ctx.hasEnv('originalPermission.enable')>!perm.edit<#else>true</#if>,
                handler: function() {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　没有原文被选择!　');
                        return;
                    }
                    setPermission(ogSm.getSelections()[0].data.id);
                }
            },
            {
                text     :'删除',
                iconCls:'delete',
                hidden:!perm.edit,
                handler  : function() {
                    if (ogSm.getSelections().length == 0) {
                        alert('　　没有原文被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(ogSm.getSelections(), function(s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url: 'og!remove.action',
                        params:{id:p},
                        success: function(r) {
                            ogDs.reload();
                        }
                    });
                }
            },
            '->',
            new Ext.ux.form.SearchField({
                style:{'margin':'0,0,0,150px'},
                store: ogDs,
                width:150,
                renderTo:'searchBox'
            })
        ],
        listeners:{
            rowdblclick:function(g, index, e) {
                if (perm.download) {
                    var id = ogDs.getAt(index).id;
                    showPreview([id], id);
                }
            },
            render:function(g) {
                var store = g.getStore();
                var view = g.getView();
                g.tip = new Archive.OgTip({
                    dismissDelay:0,
                    target: view.mainBody,
                    delegate: '.x-grid3-row',
                    autoWidth:!Ext.isIE6,
                    renderTo: document.body,
                    listeners: {
                        beforeshow: function(tip) {
                            var rowIndex = view.findRowIndex(tip.triggerElement);
                            tip.body.update('<img src="' + 'og!thumb.action?modelName=' + modelName + '&id=' + store.getAt(rowIndex).id + '"/>');
                        }
                    }
                });
            }
        }
    });
    var ogWin = new Ext.Window({
        title: '原文',
        closable:true,
        modal: true,
        width:700,
        height:500,
        layout: 'fit',
        border:false,
        resizable:false,
        buttons: [
            {
                text     : '关闭',
                handler  : function() {
                    ogWin.close();
                   <#if ctx.hasEnv('jiangyin.enable')>
                        store.reload();
                   </#if>
                }
            }
        ],
        items:ogGrid
    });
    ogWin.show();
    return false;
}

function loanCar(){
    var loanIds=getSelectIds();
    if(loanIds.length==0){
        alert("请选择要借阅的档案");
        return;
    }
    var name= modelName+"_jn";
    Ext.Ajax.request({
        url:'borrow!addLoanCar.action',
        params:{idString:loanIds, archiveType:name},
        success:function (rp) {
            var message=rp.responseText;
            if(message=="success"){
                alert("添加成功");
            }else{
                alert("添加失败");
            }
        }
    });
}


function showLoan(id, archiveId) {
    var ids = getSelectIds(archiveId, id);
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
        return;
    }
    var model=modelName+"_jn";
    win = new Ext.Window({
        title:id ? '借阅登记' : '借阅登记',
        closable:true,
        modal:true,
        width:400,
        height:240,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'立即归还',
            hidden:<#if ctx.hasEnv('jiangyin.enable')>false<#else >true</#if>,
                handler:function(){
                    $('#loanFrame')[0].contentWindow.backNow();
                    $('#loanFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'借阅',
                handler:function () {
                    $('#loanFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="loan-entity.action?modelName=Loan&type='+model+"&"+ Ext.urlEncode({archiveId:ids}) + '" id="loanFrame"></iframe>'
    });
    win.show();
}



function showLinkWin(id) {
    var tree = new Ext.tree.TreePanel({
        autoScroll: true,
        loader: new Ext.tree.TreeLoader(),
        root:new Ext.tree.AsyncTreeNode({
            id:"root",
            text: '/',
            iconCls:'root'
        }),
        listeners:{
            render:function(tree) {
                tree.getRootNode().expand(false, false);
            },
            beforeload:function(node) {
                this.loader.dataUrl = 'og!link.action?id=' +encodeURIComponent(node.id)
            }
        }
    });
    tree.on('checkchange', function(node, flag) {
        node.cascade(function(node) {
            node.attributes.checked = flag;
            node.ui.checkbox.checked = flag;
            return true;
        });
    });
    linkWin = new Ext.Window({
        title: '文件关联目录树',
        closable:true,
        modal: true,
        width:600,
        height:450,
        layout: 'fit',
        border:false,
        resizable:false,
        closeAction:'hide',
        items:tree,
        buttons: [
            {
                text     : '关联',
                handler  : function() {
                    var ids = [];
                    var nodes = tree.getChecked();
                    for (var i = 0; i < nodes.length; i++) {
                        ids.push(nodes[i].id);
                    }
                    Ext.Ajax.request({
                        url: 'og!saveLink.action?ownerId=' + id,
                        params:{id:ids},
                        success: function(r) {
                            Ext.MessageBox.alert("提示", "关联成功");
                            linkWin.hide();
                            for (var i = 0; i < nodes.length; i++) {
                                nodes[i].getUI().toggleCheck(false);
                                nodes[i].attributes.checked = false;
                            }
                            ogDs.load();
                        }
                    });
                }
            },
            {
                text     : '关闭',
                handler  : function () {
                    linkWin.hide();
                    ogDs.load();
                }
            }
        ]
    });
    linkWin.show();
}

function setPermission(id) {
    var pDs = new Ext.data.JsonStore({
        url: 'og!listPermission.action?id=' + id,
        autoLoad:true,
        root: 'items',
        fields: ['id', 'userId','userName','operation','expireTime']
    });
    var pSm = new Ext.grid.CheckboxSelectionModel();
    var pGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds: pDs,
        height:250,
        sm: pSm,
        loadMask: true,
        stripeRows: true,
        region: 'center',
        cm: new Ext.grid.ColumnModel([
            pSm,
            {header: "用户", width: 100, sortable: true, dataIndex: 'userName'},
            {header: "权限", width: 200, sortable: true, dataIndex: 'operation',renderer:function(v) {
                return v == 'download' ? '下载' : '查看';
            }},
            {header: "到期时间", width: 200, sortable: true, dataIndex: 'expireTime'}
        ]),
        tbar: [
            {
                iconCls:'add',
                text     :'添加',
                handler  : function() {
                    var fp = new Ext.FormPanel({
                        labelWidth: 80,
                        url:'og!addPermission.action?op.originalId=' + id,
                        frame:true,
                        border:false,
                        bodyStyle:'padding:5px',
                        defaultType: 'textfield',
                        items: [
                            {
                                xtype:'combo',
                                fieldLabel: '用户',
                                hiddenName:'op.userId',
                                store: new Ext.data.JsonStore({
                                    url: 'og!listUsers.action',
                                    fields: ['userId','userName']
                                }),
                                valueField:'userId',
                                displayField:'userName',
                                mode:'remote',
                                typeAhead: true,
                                triggerAction: 'all',
                                anchor:'100%',
                                listeners:{
                                    'select': function(cb, record) {
                                        fp.form.findField('op.userName').setValue(record.data['userName']);
                                    }
                                }
                            },
                            {
                                xtype:'combo',
                                fieldLabel: '权限',
                                hiddenName:'op.operation',
                                store: new Ext.data.ArrayStore({
                                    fields: ['name', 'value'],
                                    data : [
                                        ["查看",'view'],
                                        ['下载','download']
                                    ]
                                }),
                                value:'download',
                                valueField:'value',
                                displayField:'name',
                                typeAhead: true,
                                mode: 'local',
                                triggerAction: 'all',
                                anchor:'100%'
                            },
                            {
                                fieldLabel: '到期时间',
                                xtype:'datefield',
                                name: 'op.expireTime',
                                anchor:'100%',
                                format:'Y-m-d'
                            },
                            {
                                xtype:'hidden',
                                name: 'op.userName'
                            }
                        ],
                        buttons: [
                            {
                                text:'保存',
                                handler: function() {
                                    if (fp.getForm().isValid()) {
                                        fp.getForm().submit({
                                            waitMsg: '正在保存...',
                                            success: function() {
                                                addWin.close();
                                                pDs.reload();
                                            },
                                            failure:function(fp, action) {
                                                Ext.MessageBox.alert('失败', '保存失败');
                                            },
                                            scope:this
                                        });
                                    }
                                },
                                scope:this
                            },
                            {
                                text: '关闭',
                                handler: function() {
                                    addWin.close();
                                }
                            }
                        ]
                    });
                    var addWin = new Ext.Window({
                        title: '原文权限',
                        closable:true,
                        modal: true,
                        width:300,
                        height:200,
                        layout: 'fit',
                        border:false,
                        resizable:false,
                        items:fp
                    });
                    addWin.show();
                }
            },
            {
                iconCls:'delete',
                text     :'删除',
                handler  : function() {
                    if (pSm.getSelections().length == 0) {
                        alert('　　没有权限被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(pSm.getSelections(), function(s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url: 'og!removePermission.action',
                        params:{id:p},
                        success: function(r) {
                            pDs.reload();
                        }
                    });
                }
            }
        ]
    });
    var pWin = new Ext.Window({
        title: '原文权限',
        closable:true,
        modal: true,
        width:600,
        height:400,
        layout: 'fit',
        border:false,
        resizable:false,
        buttons: [
            {
                text     : '关闭',
                handler  : function() {
                    pWin.close();
                }
            }
        ],
        items:pGrid
    });
    pWin.show();
}

function showPreview(nids, nid) {
    if (!Ext.isDefined(window.hasEPreOcx)) {
        try {
            new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
            window.hasEPreOcx = true;
        } catch(e) {
            window.hasEPreOcx = false;
        }
    }
    if (window.hasEPreOcx) {
        var link = location.href;
        link = link.substr(link.indexOf('//') + 2);
        link = link.substring(0, link.lastIndexOf('/'));
        location.href = "epre://" + link + '/og!preview.action?nid=' + nid + '&nids=' + nids;
    } else {
        window.open('og!get.action?preview=true&id=' + nid);
    }
}
function showDocument(id,archiveId) {
    win = new Ext.Window({
        title: id ? '编辑卷内' : '添加卷内',
        closable:true,
        modal: true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons: [
            {
                text:"查看案卷",
                hidden:(!id),
                handler:function(){
                    debugger;
                    if(archiveId==""||archiveId==null)
                        return alert("当前卷内没有案卷信息");
                    win.close();
                    checkedArchive(archiveId,id);
                }
            },
            {
                text:"原文",
                hidden:!perm.edit || (!id),
                handler:function(){
                    showOriginal(id);
                }
            },
            {
                text     :'保存',
                hidden:!perm.edit,
                handler  : function() {
                    $('#documentFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text     : '关闭',
                handler  : function() {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="doc-entity.action?modelName=${modelName}&id=' + (id || '') + '" id="documentFrame"></iframe>'
    });
    win.show();
    return false;
}

function showPrint(nid) {
    var width = 0, height = 0, srcWidth, srcHeight;
    var win = new Ext.Window({
        cls:'og',
        title: '打印原文',
        closable:true,
        modal: true,
        width:Ext.lib.Dom.getViewWidth() * .9,
        height:Ext.lib.Dom.getViewHeight() * .9,
        border:false,
        resizable:false,
        tbar: [
            {
                text     :'打印',
                iconCls:'print',
                handler  : function() {
                    var print = Ext.getDom('printFrame').contentWindow.webPrint;
                    var link = location.href;
                    print.ContentURL = getJsessionidUrl(link.substring(0, link.lastIndexOf('/')) + '/og!print.action?nid=' + nid + (width > 0 ? '&width=' + width : '') + (height ? '&height=' + height : ''));
                    print.marginBottom = print.marginLeft = print.marginRight = print.marginTop = 0;
                    print.Preview();
                }
            },
            {
                text     :'放大',
                iconCls:'zoom-out',
                handler  : function() {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 1.2;
                    img.height = height = height * 1.2;
                }
            },
            {
                text     :'缩小',
                iconCls:'zoom-in',
                handler  : function() {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 0.8;
                    img.height = height = height * 0.8;
                }
            },
            {
                text     :'默认大小',
                iconCls:'reset',
                handler  : function() {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    img.width = width = srcWidth;
                    img.height = height = srcHeight;
                }
            }
        ],
        buttons: [
            {
                text     : '关闭',
                handler  : function() {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="auto" frameborder="0" style="width:100%;height:100%;" src="og!print.action?nid=' + nid + '" id="printFrame"></iframe>'
    });
    win.show();
    return false;
}
function ljDocument() {

    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个卷内!');
    }
    else {
        showArchive("", ids);
    }

}
function showArchive(id, ids) {
    win = new Ext.Window({
        title: id ? '编辑档案' : '添加档案',
        closable:true,
        modal: true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons: [
            {
                text     :'保存',
                handler  : function() {
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text     : '关闭',
                handler  : function() {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="archive!edit.action?modelName=${modelName}&treeId=${treeId}&documentId=' + (ids || '') + '" id="archiveFrame"></iframe>'
    });
    win.show();
    return false;
}
function editDocument() {
    debugger;
    var ids = getSelectIds();
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个档案!');
    } else {
        var acrhiveId=getArchiveId(ids);
        showDocument(ids.pop(),acrhiveId);
    }
}

function getArchiveId(id){
    debugger;
    for(var i=0;i<store.data.items.length;i++){
        if(store.data.items[i].id==id)
            return store.data.items[i].data.archiveId;
    }
    return null;

}
function onResize(w, h) {
    debugger;
    if(type=="win"){
        if(win!=null){
            win.setWidth(w + 30);
            win.setHeight(h + 90);
            win.center();
        }
    }else{
        if(archiveWin!=null){
            archiveWin.setWidth(w + 30);
            archiveWin.setHeight(h + 90);
            archiveWin.center();
        }
    }
}
function delDocument() {
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个卷内!');
    } else {
        if (confirm('确定要删除吗？')) {
            Ext.Ajax.request({
                url: 'doc!remove.action?modelName=${modelName}',
                params:{id:ids},
                success: function(r) {
                    store.reload();
                }
            });
        }
    }
}

var isLoan;
function onDocumentComplete(result, msg) {
    win.close();
    if (result) {
        store.reload();

    } else {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    }
    showDocument();
}
function onComplete(result, msg) {
    debugger;
    win.close();
    if (result) {
        store.reload();
        Ext.MessageBox.alert('提示', '　　' + msg + '　　');
    } else {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    }
}

function checkedArchive(id,ids){
    archiveWin = new Ext.Window({
        title:  '查看档案',
        closable:true,
        modal: true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons: [
            {
                text     : '关闭',
                handler  : function() {
                    archiveWin.close();
                    type="win";
                    showDocument(ids,id);
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="archive-entity.action?modelName=' + modelName + '&treeId=' + treeId + (id ? '&id=' + id : '') + '" id="archiveFrame"></iframe>'
    });
    type="archiveWin";
    archiveWin.show();
    return false;
}

function getModelName(jn){
    debugger;
    if(jn==null)
        return null;
     return jn.substring(0,jn.indexOf("_jn"));
}

function getSelectIds() {
    var ids = [];
    $('#documentsCt [type="checkbox"]').each(function() {
        if ($(this).attr("checked")) {
            if (this.value)
                ids.push(this.value);
        }
    });
    return ids;
}
$(function() {
    store = new Ext.data.JsonStore({
        url: 'doc!list.action?modelName=${modelName}',
        root: 'items',
        totalProperty: 'totalCount',
        fields: [
                'id','archiveId','hasOriginal',<#list showFields?keys as name>, '${name}'</#list>
            //'tm', 'rq','zrz','yh','id'
        ],
        baseParams:{limit:${limit}}
    });
    var tpl = Ext.XTemplate.from('documentTpl');
    tpl.def = function(v) {
        return v ? v : "";
    };
    var dv = new Ext.DataView({
        store: store,
        tpl: tpl,
        autoHeight:true,
        multiSelect: true,
        overClass:'x-view-over',
        itemSelector:'tr.a-item',
        renderTo:'documentsCt'
    });
    new Ext.PagingToolbar({
        plugins:new Ext.ux.ComboPageSize({ addToItem: false, prefixText: '每页', postfixText: '条'}),
        renderTo:'pagingToolbar',
        pageSize: ${limit},
        store: store,
        displayInfo: true,
        displayMsg: '{0} - {1} 共 {2} 条',
        emptyMsg: "没有记录返回"
    });
    var sb=new Ext.ux.form.SearchField({
        store:store,
        width:150,
        renderTo:'searchBox'
    });
    <#if id??>
        changeDocType('${type!}', true);
        sb.setRawValue('${id}');
        sb.onTrigger2Click();
    <#elseif ctx.env['classifyViewMode']=='checkbox'>
        changeDocType('all');
    <#else>
        changeDocType('ylj');
    </#if>
    onPermChange(perm);
});
</script>
</@layout.main>
