<#-- core -->

<#-- base html -->
<#macro html title="" import="">
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width">
    <title>${title}</title>
    <script type="text/javascript" language="javascript">
        var rootPath = "${base}";
    </script>
    <#if import??>
        <#list import?split(",") as lib>
            <#if lib?trim != "">
                <#switch lib>
                    <#case "jquery">
                        <@script name="resources/js/vendor/jquery-1.10.1.min.js"></@script>
                        <#break />
                    <#case "swf">
                        <@script name="resources/js/swfobject.js"></@script>
                        <#break />
                    <#case "bootstrap">
                        <@script name="resources/js/vendor/modernizr-2.6.2-respond-1.1.0.min.js"></@script>
                        <@script name="resources/js/vendor/bootstrap.min.js"></@script>
                        <@style name="resources/css/bootstrap.min.css"></@style>
                        <@style name="resources/css/bootstrap-responsive.min.css"></@style>
                        <#break/>
                    <#case "main">
                        <@style name="resources/css/main.css"></@style>
                        <@script name="resources/js/main.js"></@script>
                        <#break/>
                    <#case "ext">
                        <@style name="js/ext/resources/css/ext-all.css"/>
                        <@style name="js/ext/resources/css/xtheme-gray.css"/>
                        <@script name="js/ext/ext-base.js"/>
                        <@script name="js/ext/ext-all.js"/>
                        <@script name="js/ext/ext-lang-zh_CN.js"/>
                        <#break/>
                    <#default>
                        <@style name="resources/css/${lib}.css"></@style>
                        <@script name="resources/js/${lib}.js"></@script>
                </#switch>
            </#if>

        </#list>
    </#if>
</head>
<body>
    <#nested />
</body>
</html>
</#macro>

<#-- main html -->
<#macro main title="">
    <@html title="${title!}" import="jquery,bootstrap,main,ext">
    <div id="container">
    <div class="navbar  navbar-fixed-top">
        <div class="navbar-inner">
            <div class="container">
                <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </a>
                <a class="brand" href="#">档案管理系统</a>
                <div class="nav-collapse collapse">
                    <ul class="nav">
                        <li class="active"><a href="home.action">首页</a></li>
                        <#if admin>
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">档案设置<b
                                        class="caret"></b></a>
                                <ul class="dropdown-menu">
                                <li><a href="admin/model.action">业务设置</a></li>
                                    <li><a href="admin/tree.action" >分类管理</a></li>
                                    <#if !ctx.hasEnv('jiangyin.enable')>
                                    <li><a href="admin/ajh.action" >案卷号管理</a></li>
                                    </#if>
                                    <li><a href="admin/permission.action" >权限管理</a></li>
                                </ul>
                            </li>

                            <#--<li><a href="admin/model.action">业务设置</a></li>-->
                            <#--<li><a href="admin/tree.action" >分类管理</a></li>-->
                            <#--<#if !ctx.hasEnv('jiangyin.enable')>-->
                                <#--<li><a href="admin/ajh.action" >案卷号管理</a></li>-->
                            <#--</#if>-->
                            <#--<li><a href="admin/permission.action" >权限管理</a></li>-->
                        </#if>
                        <#if ctx.hasEnv('huCha.enable')>
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">档案互查 <b
                                        class="caret"></b></a>
                                <ul class="dropdown-menu">
                                    <#if abs??>
                                        <#list abs as ab>
                                            <#if ab.name??>
                                                <li><a href="scrutiny.action?dwdm=${ab.value}" target="_blank">${ab.name}</a></li>
                                            </#if>
                                        </#list>
                                    </#if>
                                </ul>
                            </li>
                        </#if>
                        <#if perms['loan']??>
                            <li><a href="loan.action">借阅管理</a></li>
                        </#if>
                        <#if perms['statistics']??>
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">档案统计 <b
                                        class="caret"></b></a>
                                <ul class="dropdown-menu">
                                    <#if ctx.hasEnv("jiangyin.enable")>
                                        <li><a href="report.action?type=loan_static" target="_blank">欠档情况统计</a></li>
                                        <li><a href="report.action?type=jiangyin_lytj" target="_blank">档案利用情况统计</a></li>
                                        <li><a href="report.action?type=jiangyin_static" target="_blank">存档情况统计</a></li>
                                        <li><a href="report.action?type=jiangyin_static_bymo" target="_blank">月度情况统计</a></li>
                                    <#else >
                                        <li><a href="report.action?type=static">档案统计</a></li>
                                    </#if>
                                </ul>
                            </li>
                        </#if>
                        <#if !ctx.isAdmin()>
                            <#if perms['ajhManage']??>
                                <li><a href="admin/ajh.action">案卷号管理</a></li></#if>
                        </#if>
                        <#if ctx.hasEnv('jiangyin.enable')>
                            <li><a href="/tddj/queryTDZ.action" target="_blank">土地证查询</a></li>
                            <li><a href="generic.action">档案管理</a></li>
                        </#if>
                        <#if ctx.hasEnv('jurong.enable')>
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">打印模版设置 <b
                                        class="caret"></b></a>
                        <ul class="dropdown-menu">
                            <li><a href="#"  onclick="localPrint()">本地打印模版</a> </li>
                            <li><a href="#"  onclick="serverPrint()">服务器打印模版</a> </li>
                        </ul>
                        </#if>
                        <li>
                            <form class="navbar-search" action="${ctx.env['solr.url']}" method="get" target="_blank">
                                <input type="hidden" name="bid" value="archive"/>
                                <input type="text" name="keyword" style="width: 100px;height: 14px;margin-top: 5px" class="search-query" placeholder="全文检索">
                            </form>
                        </li>
                        <li><a href="logout.action">注销</a></li>
                    </ul>
                    <#--<a class="pull-right" style="margin-top: 10px" href="logout.action">注销</a>-->
                </div>
                <!--/.nav-collapse -->
            </div>
        </div>
    </div>
    </div>
    <div id="tbody">

        <#nested />

    </div> <!-- /container -->
    <div id="footer">&copy;2010 国图档案管理系统</div>
    <script type="text/javascript">
        /**
         * 使用本地打印模版
         */
        function localPrint(){
            window.localStorage.printType="Local";
        }
        /**
         * 使用服务器打印模版
         */
        function serverPrint(){
            try {
                debugger;
                var Message = "请选择本地模版所在文件夹"; //选择框提示信息
                var Shell = new ActiveXObject("Shell.Application");
                var Folder = Shell.BrowseForFolder(0,Message,0); //起始目录为：桌面
                if (Folder != null) {
                    Folder = Folder.items();
                    Folder = Folder.item();
                    Folder = Folder.Path;
                    if (Folder.charAt(Folder.length - 1) != "//") {
                        Folder = Folder + "//";
                    }
                    window.localStorage.localPath=Folder;
                    window.localStorage.printType="Server";
                }
            }catch (e) {
                if(e.message=="ActiveXObject is not defined"){
                    alert("请使用IE内核的浏览器，建议IE8+");
                }else if(e.message=="没有权限"){
                    alert("没有权限,请修改当前浏览器安全设置");
                }else{
                    alert(e.message)
                }
            }
        }
    </script>
    </@html>
</#macro>

<#-- simple html -->
<#macro simple title="">
    <@html title="${title!}" import="jquery,bootstrap,main">

    <div class="container">

        <#nested />

    </div> <!-- /container -->

    </@html>
</#macro>


<#-- flash -->
<#macro swf title="" swfname="">
    <@html title="${title!}" import="swf">
    <style type="text/css" media="screen">
        html, body {
            height: 100%;
        }

        body {
            margin: 0;
            padding: 0;
            overflow: auto;
            text-align: center;
            background-color: #25639c;
        }

        object:focus {
            outline: none;
        }

        #flashContent {
            top: 50%;
            width: 360px;
            margin: 0px auto;
        }

        #flashContent p {
            color: #ffffff;
        }
    </style>

        <#nested />

    <script type="text/javascript">
        var swfVersionStr = "11.5.0";
        var xiSwfUrlStr = "playerProductInstall.swf";
        var flashvars = {};
        var params = {};
        params.quality = "high";
        params.bgcolor = "#fcfffb";
        params.allowscriptaccess = "sameDomain";
        //params.allowfullscreen = "true";
        params.allowFullScreenInteractive = "true";
        params.wmode = "direct";
        var attributes = {};
        attributes.id = "${swfname}";
        attributes.name = "${swfname}";
        attributes.align = "middle";
        swfobject.embedSWF(
                "<@rootPath/>/resources/flash/${swfname}.swf", "flashContent",
                "100%", "100%",
                swfVersionStr, xiSwfUrlStr,
                flashvars, params, attributes);
        swfobject.createCSS("#flashContent", "display:block;text-align:left;");
    </script>

    <div id="flashContent">
        <p>
            亲，难道你不知道看Flash要装Adobe Flash Player的么，记得安装11.5.0以上的版本哦！<br/>
            点击以下链接即可下载安装哦~<br/>安装后记得重启浏览器。
        </p>
        <script type="text/javascript">
            var axUrl = "<@rootPath/>/bin/install_flash_player_ax.exe";
            var otherUrl = "<@rootPath/>/bin/install_flash_player.exe";
            var onlineUrl = "http://get.adobe.com/cn/flashplayer/";
            var playerUrl = window.ActiveXObject ? axUrl : otherUrl;
            document.write("<a href='" + onlineUrl + "'><images src='<@rootPath/>/images/get_flash_player.gif'/> </a>");
        </script>
    </div>
    </@html>
</#macro>

<#-- import js -->
<#macro script name>
<script src="<@rootPath/>/${name}" type="text/javascript"></script>
</#macro>

<#-- import css -->
<#macro style name>
<link href="<@rootPath/>/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>

<#-- root path -->
<#macro rootPath>${base}</#macro>

