<#-- @ftlvariable name="modelName" type="java.lang.String" -->
<#-- @ftlvariable name="topMenu" type="java.util.Map<java.lang.String, java.lang.String>" -->
<#-- @ftlvariable name="treeId" type="java.lang.String" -->
<#-- @ftlvariable name="fields" type="java.util.Map<java.lang.String, com.gtis.archive.core.Field>" -->
<#-- @ftlvariable name="showFields" type="java.util.LinkedHashMap" -->
<@layout.check import="jquery,ext">
<table>
    <tr>
        <td class="archiveLeftPanel">
            <div class="a-box">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="min-height:500px;_height:500px;padding-top:10px;">
                            <dl class="a-side">
                                <dt>全文检索</dt>
                                <dd>
                                    <form action="${ctx.env['solr.url']}" method="get" target="_blank">
                                        <input type="hidden" name="bid" value="archive"/>
                                        <table id="search-box" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td class="input">
                                                    <input type="text" name="keyword" class="text"
                                                           style="width:120px;"/>
                                                    <input type="submit" class="sub" value=""/>
                                                    <input type="hidden" name="cid" value="a_${modelName}"/>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                </dd>
                            </dl>
                            <dl class="a-side" id="treeBox-ct">
                                <dt>分类</dt>
                                <dd>
                                    <div id="treeBox" style="margin: 5px 0px"></div>
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </td>
        <td class="archiveRightPanel">
            <div class="a-box">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="padding-top:10px;">
                            <div>
                                <div id="wdythDiv" class="a-tab" style="display: none;font-size: 13px;">
                                    <a name="wgd" href="#" class="btn active" id="wgdItem">未归档</a>
                                    <a name="xgd" href="#" class="btn">需归档</a>
                                    <a name="bgd" href="#" class="btn">不归档</a>
                                    <a name="pgd" href="#" class="btn">预归档</a>
                                    <a name="ygd" href="#" class="btn">已归档</a>
                                </div>
                                <a id='advSearch' href="#" onclick="return showAdvancedSearch();"
                                   style="display:block;float:right;margin:4px 10px 0 5px;line-height: 20px;visibility:hidden;">高级检索</a>
                                <div id="searchBox" style="margin: 4px"></div>
                            </div>
                            <div class="a-opt clearfix" id="opt-box">
                                 <a class="a-btn a-ctl" href="#" onclick="return editEntity();" id="showEntity">查看</a>
                                 <a class="a-btn a-ctl" href="#" onclick="return showOriginal();" id="showOriginal">原文管理</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="a-box" id="search-item" style="display:none;">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame clearfix"
                             style="margin-top:10px;padding:5px 0 5px 5px;position:relative;">
                            <span class="search-item-close" onclick="hideAdvancedSearch();"></span>

                            <div style="float:right;padding:3px 25px 8px 0;">
                                <a class="a-btn" href="#" onclick="return addSearchItem();">增加过滤</a>
                                <a class="a-btn" href="#" onclick="return advancedSearch();">检 索</a>
                            </div>
                            <form class="clearfix" id="search-item-box"
                                  onkeydown="if(event.keyCode==13){event.keyCode=0;return false;}"></form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="a-box" style="margin-top:10px;">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="min-height:422px;_height:422px;">
                            <div id="entityCt"></div>
                            <div id="pagingToolbar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </td>
    </tr>
</table>
<div id="advancedSearchTpl"></div>

<style type="text/css">

    a {
        overflow: auto;
    }

    span {
        overflow: auto;
    }

</style>

<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript" src="js/ext/ux/ComboPageSize.js"></script>
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript">

var win, store, dataView, pageToolBar, searchField, treeId = '${treeId}', modelName = '${modelName}', id;
var changeType, preFields;
var json =${treeJson!'[]'};
var _jsessionid = '${sessionId}';
var $allStatusItemList = $('#wdythDiv a');
var isWdyth;
var tree;
var genericId;
var perm;
var dicId='${itemId}';


Ext.util.Format.style = function (v) {
    debugger;
    if (v == null || v.toString() == "") {
        return null;
    } else if (v == false) {
        return "<img src=\"/archive/img/wuog.png\" alt=\"未上传原文\"  title=\"未上传原文\" class='img' />";
    }
    return null;
}

function onComplete(result, msg) {
    win.close();
    if (!result) {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    } else {
        Ext.MessageBox.alert('成功', '　　' + msg + '　　');
    }
}

function getJsessionidUrl(url) {
    var index = url.indexOf('?');
    if (index > -1) {
        return url.substring(0, index) + ';jsessionid=' + _jsessionid + url.substr(index);
    } else {
        return url + ';jsessionid=' + _jsessionid;
    }
}

function addSearchItem() {
    var item = $('#search-item-box').append($('#searchTpl').val()).children(":last");
    item.hover(
            function () {
                $(this).addClass("hover");
            },
            function () {
                $(this).removeClass("hover");
            });
}

function showAdvancedSearch() {
    if ($("#search-item-box .search-item").length == 0) {
        addSearchItem();
    }
    $('#search-item').toggle();
}

function advancedSearch() {
    var condition = Ext.lib.Ajax.serializeForm('search-item-box');
    store.setBaseParam('condition', condition.replace(/=/g, ',').replace(/&/g, ';'));
    store.load();
}

function hideAdvancedSearch() {
    $('#search-item').hide();
    store.setBaseParam('condition', '');
    store.load();
}


function getListIds() {
    var ids = [];
    var ct = "#entityCt";
    $(ct + ' .chk-archive').each(function () {
        if (this.value)
            ids.push(this.value);
    });
    return ids;
}


function showTipDelay(o, id) {
    o.tipTimer = setTimeout(function () {
        showTip(o, id)
    }, 500);
}

function hideTip(o) {
    if (o.tipTimer) {
        clearTimeout(o.tipTimer);
    }
}

var archiveTip;

function showTip(a, id) {
    if(!perm.allView)
        return;
    var tempModelName;
    if (archiveTip) {
        archiveTip.hide();
    } else {
        archiveTip = new Archive.ToolTip({
            width:250,
            target:a,
            html:'loading'
        });
    }
    if (modelName == "ygd" || modelName == "pgd") {
        tempModelName = store.data.items[position(id, store.data.keys)].data.modelName.toLowerCase();
    } else {
        tempModelName = modelName;
    }
    Ext.Ajax.request({
        url:'generic-entity!preview.action',
        params:{id:id, modelName:tempModelName},
        success:function (rp) {
            var html = ['<div class="info-card"><ul>'];
            html.push(rp.responseText);
            html.push('</ul></div>');
            archiveTip.setHtml(html.join(''));
        }
    });
    archiveTip.showBy(a);
    return false;
}

function showEntity(id) {
    if(!perm.allView)
        return alert("对不起，您对当前操作没有权限!");
    var tempModelName;
    var tempTreeId;
    if ((modelName == "ygd" && id != null)||(modelName == "pgd" && id != null)) {
        tempModelName = store.data.items[position(id, store.data.keys)].data.modelName.toLowerCase();
    } else {
        tempModelName = modelName;
    }
    if (tree != null) {
        if ((modelName == "ygd" && id != null) || (modelName == "pgd" && id != null)) {
            tempTreeId = getTreeId(tree, tempModelName);
        } else {
            tempTreeId = treeId;
        }
    } else {
        tempTreeId = treeId;
    }
    win = new Ext.Window({
        title: '查看',
        closable:true,
        modal:true,
        width:400,
        height:300,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="generic-entity.action?modelName=' + tempModelName + '&treeId=' + tempTreeId + (id ? '&id=' + id : '') + '" id="archiveFrame"></iframe>'
    });
    win.show();
}
function editEntity(id) {
    if (id) {
        showEntity(id);
    } else {
        var ids = getSelectIds();
        if (ids.length > 1 || ids.length == 0) {
            alert('请选择某一项!');
        }
        else {
            showEntity(ids.pop());
        }
    }
}

function onGenericComplete(result, msg) {
    win.close();
    if (store) {
//        Ext.MessageBox.alert('成功', '　　' + msg.split(";")[0] + '　　');
        store.reload();
        reloadGeneric(msg.split(";")[1]);
    } else {
        showError("保存失败", msg);
    }

}

function reloadGeneric(id) {
    editEntity(id);
}

function getSelectIds(itemId, id) {
    if (id)
        return [id];
    var ids = [];
    var ct = itemId ? '#d' + itemId : "#entityCt";
    $(ct + ' [type="checkbox"]').each(function () {
        if ($(this).attr("checked")) {
            if (this.value != "on")
                ids.push(this.value);
        }
    });
    return ids;
}

var _order = 'ASC';

function sortByField(field) {
    store.singleSort(field, _order);
    _order = _order == 'ASC' ? 'DESC' : 'ASC';
    return false;
}

function getDataViewXTpl(context) {
    try {
        var el = document.createElement('div');
        el.innerHTML = context;
        var xTpl = Ext.XTemplate.from(el.children[0]);
        var fields = el.children[1].value.split(',');
        renderModelList(xTpl, fields);
        showAdvSearchContext(el.children[2]);
    } catch (err) {
        showError("模板有误", err);
    }
}

function showAdvSearchContext(e) {
    clearDivHolder('advancedSearchTpl');
    clearDivHolder('search-item-box');
    document.getElementById('advancedSearchTpl').appendChild(e);
    document.getElementById('advSearch').style.visibility = 'visible';
}

/**
 *
 * @param modelName
 * @param opera
 */
function getTplByModel(modelName, tplName) {
    if (modelName == null || tplName == null) return;
    if (modelName == 'Object') {
        alert('请先选择左侧某一分类');
        return;
    }
    Ext.Ajax.request({
        url:'check!tpl.action',
        params:{'modelName':modelName, 'tplName':tplName},
        success:function (res, opt) {
            parseTpl(opt.params.modelName, opt.params.tplName, res.responseText);
        },
        failure:function (res, opt) {
            showError(res);
        }
    });

}

/**
 *
 * @param modelName
 * @param tplName
 * @param content
 */
function parseTpl(modelName, tplName, content) {
    if (content == null || content.length == 0) {
        showError('模板异常', '模型【' + modelName + '】未定义或模板未定义,请查看后台日志记录');
        return;
    }
    switch (tplName) {
        case 'list':
            //
            getDataViewXTpl(content);
            break;
        case 'edit':
            //
            break;
    }

}

/**
 *
 * @param title
 * @param msg
 */
function showError(title, msg) {
    Ext.Msg.alert(title == null ? '异常' : title, msg);
}

function renderModelList(xtpl, fields) {
    debugger;
    if (modelName == "ygd" || modelName == "pgd")
        fields.push("modelName");
    if (modelName == "ythsw" || modelName == "ythfw" || modelName == "ythnw")
        fields.push("hasOriginal");
    store = new Ext.data.JsonStore({
        url:'check!list.action',
        root:'items',
        totalProperty:'totalCount',
        fields:fields,
        autoLoad:true,
        baseParams:isWdyth ? {'status':'wgd'} : "",
        listeners:{
            beforeload:function (r, s, p) {
                store.baseParams = store.baseParams || {};
                store.baseParams['limit'] = ${limit};
                store.baseParams['treeId'] = treeId;
                store.baseParams['modelName'] = modelName;
                store.baseParams['itemId']='${itemId}';
            },
            load:function (s, r, o) {
                if (preFields != fields) {
                    changeType = true;
                    preFields = fields;
                } else {
                    changeType = false;
                }
                updateContent(xtpl);
            }
        }
    });
}

/**
 * 根据获取到对应model的模板更新显示内容
 * @param xtpl
 */
function updateContent(xtpl) {

    if (changeType) {

        dataView = new Ext.DataView({
            store:store,
            tpl:xtpl,
            autoDestroy:true,
            autoHeight:true,
            overClass:'x-view-over',
            itemSelector:'tr.a-item',
            emptyText:'',
            applyTo:'entityCt'
        });

        clearDivHolder('pagingToolbar');
        pageToolBar = new Ext.PagingToolbar({
            plugins:new Ext.ux.ComboPageSize({ addToItem:false, prefixText:'每页', postfixText:'条'}),
            renderTo:'pagingToolbar',
            autoDestroy:true,
            pageSize: ${limit},
            store:store,
            displayInfo:true,
            displayMsg:'{0} - {1} 共 {2} 条',
            emptyMsg:"没有记录返回"
        });

        clearDivHolder('searchBox');
        searchField = new Ext.ux.form.SearchField({
            store:store,
            width:150,
            renderTo:'searchBox'
        });

        hideAdvancedSearch();
    }

}

function clearDivHolder(id) {
    var el = document.getElementById(id);
    var nodes = el.childNodes;
    for (var i = nodes.length - 1; i >= 0; i--) {
        el.removeChild(nodes[i]);
    }
}

function onResize(w, h) {
    if (win != null) {
        win.setWidth(w + 40);
        win.setHeight(h + 90);
        win.center();
    }
}


function showOriginalBtn(id) {
    if (id != null && (modelName.toLowerCase() == "ythsw" || modelName.toLowerCase() == "ythfw"
            || modelName.toLowerCase() == "ythnw" || modelName.toLowerCase() == "wsda"||modelName.toLowerCase() == "ygd"||modelName=="pgd")) {
        return false;
    }
    return true;
}

function position(value, array) {
    for (var i in array) {
        if (array[i] == value) {
            return i;
            break;
        }
    }
}

//get treeId by name
function getTreeId(tree, name) {
    var nodes = tree.root.childNodes;
    var wdyth;
    for (var i = 0; i < nodes.length; i++) {
        if (nodes[i].attributes["name"] == "文档一体化") {
            wdyth = nodes[i].childNodes;
            break;
        }
    }
    if (wdyth != null) {
        for (var j = 0; j < wdyth.length; j++) {
            if (wdyth[j].attributes["name"].toLowerCase() == name) {
                return wdyth[j].id;
            }
        }
    }
    return null;
}


var ogDs, linkWin;
/**
 * 原文管理
 */
function showOriginal(archiveId) {
    if(!perm.allOriginal)
        return alert("对不起,您对当前操作没有权限!");
    var id;
    if (archiveId == null) {
        var ids = getSelectIds();
        if (ids.length != 1)
            return alert("请选择一个档案!");
        id = ids[0];
    } else {
        id = archiveId;
    }
    ogDs = new Ext.data.JsonStore({
        url:'og!list.action?ownerId=' + id,
        autoLoad:true,
        totalProperty:'totalCount',
        root:'items',
        fields:[
            'id', 'name', 'fileSize', 'updateTime'
        ]
    });
    var ogSm = new Ext.grid.CheckboxSelectionModel();
    var formatSize = function (size, p, record) {
        return Ext.util.Format.fileSize(size);
    };
    var ogGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:ogDs,
        height:250,
        sm:ogSm,
        loadMask:true,
        stripeRows:true,
        region:'center',
        bbar:new Ext.PagingToolbar({
            pageSize:20, //每页显示几条数据
            store:ogDs,
            displayInfo:true,
            displayMsg:'{0} - {1} 共 {2} 条',
            emptyMsg:"没有记录返回" }),
        cm:new Ext.grid.ColumnModel([
            //new Ext.grid.RowNumberer(),//显示行号
            ogSm,
            {header:"名称", width:400, sortable:true, dataIndex:'name'},
            {header:"大小", width:100, sortable:true, dataIndex:'fileSize', renderer:formatSize},
            {header:"上传时间", width:150, sortable:true, dataIndex:'updateTime'}
        ]),
        tbar:[
            {
                text:'查看',
                iconCls:'preview',
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    }
                    var nids = [];
                    for (var i = 0; i < ogSm.getSelections().length; i++) {
                        nids.push(ogSm.getSelections()[i].data.id);
                    }
                    showPreview(nids);
                }
            },
            '->',
            new Ext.ux.form.SearchField({
                id:'searchBox1',
                style:{'margin':'0,0,0,150px'},
                store:ogDs,
                width:150,
                renderTo:'searchBox'
            })
        ],
        listeners:{
            rowdblclick:function (g, index, e) {
                var id = ogDs.getAt(index).id;
                showPreview([id]);
            },
            render:function (g) {
                var store = g.getStore();
                var view = g.getView();
                g.tip = new Archive.OgTip({
                    dismissDelay:0,
                    target:view.mainBody,
                    delegate:'.x-grid3-row',
                    autoWidth:!Ext.isIE6,
                    renderTo:document.body,
                    listeners:{
                        beforeshow:function (tip) {
                            var rowIndex = view.findRowIndex(tip.triggerElement);
                            tip.body.update('<img src="' + 'og!thumb.action?modelName=' + modelName + '&id=' + store.getAt(rowIndex).id + '"/>');
                        }
                    }
                });
            }
        }
    });
    var ogWin = new Ext.Window({
        title:'原文',
        closable:true,
        modal:true,
        width:700,
        height:500,
        layout:'fit',
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    ogWin.close();
                }
            }
        ],
        items:ogGrid
    });
    ogWin.show();

    debugger ;
    checklog(id,modelName)
    return false;
}

function checklog(id, mName){
    debugger;
    Ext.Ajax.request({
        url:"check!addCheckLog.action",
        params:{archiveId:id , modelName:mName},
        success:function (r) {
            // var ids= Ext.decode(r.responseText);
            //alert("您的访问记录已经被记录到互查日志当中！") ;
        }
    });
}


function showPreview(nids) {
    if (!Ext.isDefined(window.hasEPreOcx)) {
        try {
            new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
            window.hasEPreOcx = true;
        } catch (e) {
            window.hasEPreOcx = false;
        }
    }
    if (window.hasEPreOcx) {
        var base = location.href.substring(0, location.href.lastIndexOf('/'));
        var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
        link = link.substr(link.indexOf('//') + 2);
        Ext.Ajax.request({
            url:'archive!cacheIds.action',
            params:{id:nids},
            success:function (r) {
                var json = Ext.decode(r.responseText);
                location.href = 'epre://' + link + json['idsKey'];
            }
        });
    } else {
        window.open('og!get.action?preview=true&id=' + nids[0]);
    }
}


$(function () {
    if (json.length) {
        tree = new Ext.tree.TreePanel({
            animate:true,
            autoScroll:true,
            containerScroll:true,
            useArrows:true,
            width:160,
            renderTo:'treeBox',
            root:new Ext.tree.AsyncTreeNode({
                id:'rootNode',
                text:'未分类',
                iconCls:'root',
                children:json
            }),
            listeners:{
                click:function (n) {
                    debugger;
                    if (n.id == 'rootNode') {
                        treeId = '${treeId}';
                    } else {
                        treeId = n.id;
                    }
                    if (n.childNodes.length > 0) return;
                    modelName = n.attributes.name;
                    if (n.attributes.content == 'wdyth' && modelName != "ygd" && modelName != "pgd") {
                        $("#wdythDiv").css('display', 'block');
                        $allStatusItemList.removeClass('active');
                        $("#wgdItem").addClass('active');
                        isWdyth = true;
                    } else {
                        $("#wdythDiv").css('display', 'none');
                        isWdyth = false;
                    }
                    getPerm();
                    getTplByModel(modelName, 'list');
                }
            }
        });
        tree.getRootNode().expand(false, false);
        tree.getRootNode().select();
    } else {
        $('#treeBox-ct').hide();
    }

    $allStatusItemList.click(function (e) {
        $el = $(this);
        var item= $el.attr('name');
        if (store) {
            store.setBaseParam("status", $el.attr('name'));
            store.load();
        }
        $allStatusItemList.removeClass('active');
        $el.addClass('active');
    });
});

function getPerm(){
    Ext.Ajax.request({
        url:'check!getPermJson.action',
        params:{treeId:treeId,itemId:dicId},
        success:function (r) {
            perm = Ext.decode(r.responseText);
            setBtnVisible();
        }
    });
}
function setBtnVisible(){
    if(perm.allView){
        $("#showEntity").show();
    }else{
        $("#showEntity").hide();
    }
    if(perm.allOriginal){
        $("#showOriginal").show();
    }else{
        $("#showOriginal").hide();
    }
}
</script>
</@layout.check>
