/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web.admin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.service.ExtTreeService;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.json.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name="toIndex", location="item.action?dictName=${dictName}", type="redirect")})
public class ItemAction
extends ActionSupport {
    private static final long serialVersionUID = 3736616155649415355L;
    @Autowired
    private DictService dictService;
    @Autowired
    private ExtTreeService treeService;
    private String dictName;
    private String id;
    private Item item;
    private List<Item> items;
    private String msg;
    private String treeJson;
    private List<Item> operations;

    public String getDictName() {
        return this.dictName;
    }

    public void setDictName(String dictName) {
        this.dictName = dictName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public String getMsg() {
        return this.msg;
    }

    public String execute() throws Exception {
        return super.execute();
    }

    public String edit() throws Exception {
        if (this.item == null) {
            this.item = StringUtils.isNotBlank((String)this.id) ? this.dictService.getItem(this.id) : new Item();
        } else {
            if (StringUtils.isBlank((String)this.item.getName())) {
                return "edit";
            }
            this.item.setDictId(this.dictService.getDict(this.dictName).getId());
            this.dictService.saveItem(this.item);
            this.msg = "successed";
        }
        return "edit";
    }

    public List<Item> getItems() {
        return this.dictService.getItems(this.dictName);
    }

    public String getTab() {
        return "dict";
    }

    public String remove() throws Exception {
        this.dictService.removeItem(this.id);
        return "toIndex";
    }

    public boolean getIsCheck() {
        return this.dictName.contains("hc_");
    }

    public String getTreeJson() throws Exception {
        if (StringUtils.isBlank((String)this.treeJson)) {
            if (this.operations == null) {
                this.operations = this.dictService.getItems("hcPerm");
            }
            List tree = this.rewrite(this.treeService.getTree(null, new String[]{"model"}));
            this.treeJson = JSONUtil.serialize((Object)tree);
        }
        return this.treeJson;
    }

    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                if (map.containsKey("expanded")) {
                    map.put("expanded", false);
                }
                this.rewrite((List)map.get("children"));
                String id = (String)map.get("id");
                ArrayList opts = new ArrayList();
                boolean isParent = map.containsKey("expanded");
                for (Item item : this.operations) {
                    if (isParent) continue;
                    HashMap<String, Object> op = new HashMap<String, Object>();
                    op.put("name", id + "_" + item.getName());
                    op.put("text", item.getValue());
                    op.put("checked", this.checkValue(id, item));
                    opts.add(op);
                }
                map.put("data", opts);
            }
        }
        return tree;
    }

    private boolean checkValue(String id, Item perm) {
        if (this.item != null && this.item.getRemark() != null) {
            String remark = this.item.getRemark().toString();
            if (StringUtils.isBlank((String)remark)) {
                return false;
            }
            JSONObject job = JSON.parseObject((String)remark);
            JSONArray array = job.getJSONArray("items");
            for (int i = 0; i < array.size(); ++i) {
                String permId = ((JSONObject)array.get(i)).get((Object)"id").toString();
                String permName = ((JSONObject)array.get(i)).get((Object)"perm").toString();
                if (!id.equals(permId) || !perm.getName().equals(permName)) continue;
                return true;
            }
        }
        return false;
    }
}

