/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class ScrutinyAction
extends BaseModelAction<Archive> {
    private static final Object Lock = 1;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    @Autowired
    private SysUserService userService;
    private String treeId;
    private String type;
    private String data_type;
    private List<Item> operations;
    private Map<String, String> topMenu;
    private String mlh;
    private Integer ajh;
    private Integer endAjh;
    private Integer boxSize;
    private Map docShowFields;
    private Map docFields;
    private String linkField;
    private String docLinkField;
    private String dwdm;
    private String itemId;
    private Boolean generic = false;
    private Boolean check;
    private List<Map<String, Object>> tree;
    private List<Map<String, Object>> tempTree;
    private List docEntities;

    public Boolean getCheck() {
        if (this.modelName.equals("Tdsyqdj") || this.modelName.equals("Jttdsyqdj") || this.modelName.equals("Tdtxql")) {
            return true;
        }
        return false;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    public Boolean getGeneric() {
        if (this.tempTree == null) {
            this.getTree();
        }
        for (Map tempItem : this.tempTree) {
            if (!tempItem.get("name").equals("generic")) continue;
            return true;
        }
        return this.generic;
    }

    public void setGeneric(Boolean generic) {
        this.generic = generic;
    }

    public String getItemId() {
        if (StringUtils.isBlank((String)this.itemId)) {
            List items = this.dictService.getItems("hc_" + this.userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
            for (Item item : items) {
                if (!item.getValue().equals(this.dwdm)) continue;
                this.itemId = item.getId();
                break;
            }
        }
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getDwdm() {
        return this.dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getData_type() {
        return this.data_type;
    }

    public void setData_type(String data_type) {
        this.data_type = data_type;
    }

    public void setModelName(String modelName) {
        super.setModelName(Document.toArchiveModelName((String)modelName));
    }

    public String getModelName() {
        return super.getModelName();
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public void setEndAjh(Integer endAjh) {
        this.endAjh = endAjh;
    }

    public void setBoxSize(Integer boxSize) {
        this.boxSize = boxSize;
    }

    public Integer getBoxSize() {
        return this.boxSize;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public String getType() {
        return this.type;
    }

    public List<Item> getOperations() {
        return this.operations;
    }

    public String getPermJson() {
        Item huchaItem;
        HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
        if (StringUtils.isNotBlank((String)this.itemId) && StringUtils.isNotBlank((String)(huchaItem = this.dictService.getItem(this.itemId)).getRemark())) {
            String remark = huchaItem.getRemark().toString();
            JSONObject jsonObject = JSON.parseObject((String)remark);
            JSONArray items = (JSONArray)jsonObject.get((Object)"items");
            for (int i = 0; i < items.size(); ++i) {
                String id = ((JSONObject)items.get(i)).get((Object)"id").toString();
                String huchaPerm = ((JSONObject)items.get(i)).get((Object)"perm").toString();
                if (!id.equals(this.treeId)) continue;
                for (Item item : this.operations) {
                    if (!item.getName().equals(huchaPerm)) continue;
                    perm.put(item.getName(), true);
                }
            }
        }
        return JSON.toJSONString(perm);
    }

    public Map<String, Boolean> getPerms() {
        HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : this.operations) {
            if (!this.securityService.isPermitted(this.treeId, item.getName())) continue;
            perm.put(item.getName(), true);
        }
        return perm;
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString((Object)this.rewrite(this.treeService.getTree(this.treeId)));
    }

    public List<Map<String, Object>> getTree() {
        if (this.tree == null) {
            List listTree = this.treeService.getAllTree(null, new String[]{"model"});
            if (this.itemId == null) {
                List items = this.dictService.getItems("hc_" + this.userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
                for (Item item : items) {
                    if (!item.getValue().equals(this.dwdm)) continue;
                    this.itemId = item.getId();
                    break;
                }
            }
            if (StringUtils.isBlank((String)this.itemId)) {
                for (Map item : listTree) {
                    this.logger.debug(item.toString());
                    if (!item.get("name").equals("generic")) continue;
                    listTree.remove(item);
                    break;
                }
            } else {
                Item item = this.dictService.getItem(this.itemId);
                List newTree = new ArrayList();
                if (item != null && item.getRemark() != null && StringUtils.isNotBlank((String)item.getRemark().toString())) {
                    String remark = item.getRemark().toString();
                    JSONObject job = JSON.parseObject((String)remark);
                    JSONArray array = job.getJSONArray("items");
                    ArrayList<String> resIds = new ArrayList<String>();
                    for (int i = 0; i < array.size(); ++i) {
                        String resId = ((JSONObject)array.get(i)).get((Object)"id").toString();
                        if (resIds.contains(resId)) continue;
                        resIds.add(resId);
                    }
                    newTree = this.rewriteMap(listTree, resIds);
                    this.tempTree = this.rewriteMap(listTree, resIds);
                    for (Map tempItem : newTree) {
                        if (!tempItem.get("name").equals("generic")) continue;
                        newTree.remove(tempItem);
                        break;
                    }
                    listTree = newTree;
                } else {
                    listTree = new ArrayList();
                }
            }
            this.tree = listTree;
        }
        return this.tree;
    }

    private List<Map<String, Object>> rewriteMap(List<Map<String, Object>> listTree, List<String> resIds) {
        ArrayList<Map<String, Object>> parentList = new ArrayList<Map<String, Object>>();
        if (listTree != null) {
            for (Map<String, Object> tree : listTree) {
                List childrenList = this.rewriteMap((List)tree.get("children"), resIds);
                String id = (String)tree.get("id");
                if (!resIds.contains(id) && childrenList.size() == 0) continue;
                tree.put("children", childrenList);
                parentList.add(tree);
            }
        }
        return parentList;
    }

    public Map<String, String> getTopMenu() {
        if (this.topMenu == null) {
            this.topMenu = new LinkedHashMap();
            for (Item item : this.dictService.getItems("archiveMenu")) {
                if (!"true".equalsIgnoreCase(item.getValue())) continue;
                this.topMenu.put(item.getName(), item.getRemark());
            }
        }
        return this.topMenu;
    }

    public String execute() {
        Archive archive;
        if (this.modelName == null || this.modelName.equals("Archive")) {
            List tree = this.getTree();
            for (Map map : tree) {
                List children = (List)map.get("children");
                if (children == null || children.size() <= 0) continue;
                this.modelName = ((Map)children.get(0)).get("name").toString();
                break;
            }
            if (this.modelName == null || this.modelName.equals("Archive")) {
                return "none";
            }
        }
        String currentDwdm = this.getCurrentDwdm();
        boolean hasPermission = false;
        try {
            List items = this.dictService.getItems("hc_" + currentDwdm);
            for (Item item : items) {
                if (!item.getValue().equals(this.dwdm)) continue;
                hasPermission = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!hasPermission) {
            return "none";
        }
        this.operations = this.dictService.getItems("hcPerm");
        if (StringUtils.isNotEmpty((String)this.modelName)) {
            Resource res = this.resourceService.findChildResource(null, this.modelName, new String[]{"model"});
            if (res != null) {
                this.treeId = res.getId();
                if (!this.securityService.isPermitted(this.treeId, "view")) {
                    throw new NoPermissionException(this.modelName);
                }
            } else {
                throw new ModelNotFoundException(this.modelName);
            }
        }
        this.modelService.getModel(this.modelName);
        String id = this.getId();
        if (id != null && (archive = this.archiveService.getArchive(this.modelName, id)) != null) {
            this.type = archive.getState() == 1 ? "ygd" : "wgd";
        }
        return "success";
    }

    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        Page page = null;
        if ("new".equals(this.data_type)) {
            page = this.archiveService.searchArchive(this.modelName, criterions, orders, this.getCurrentDwdm(), false, this.start, this.limit);
        } else if ("old".equals(this.data_type)) {
            page = this.archiveService.searchArchive(this.modelName, criterions, orders, this.dwdm, true, this.start, this.limit);
        }
        for (Archive archive : page.getItems()) {
            archive.setHasOriginal(Boolean.valueOf(this.originalService.hasOriginal(archive.getId())));
        }
        return page;
    }

    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (this.ajh != null) {
            criterions.add((Criterion)Restrictions.eq((String)"mlh", (Object)this.mlh));
            criterions.add((Criterion)Restrictions.gt((String)"ajh", (Object)this.ajh));
            if (this.endAjh != null) {
                criterions.add((Criterion)Restrictions.lt((String)"ajh", (Object)this.endAjh));
            }
            this.sort = "ajh";
        } else {
            if (this.type == null || !this.type.equals("all")) {
                criterions.add((Criterion)Restrictions.eq((String)"state", (Object)("ygd".equals(this.type) ? 1 : 0)));
            }
            if (StringUtils.isNotBlank((String)this.treeId)) {
                if ("checkbox".equals(EnvHolder.getAppEnv().get((Object)"classifyViewMode"))) {
                    String[] treeIds = this.treeId.split(",");
                    if (treeIds.length == 1) {
                        if (this.resourceService.getResource(this.treeId, new String[0]).getName().equals(this.modelName)) {
                            criterions.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"resourceId", (Object)this.treeId), (Criterion)Restrictions.isNull((String)"resourceId")));
                        } else {
                            criterions.add((Criterion)Restrictions.eq((String)"resourceId", (Object)this.treeId));
                        }
                    } else if (treeIds.length > 2) {
                        LogicalExpression temp = Restrictions.or((Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[0]), (Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[1]));
                        for (int i = 2; i < treeIds.length; ++i) {
                            temp = Restrictions.or((Criterion)temp, (Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[i]));
                        }
                        criterions.add((Criterion)temp);
                    } else {
                        criterions.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[0]), (Criterion)Restrictions.eq((String)"resourceId", (Object)treeIds[1])));
                    }
                } else if (this.resourceService.getResource(this.treeId, new String[0]).getName().equals(this.modelName)) {
                    criterions.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"resourceId", (Object)this.treeId), (Criterion)Restrictions.isNull((String)"resourceId")));
                } else {
                    criterions.add((Criterion)Restrictions.eq((String)"resourceId", (Object)this.treeId));
                }
            } else {
                criterions.add(Restrictions.isNull((String)"resourceId"));
            }
        }
        return super.createCriterions(criterions);
    }

    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                this.rewrite((List)map.get("children"));
                String id = (String)map.get("id");
                HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
                for (Item item : this.operations) {
                    if (!this.securityService.isPermitted(id, item.getName())) continue;
                    perm.put(item.getName(), true);
                }
                map.put("perm", perm);
            }
        }
        return tree;
    }

    public Map getDocShowFields() {
        if (this.docShowFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docShowFields = (Map)JSON.parseObject((String)doc.getTemplate("showFields"), LinkedHashMap.class);
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docShowFields = (Map)JSON.parseObject((String)this.getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return this.docShowFields;
    }

    public Map getDocFields() {
        if (this.docFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docFields = doc.getInheritfieldsMap();
            }
            catch (ModelNotFoundException modelNotFoundException) {
                // empty catch block
            }
        }
        return this.docFields;
    }

    public String getLinkField() {
        if (this.linkField == null) {
            try {
                this.linkField = this.archiveService.getArchiveModel(this.modelName).getTemplate("linkField");
            }
            catch (Exception ex) {
                this.linkField = "tm";
            }
        }
        return this.linkField;
    }

    public String getDocLinkField() {
        if (this.docLinkField == null) {
            try {
                this.docLinkField = this.archiveService.getDocumentModel(this.modelName).getTemplate("linkField");
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docLinkField = "tm";
            }
        }
        return this.docLinkField;
    }

    public boolean getIsShowArchiveInfo() {
        try {
            if (this.modelService.getModel(this.modelName.concat("_ai")) != null) {
                return true;
            }
        }
        catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    public boolean getIsShowArchiveDoc() {
        try {
            if (this.modelService.getModel(this.modelName.concat("_jn")) != null) {
                return true;
            }
        }
        catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    public List getDocEntities() {
        if (this.docEntities != null) {
            return this.docEntities;
        }
        this.docEntities = new ArrayList();
        if (this.ids.length > 0) {
            for (String id : this.ids) {
                this.docEntities.addAll(this.archiveService.getArchiveDocuments(this.modelName, id));
            }
        }
        return this.docEntities;
    }

    public void setIdString(String idString) {
        if (StringUtils.isNotBlank((String)idString)) {
            this.ids = idString.split(",");
        }
    }

    public String searchIds() {
        List criterions = this.createCriterions(new ArrayList());
        List orders = this.createOrders(new ArrayList());
        List items = this.entityService.search(this.modelName, criterions, orders, this.start, this.limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), (String)"id") + ",");
                continue;
            }
            catch (Exception e) {
                this.logger.error(e.toString());
            }
        }
        this.ids = sb.toString().split(",");
        return this.cacheIds();
    }

    private String getCurrentDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }
}

