/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.util;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.util.ServletUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class Struts2Utils {
    private static final String HEADER_ENCODING = "encoding";
    private static final String HEADER_NOCACHE = "no-cache";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final boolean DEFAULT_NOCACHE = true;

    public static Object getSessionAttribute(String name) {
        HttpSession session = Struts2Utils.getSession((boolean)false);
        return session != null ? session.getAttribute(name) : null;
    }

    public static HttpSession getSession() {
        return ServletActionContext.getRequest().getSession();
    }

    public static HttpSession getSession(boolean isNew) {
        return ServletActionContext.getRequest().getSession(isNew);
    }

    public static HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    public static String getParameter(String name) {
        return Struts2Utils.getRequest().getParameter(name);
    }

    public static HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    public static void renderText(String text, String ... headers) {
        Struts2Utils.render((String)"text/plain", (String)text, (String[])headers);
    }

    public static void render(String contentType, String content, String ... headers) {
        HttpServletResponse response = Struts2Utils.initResponseHeader((String)contentType, (String[])headers);
        try {
            response.getWriter().write(content);
            response.getWriter().flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static HttpServletResponse initResponseHeader(String contentType, String ... headers) {
        String encoding = "UTF-8";
        boolean noCache = true;
        for (String header : headers) {
            String headerName = StringUtils.substringBefore((String)header, (String)":");
            String headerValue = StringUtils.substringAfter((String)header, (String)":");
            if (StringUtils.equalsIgnoreCase((String)headerName, (String)"encoding")) {
                encoding = headerValue;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)headerName, (String)"no-cache")) {
                noCache = Boolean.parseBoolean(headerValue);
                continue;
            }
            throw new IllegalArgumentException(headerName + "\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684header\u7c7b\u578b");
        }
        HttpServletResponse response = ServletActionContext.getResponse();
        String fullContentType = contentType + ";charset=" + encoding;
        response.setContentType(fullContentType);
        if (noCache) {
            ServletUtils.setNoCacheHeader((HttpServletResponse)response);
        }
        return response;
    }

    public static void renderHtml(String html, String ... headers) {
        Struts2Utils.render((String)"text/html", (String)html, (String[])headers);
    }

    public static void renderJs(String js, String ... headers) {
        Struts2Utils.render((String)"text/html", (String)("<script type=\"text/javascript\">" + js + "</script>"), (String[])headers);
    }

    public static void renderXml(String xml, String ... headers) {
        Struts2Utils.render((String)"text/xml", (String)xml, (String[])headers);
    }

    public static void renderJson(String jsonString, String ... headers) {
        Struts2Utils.render((String)"text/json", (String)jsonString, (String[])headers);
    }

    public static void renderJson(Object data, String ... headers) {
        HttpServletResponse response = Struts2Utils.initResponseHeader((String)"text/json", (String[])headers);
        try {
            response.getWriter().write(JSON.toJSONString((Object)data));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void renderJsonp(String callbackName, Object object, String ... headers) {
        String jsonString = null;
        try {
            jsonString = JSON.toJSONString((Object)object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        String result = callbackName + "(" + jsonString + ");";
        Struts2Utils.render((String)"text/javascript", (String)result, (String[])headers);
    }

    public static String getRemoteAddr() {
        String remoteAddr = ServletActionContext.getRequest().getHeader("x-forwarded-for");
        return StringUtils.isBlank((String)remoteAddr) ? ServletActionContext.getRequest().getRemoteAddr() : remoteAddr;
    }

    public static boolean isPost() {
        return ServletActionContext.getRequest().getMethod().equalsIgnoreCase("POST");
    }

    public static void setFileDownloadHeader(String name, String type) {
        HttpServletResponse response = ServletActionContext.getResponse();
        ServletUtils.setFileDownloadHeader((HttpServletResponse)response, (String)name);
        if ("doc".equalsIgnoreCase(type)) {
            response.setContentType("application/vnd.ms-doc");
        } else if ("xls".equalsIgnoreCase(type)) {
            response.setContentType("application/vnd.ms-excel");
        } else if ("file".equalsIgnoreCase(type)) {
            response.setContentType("application/octet-stream");
        }
    }
}

