/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Original;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.support.hibernate.HibernateDao;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ArchiveServiceImpl
extends HibernateDao
implements ArchiveService {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveServiceImpl.class);
    @Autowired
    private EntityService entityService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private DictService dictService;
    private boolean dwdmEnable = false;
    private boolean jiangyinEnable = false;

    public void setDwdmEnable(boolean dwdmEnable) {
        this.dwdmEnable = dwdmEnable;
    }

    public void setJiangyinEnable(boolean jiangyinEnable) {
        this.jiangyinEnable = jiangyinEnable;
    }

    public Archive getArchive(String modelName, String id) {
        return (Archive)this.entityService.load(Document.toArchiveModelName((String)modelName), id);
    }

    public Document getDocument(String modelName, String id) {
        return (Document)this.entityService.load(Archive.toDocumentModelName((String)modelName), id);
    }

    public Archive getSimpleArchive(String id) {
        return (Archive)this.getSession().createSQLQuery("select t.*,0 clazz_ from t_archive t where t.id=?").addEntity(Archive.class).setParameter(0, (Object)id).uniqueResult();
    }

    public Document getSimpleDocument(String id) {
        return (Document)this.getSession().createSQLQuery("select t.*,0 clazz_ from t_document t where t.id=?").addEntity(Document.class).setParameter(0, (Object)id).uniqueResult();
    }

    public Archive getDocumentArchive(String modelName, String documentId) {
        return this.getArchive(modelName, this.getDocument(modelName, documentId).getId());
    }

    public Archive getDocumentArchive(Document document) {
        return this.getArchive(document.getModelName(), document.getArchiveId());
    }

    public List<Document> getArchiveDocuments(String modelName, String archiveId) {
        ArrayList<Order> orders = new ArrayList<Order>(2);
        orders.add(Order.asc((String)"sxh"));
        orders.add(Order.asc((String)"id"));
        return this.entityService.search(Archive.toDocumentModelName((String)modelName), Collections.singletonList(Restrictions.eq((String)"archiveId", (Object)archiveId)), orders, 0, -1).getItems();
    }

    public List<Document> getArchiveDocuments(String modelName, String archiveId, int currentSxh, String insertId) {
        ArrayList<Order> orders = new ArrayList<Order>(2);
        orders.add(Order.asc((String)"sxh"));
        orders.add(Order.asc((String)"id"));
        ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
        criterions.add(Restrictions.eq((String)"archiveId", (Object)archiveId));
        criterions.add(Restrictions.ne((String)"id", (Object)insertId));
        criterions.add(Restrictions.ge((String)"sxh", (Object)currentSxh));
        return this.entityService.search(Archive.toDocumentModelName((String)modelName), criterions, orders, 0, -1).getItems();
    }

    public Integer getArchiveDocumentLastSxh(String modelName, String archiveId) {
        ArrayList<Order> orders = new ArrayList<Order>(2);
        orders.add(Order.asc((String)"sxh"));
        orders.add(Order.asc((String)"id"));
        ArrayList<Object> criterions = new ArrayList<Object>();
        criterions.add(Restrictions.eq((String)"archiveId", (Object)archiveId));
        criterions.add(Restrictions.isNotNull((String)"sxh"));
        List list = this.entityService.search(Archive.toDocumentModelName((String)modelName), criterions, orders, 0, -1).getItems();
        if (list != null && list.size() > 0) {
            return ((Document)list.get(list.size() - 1)).getSxh();
        }
        return 0;
    }

    public List<Document> getArchiveDocuments(Archive archive) {
        return this.getArchiveDocuments(archive.getModelName(), archive.getId());
    }

    public Model getArchiveModel(String modelName) {
        return this.modelService.getModel(Document.toArchiveModelName((String)modelName));
    }

    public Model getDocumentModel(String modelName) {
        return this.modelService.getModel(Archive.toDocumentModelName((String)modelName));
    }

    public Archive newArchive(String modelName) {
        return (Archive)this.entityService.newInstance(Document.toArchiveModelName((String)modelName));
    }

    public Document newDocument(String modelName) {
        return (Document)this.entityService.newInstance(Archive.toDocumentModelName((String)modelName));
    }

    @Transactional
    public void removeArchive(String modelName, String[] ids) {
        for (String id : ids) {
            List docs = this.getArchiveDocuments(modelName, id);
            String[] dids = new String[docs.size()];
            int size = docs.size();
            for (int i = 0; i < size; ++i) {
                dids[i] = ((Document)docs.get(i)).getId();
            }
            this.removeDocument(modelName, dids);
            List ogs = this.originalService.getOriginals(id);
            String[] oids = new String[ogs.size()];
            int size2 = ogs.size();
            for (int i = 0; i < size2; ++i) {
                oids[i] = ((Original)ogs.get(i)).getId();
            }
            this.originalService.removeOriginal(oids);
        }
        this.entityService.remove(modelName, ids);
        logger.debug("remove archive [{}] ids [{}]", (Object)modelName, (Object)ids);
    }

    @Transactional
    public void removeDocument(String modelName, String[] ids) {
        for (String id : ids) {
            List ogs = this.originalService.getOriginals(id);
            String[] oids = new String[ogs.size()];
            int size = ogs.size();
            for (int i = 0; i < size; ++i) {
                oids[i] = ((Original)ogs.get(i)).getId();
            }
            this.originalService.removeOriginal(oids);
        }
        this.entityService.remove(Archive.toDocumentModelName((String)modelName), ids);
        logger.debug("remove document [{}] ids [{}]", (Object)modelName, (Object)ids);
    }

    @Transactional
    public Archive saveArchive(Archive archive) {
        if (this.dwdmEnable) {
            if (StringUtils.isBlank((String)archive.getDwdm())) {
                archive.setDwdm(this.getDwdm());
            }
            if (this.jiangyinEnable) {
                this.setQzhByDwdm(archive);
            }
        }
        if (StringUtils.isEmpty((String)archive.getId())) {
            archive.setId(UUIDHexGenerator.generate());
        }
        return (Archive)this.entityService.save((Object)archive);
    }

    @Transactional
    public Document saveDocument(Document document) {
        if (this.dwdmEnable) {
            document.setDwdm(this.getDwdm());
        }
        return (Document)this.entityService.save((Object)document);
    }

    public Page<Archive> searchArchive(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        ArrayList<? extends Criterion> list = new ArrayList<Criterion>(criterions);
        if (this.dwdmEnable && !SessionUtil.getCurrentUser().isAdmin()) {
            list.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"dwdm"), (Criterion)Restrictions.eq((String)"dwdm", (Object)this.getDwdm())));
        }
        return this.entityService.search(modelName, list, orders == null ? Collections.singletonList(Order.desc((String)"id")) : orders, start, limit);
    }

    public Page<Document> searchDocument(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        ArrayList<? extends Criterion> list = new ArrayList<Criterion>(criterions);
        if (this.dwdmEnable && !SessionUtil.getCurrentUser().isAdmin()) {
            list.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"dwdm"), (Criterion)Restrictions.eq((String)"dwdm", (Object)this.getDwdm())));
        }
        return this.entityService.search(Archive.toDocumentModelName((String)modelName), list, orders == null ? Collections.singletonList(Order.desc((String)"id")) : orders, start, limit);
    }

    public int getArchiveCount(String modelName, List<? extends Criterion> criterions) {
        return this.entityService.getCount(modelName, criterions);
    }

    public Page<Archive> searchArchive(String modelName, List<? extends Criterion> criterions, List<Order> orders, String dwdm, boolean flag, int start, int limit) {
        ArrayList<? extends Criterion> list = new ArrayList<Criterion>(criterions);
        if (flag) {
            list.add((Criterion)Restrictions.eq((String)"dwdm", (Object)dwdm));
            list.add((Criterion)Restrictions.isNull((String)"primdwdm"));
        } else {
            list.add((Criterion)Restrictions.eq((String)"primdwdm", (Object)dwdm));
        }
        return this.entityService.search(modelName, list, orders == null ? Collections.singletonList(Order.desc((String)"id")) : orders, start, limit);
    }

    public Page<Archive> searchArchive(String modelName, List<? extends Criterion> criterions, List<Order> orders, String dwdm, int start, int limit) {
        ArrayList<? extends Criterion> list = new ArrayList<Criterion>(criterions);
        if (this.dwdmEnable && !SessionUtil.getCurrentUser().isAdmin() && StringUtils.isNotBlank((String)dwdm)) {
            list.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"dwdm"), (Criterion)Restrictions.eq((String)"dwdm", (Object)dwdm)));
        }
        return this.entityService.search(modelName, list, orders == null ? Collections.singletonList(Order.desc((String)"id")) : orders, start, limit);
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    private void setQzhByDwdm(Archive archive) {
        if (StringUtils.isBlank((String)archive.getDwdm())) {
            return;
        }
        String dwdm = archive.getDwdm();
        try {
            List items = this.dictService.getItems("qzhdwdm");
            for (Item item : items) {
                if (!dwdm.equals(item.getName())) continue;
                archive.setQzh(item.getValue());
                break;
            }
        }
        catch (Exception ex) {
            logger.info("\u672a\u914d\u7f6e[{}]\u5355\u4f4d\u4ee3\u7801\u5168\u5b97\u53f7\u5b57\u5178\u9879", (Object)"qzhdwdm");
        }
    }

    @Transactional
    public List<Archive> findAllArchive(int start, int size) {
        String hql = "select new com.gtis.archive.entity.Archive(archive.id, archive.qzh, archive.mlh, archive.flh, archive.ajh) from Archive archive";
        Session session = this.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        Query query = session.createQuery(hql);
        query.setFirstResult(start);
        query.setMaxResults(size);
        List archives = query.list();
        session.getTransaction().commit();
        return archives;
    }

    @Transactional
    public int findAllArchiveSize() {
        String hql = "select count(archive.id) from Archive archive ";
        int s = 0;
        try {
            Session session = this.getSessionFactory().getCurrentSession();
            session.beginTransaction();
            Query query = session.createQuery(hql);
            Object object = query.uniqueResult();
            s = Integer.parseInt(object.toString());
            session.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }
}

