/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.entity;

import com.gtis.archive.entity.Document;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="t_archive")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Archive {
    public static final String MODEL_NAME = Archive.class.getSimpleName();
    public static final String DOCUMENT_SUFFIX = "_jn";
    public static final int STATE_WGD = 0;
    public static final int STATE_YGD = 1;
    @Id
    @Column(length=32)
    private String id;
    @Column(length=10)
    private String modelName = this.getClass().getSimpleName();
    @Column(length=100)
    private String dh;
    @Column(length=100, nullable=true)
    private String dwdm;
    @Column(length=100, nullable=false)
    private String qzh;
    @Column(length=100)
    private String mlh;
    @Column
    private Integer ajh;
    @Column(length=1000)
    private String tm;
    @Column(length=100)
    private String flh;
    @Column(length=10)
    private String nd;
    private Date qrq;
    private Date zrq;
    @Column
    private Integer js;
    @Column
    private Integer ys;
    @Column(length=10, nullable=false)
    private String bgqx;
    @Column(length=10, nullable=false)
    private String mj;
    @Column(length=100)
    private String xh;
    @Column(length=100)
    private String cfwz;
    @Column(length=1000)
    private String bz;
    private Date gdsj;
    @Column(length=100)
    private String resourceId;
    @Column
    private int state;
    private String sqrq;
    private String szrq;
    @Transient
    private Boolean hasOriginal;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        if (StringUtils.isNotEmpty((String)modelName)) {
            this.modelName = modelName;
        }
    }

    public String getDh() {
        return this.dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getDwdm() {
        return this.dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getQzh() {
        return this.qzh;
    }

    public void setQzh(String qzh) {
        this.qzh = qzh;
    }

    public String getMlh() {
        return this.mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public Integer getAjh() {
        return this.ajh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public String getTm() {
        return this.tm;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    public String getFlh() {
        return this.flh;
    }

    public void setFlh(String flh) {
        this.flh = flh;
    }

    public String getNd() {
        return this.nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public Date getQrq() {
        return this.qrq;
    }

    public void setQrq(Date qrq) {
        this.qrq = qrq;
    }

    public Date getZrq() {
        return this.zrq;
    }

    public void setZrq(Date zrq) {
        this.zrq = zrq;
    }

    public Integer getJs() {
        return this.js;
    }

    public void setJs(Integer js) {
        this.js = js;
    }

    public Integer getYs() {
        return this.ys;
    }

    public void setYs(Integer ys) {
        this.ys = ys;
    }

    public String getBgqx() {
        return this.bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = StringUtils.trim((String)bgqx);
    }

    public String getMj() {
        return this.mj;
    }

    public void setMj(String mj) {
        this.mj = StringUtils.trim((String)mj);
    }

    public String getXh() {
        return this.xh;
    }

    public void setXh(String xh) {
        this.xh = xh;
    }

    public String getCfwz() {
        return this.cfwz;
    }

    public void setCfwz(String cfwz) {
        this.cfwz = cfwz;
    }

    public String getBz() {
        return this.bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public Date getGdsj() {
        return this.gdsj;
    }

    public void setGdsj(Date gdsj) {
        this.gdsj = gdsj;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getSqrq() {
        return this.sqrq;
    }

    public void setSqrq(String sqrq) {
        this.sqrq = sqrq;
    }

    public String getSzrq() {
        return this.szrq;
    }

    public void setSzrq(String szrq) {
        this.szrq = szrq;
    }

    public Boolean getHasOriginal() {
        return this.hasOriginal;
    }

    public void setHasOriginal(Boolean hasOriginal) {
        this.hasOriginal = hasOriginal;
    }

    public static boolean isArchiveModelName(String modelName) {
        return !modelName.endsWith(DOCUMENT_SUFFIX) && !Document.MODEL_NAME.endsWith(modelName);
    }

    public static String toDocumentModelName(String archiveModelName) {
        if (archiveModelName.endsWith(DOCUMENT_SUFFIX)) {
            return archiveModelName;
        }
        if (MODEL_NAME.equals(archiveModelName) || Document.MODEL_NAME.equals(archiveModelName)) {
            return Document.MODEL_NAME;
        }
        return archiveModelName + DOCUMENT_SUFFIX;
    }

    public Archive(String id, String qzh, String mlh, String flh, Integer ajh) {
        this.id = id;
        this.qzh = qzh;
        this.mlh = mlh;
        this.flh = flh;
        this.ajh = ajh;
    }

    public Archive() {
    }
}

