/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseAction;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.SearchUtils;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseModelAction<T>
extends BaseAction {
    public static final String DIR_ASC = "asc";
    public static final String DIR_DESC = "desc";
    protected static final Map<String, String[]> idsCaches = Collections.synchronizedMap(new LRUMap(500));
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    protected DictService dictService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private SecurityService securityService;
    protected int start = 0;
    protected int limit = 20;
    protected String sort;
    protected String dir;
    protected String modelName;
    protected String printType;
    protected String query;
    protected String condition;
    protected String[] ids;
    protected String idsKey;
    protected List<T> entities;
    private Map showFields;
    private boolean isPrint;
    private String passWord;
    private String oldPassWord;

    public BaseModelAction() {
        Type params;
        Type genType = this.getClass().getGenericSuperclass();
        if (genType instanceof ParameterizedType && (params = ((ParameterizedType)genType).getActualTypeArguments()[0]) instanceof Class) {
            this.setModelName(((Class)params).getSimpleName());
        }
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName.startsWith("a_") ? modelName.substring(2) : modelName;
    }

    public void setPrintType(String printType) {
        this.printType = printType;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setId(String[] ids) {
        this.ids = ids;
    }

    public void setIdsKey(String idsKey) {
        this.idsKey = idsKey;
    }

    public int getLimit() {
        String pageSize;
        if (this.limit == 20 && StringUtils.isNotBlank((String)(pageSize = this.getEntityModel().getEnv().get((Object)"pageSize")))) {
            this.limit = Integer.parseInt(pageSize);
        }
        return this.limit;
    }

    public String getModelName() {
        return this.modelName;
    }

    public List<T> getEntities() {
        if (this.entities == null) {
            this.entities = this.getEntityPage().getItems();
            if (this.modelName.toLowerCase().equals("ythsw") && EnvHolder.isEnable((String)"jiangyin.enable") && this.isPrint) {
                try {
                    PropertyUtils.setProperty(this.entities.get(0), (String)"oragn", (Object)this.getRagon());
                }
                catch (Exception ex) {
                    this.logger.error(ex.toString());
                }
            }
        }
        return this.entities;
    }

    public Model getEntityModel() {
        return this.modelService.getModel(this.modelName);
    }

    public Map<String, Field> getFields() {
        return this.getEntityModel().getInheritfieldsMap();
    }

    public Map getShowFields() {
        if (this.showFields == null) {
            this.showFields = (Map)JSON.parseObject((String)this.getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return this.showFields == null ? Collections.emptyMap() : this.showFields;
    }

    public String getId() {
        return this.ids == null ? null : this.ids[0];
    }

    public String list() throws Exception {
        try {
            this.renderJson((Object)this.getEntityPage());
        }
        catch (Exception e) {
            this.renderJson((Object)new Page());
        }
        return null;
    }

    public String cacheIds() {
        String key = UUIDHexGenerator.generate();
        idsCaches.put(key, this.ids);
        return this.renderJson(Collections.singletonMap("idsKey", key));
    }

    public String print() throws Exception {
        this.isPrint = true;
        return this.renderTemplate(this.getEntityModel().getTemplate("print"));
    }

    public String fr3() throws Exception {
        this.sendFile(this.getEntityModel().getPrintFr3(this.printType));
        return null;
    }

    public String export() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=" + this.modelName + "-export.xls");
        this.entities = this.getEntityPage().getItems();
        return this.renderModelTemplate("export");
    }

    public String remove() throws Exception {
        this.entityService.remove(this.modelName, this.ids);
        return null;
    }

    protected Page<T> getEntityPage() {
        if (StringUtils.isNotEmpty((String)this.idsKey)) {
            this.ids = (String[])idsCaches.get(this.idsKey);
        }
        if (this.ids != null) {
            this.entities = new ArrayList(this.ids.length);
            for (String id : this.ids) {
                this.entities.add(this.entityService.load(this.modelName, id));
            }
            return new Page(this.entities);
        }
        List criterions = this.createCriterions(new ArrayList());
        List orders = this.createOrders(new ArrayList());
        return this.searchEntity(criterions, orders);
    }

    protected Page<T> searchEntity(List<Criterion> criterions, List<Order> orders) {
        return this.entityService.search(this.modelName, criterions, orders, this.start, this.limit);
    }

    protected List<Order> createOrders(ArrayList<Order> orders) {
        if (StringUtils.isNotEmpty((String)this.sort)) {
            if (DIR_ASC.equalsIgnoreCase(this.dir)) {
                orders.add(Order.asc((String)this.sort));
            } else {
                orders.add(Order.desc((String)this.sort));
            }
        }
        if (orders.isEmpty()) {
            for (Map.Entry entry : this.getOrderFields().entrySet()) {
                orders.add(((String)entry.getValue()).equalsIgnoreCase(DIR_ASC) ? Order.asc((String)((String)entry.getKey())) : Order.desc((String)((String)entry.getKey())));
            }
        }
        return orders;
    }

    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        String[] fields;
        if (StringUtils.isNotBlank((String)this.condition)) {
            criterions.addAll(SearchUtils.conditionToCriterion((Map)this.getFields(), (String)this.condition));
        }
        if (StringUtils.isNotBlank((String)this.query) && (fields = this.getQueryFields()) != null) {
            SimpleExpression cr = null;
            for (String field : fields) {
                cr = cr == null ? Restrictions.like((String)field, (Object)("%" + this.query + "%")) : Restrictions.or((Criterion)cr, (Criterion)Restrictions.like((String)field, (Object)("%" + this.query + "%")));
            }
            if (cr != null) {
                criterions.add((Criterion)cr);
            }
        }
        return criterions;
    }

    public Map<String, Field> getAdvSearchFields() {
        Map allFields = this.getFields();
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        try {
            String[] filters = StringUtils.split((String)this.getEntityTemplate("advSearchFields"), (String)",");
            if (filters.length == 0) {
                return fields;
            }
            for (String name : filters) {
                if (!allFields.containsKey(name)) continue;
                fields.put(name, (Field)allFields.get(name));
            }
        }
        catch (TemplateNotFoundException e) {
            return allFields;
        }
        return fields;
    }

    protected LinkedHashMap<String, String> getOrderFields() {
        try {
            if (this.isPrint) {
                this.isPrint = false;
                return (LinkedHashMap)JSON.parseObject((String)this.getEntityTemplate("printOrderFields"), LinkedHashMap.class);
            }
            return (LinkedHashMap)JSON.parseObject((String)this.getEntityTemplate("orderFields"), LinkedHashMap.class);
        }
        catch (TemplateNotFoundException ex) {
            return (LinkedHashMap)JSON.parseObject((String)this.getEntityTemplate("orderFields"), LinkedHashMap.class);
        }
    }

    protected String[] getQueryFields() {
        return StringUtils.split((String)this.getEntityTemplate("queryFields"), (String)",");
    }

    protected String getEntityTemplate(String name) {
        return this.getEntityModel().getTemplate(name);
    }

    protected String renderModelTemplate(String name) throws Exception {
        return this.renderTemplate(this.getEntityTemplate(name));
    }

    private String getRagon() {
        String oragn = "";
        String dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
        try {
            List items = this.dictService.getItems("oragn");
            for (Item item : items) {
                if (!dwdm.equals(item.getName())) continue;
                oragn = item.getValue();
                break;
            }
        }
        catch (Exception ex) {
            this.logger.info("\u672a\u914d\u7f6e[{}]\u7ec4\u7ec7\u673a\u6784\u5b57\u5178\u9879", (Object)"oragn");
        }
        return oragn;
    }

    public boolean isAdmin() {
        return SessionUtil.getCurrentUser().isAdmin();
    }

    public Map<String, Boolean> getSysPerms() {
        HashMap<String, Boolean> perms = new HashMap<String, Boolean>();
        for (Item item : this.dictService.getItems("sysPerm")) {
            if (!this.securityService.isPermitted("sys", item.getName())) continue;
            perms.put(item.getName(), true);
        }
        return perms;
    }

    public List<Map<String, String>> getAbs() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        List items = this.dictService.getItems("hc_" + dwdm);
        ArrayList<Map<String, String>> abs = new ArrayList<Map<String, String>>();
        for (Item item : items) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", item.getName());
            map.put("value", item.getValue());
            map.put("itemId", item.getId());
            abs.add(map);
        }
        return abs;
    }

    public String getUserName() {
        return this.userService.getUserVo(SessionUtil.getCurrentUserId()).getUserName();
    }

    public String changePassword() {
        String mssg = "";
        String oldPd = this.userService.getUserVo(SessionUtil.getCurrentUserId()).getLoginPassWord();
        mssg = !oldPd.equals(Md5Util.Build((String)this.oldPassWord)) ? "{result: \"failed\",mssg: \"\u5f53\u524d\u5bc6\u7801\u4e0d\u6b63\u786e!\"}" : (this.userService.savePassWord(SessionUtil.getCurrentUserId(), this.passWord) ? "{result: \"success\",mssg: \"\u4fdd\u5b58\u6210\u529f!\"}" : "{result: \"failed\",mssg: \"\u4fdd\u5b58\u5931\u8d25!\"}");
        Struts2Utils.renderJson((String)mssg, (String[])new String[0]);
        return null;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getOldPassWord() {
        return this.oldPassWord;
    }

    public void setOldPassWord(String oldPassWord) {
        this.oldPassWord = oldPassWord;
    }
}

