/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: UploadDialog.js
 *
 * LastModified: 2009-10-16 03:35:51
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

var UploadFlash = Ext.extend(Ext.FlashComponent, {
    initComponent:function () {
        UploadFlash.superclass.initComponent.call(this);
        this.addEvents('close');
        this.flashVars = {
            elementID:this.getId(),
            eventHandler:'Ext.FlashEventProxy.onEvent'
        };
    },
    onSwfReady:function () {
        var swf = this.swf;
        swf.setUploadPage(this.uploadPage);
        swf.setCheckNameUrl(this.checkNameUrl);
        if (this.maxSize)
            swf.setUploadFileSize(this.maxSize);
        if (this.typeDescription)
            swf.setFileTypeDescription(this.typeDescription);
        if (this.fileTypes)
            swf.setFileTypes(this.fileTypes);
        if (this.nodeId)
            swf.setNoId(this.nodeId);
        if (this.path)
            swf.setPath(this.path);
        if (this.autoRename)
            swf.setAutoRename(this.autoRename);
        if (this.autoClose)
            swf.setAutoClose(this.autoClose);
    },
    setNodeId:function (nodeId) {
        if (this.isInitialized)
            this.swf.setNoId(nodeId);
        else
            this.nodeId = nodeId;
    },
    clearFiles:function () {
        this.swf.clearFiles();
    }
});

var OcxUploadPanel = Ext.extend(Ext.Panel, {
    afterRender:function () {
        OcxUploadPanel.superclass.afterRender.call(this);
        this.body.appendChild(this.ocx);
        var self = this;
        window._uploaded = function () {
            self.fireEvent('close');
        };
    },
    setNodeId:function (nodeId) {
        var url = location.href;
        url = url.substring(0, url.lastIndexOf('/') + 1);
        this.ocx.UploadUrl = url + this.getUrl('og!upload.action') + '&callBack=_uploaded&nid=' + nodeId;
    },
    clearFiles:function () {
    }
});

function uploadfile(asd){
    _uploadOcx.upload();
}

function uploadfinish(){

}



//723318B4-F4CB-48A0-96F2-8DA7A41D0625
//530B26F6-0AD3-4D5A-898C-0E8326CFF7B6
var UploadDialog = function (config) {
    Ext.apply(this, config);

    try {
        this.ocxDiv = Ext.DomHelper.append(Ext.getBody(), {html:'<object width="100%" height="100%" id="_uploadOcx" classid="clsid:723318B4-F4CB-48A0-96F2-8DA7A41D0625"><param name="monitorpath" value="c:\\workspace"><param name="UploadUrl" value="#"></object>'}, true);
        var ocx = Ext.getDom('_uploadOcx');
        if (ocx.UploadUrl) {
            _uploadOcx.setdoc(document);
            this.uploadPanel = new OcxUploadPanel({getUrl:this.getUrl, ocx:ocx});
            this.width = Ext.lib.Dom.getViewWidth() * .9;
            this.height = Ext.lib.Dom.getViewHeight() * .9;
        } else {
            this.ocxDiv.remove();
            this.uploadPanel = new UploadFlash(Ext.apply(config, {
                backgroundColor:'#dfe8f6',
                url:this.getUrl('flash/flashUpload.swf'),
                uploadPage:this.getUrl('og!upload.action'),
                checkNameUrl:this.getUrl('og!check.action')
            }));
        }
    } catch (e) {
    }

    this.uploadPanel.on('close', function () {
        this.fireEvent('hide', this, this.id);
        this.uploadPanel.clearFiles();
        this.close();
    }, this);

    UploadDialog.superclass.constructor.call(this, {
        title:'上传文件',
        iconCls:'fc-upload',
        layout:'fit',
        width:this.width || 600,
        height:this.height || 450,
        modal:true,
        plain:true,
        items:this.uploadPanel
    });
};

Ext.extend(UploadDialog, Ext.Window, {
    show:function (nid) {
        this.uploadPanel.setNodeId(nid);
        UploadDialog.superclass.show.call(this);
    }
});

Ext.util.Format.def = function (v, dv, max) {
    if (!v)
        return dv || '';
    if (max)
        return Ext.util.Format.ellipsis(v, max);
    return v;
};

Ext.util.Format.renderDate=function(v,format) {
    var o;
    if(!Ext.isEmpty(v) && v.toString().indexOf("-")!=-1){
        v= Date.parse(v.toString().replace(/-/g, "/"));
    }
    if (Ext.isEmpty(v))
        return '';
    else if (Ext.isEmpty(v.time))
        o = new Date(v);
    else
        o = new Date(v.time);
    return o.format(format || 'Y-m-d H:i:s');
};

var Archive = {};

Archive.ToolTip = Ext.extend(Ext.Tip, {
    style:'z-index:9000',
    defaultAlign:'br',
    floating:{shadow:true, shim:false, useDisplay:true, constrain:false},
    initComponent:function () {
        Archive.ToolTip.superclass.initComponent.call(this);
        if (this.target) {
            this.target = Ext.get(this.target);
        }
    },
    onShow:function () {
        Ext.ToolTip.superclass.onShow.call(this);
        Ext.getDoc().on('mousedown', this.onDocMouseDown, this);
    },

    // private
    onHide:function () {
        Ext.ToolTip.superclass.onHide.call(this);
        Ext.getDoc().un('mousedown', this.onDocMouseDown, this);
    },
    onDocMouseDown:function (e) {
        if (!e.within(this.el.dom)) {
            this.hide();
        }
    },
    setHtml:function (s) {
        this.body.update(s);
    }
});

Archive.OgTip = Ext.extend(Ext.ToolTip, {
    show:function () {
        Archive.OgTip.superclass.show.call(this);
        var wh = Ext.lib.Dom.getViewportHeight(), h = this.getHeight(), pos = this.getPosition(), sc = document.documentElement.scrollTop;
        if (pos[1] - sc + h + 10 > wh) {
            this.showAt([ pos[0], wh - h - 30 + sc]);
        }
    }
});