<@layout.html title="档案原文列表" import="ext,jquery,base,main">
<div id="originalList">
</div>
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript" src="js/ext/ux/ComboPageSize.js"></script>
<script type="text/javascript">
    var _jsessionid = '${sessionId}';
    var ogDs;

    function getJsessionidUrl(url) {
        var index = url.indexOf('?');
        if (index > -1) {
            return url.substring(0, index) + ';jsessionid=' + _jsessionid + url.substr(index);
        } else {
            return url + ';jsessionid=' + _jsessionid;
        }
    }

    function showPreview(nids) {
        if (!Ext.isDefined(window.hasEPreOcx)) {
            try {
                new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
                window.hasEPreOcx = true;
            } catch (e) {
                window.hasEPreOcx = false;
            }
        }
        if (window.hasEPreOcx) {
            var base = location.href.substring(0, location.href.lastIndexOf('/'));
            var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
            link = link.substr(link.indexOf('//') + 2);
            Ext.Ajax.request({
                url:'archive!cacheIds.action',
                params:{id:nids},
                success:function (r) {
                    var json = Ext.decode(r.responseText);
                    location.href = 'epre://'+link + json['idsKey'];
                }
            });
        } else {
            window.open('og!get.action?preview=true&id=' + nids[0]);
        }
    }

    Ext.onReady(function(){
         ogDs = new Ext.data.JsonStore({
            url:'og!list.action?ownerId=' + '${id}',
            autoLoad:true,
            totalProperty:'totalCount',
            root:'items',
            fields:[
                'id', 'name', 'fileSize', 'updateTime'
            ]
        });
        var ogSm = new Ext.grid.CheckboxSelectionModel();
        var formatSize = function (size, p, record) {
            return Ext.util.Format.fileSize(size);
        };
        var ogGrid = new Ext.grid.GridPanel({
            cls:'og',
            border:true,
            store:ogDs,
            height:400,
            sm:ogSm,
            loadMask:true,
            stripeRows:true,
            region:'center',
            bbar:new Ext.PagingToolbar({
                pageSize:20, //每页显示几条数据
                store:ogDs,
                displayInfo:true,
                displayMsg:'{0} - {1} 共 {2} 条',
                emptyMsg:"没有记录返回" }),
            viewConfig: {
                forceFit: true
            },
            cm:new Ext.grid.ColumnModel([
                //new Ext.grid.RowNumberer(),//显示行号
                ogSm,
                {header:"名称", sortable:true, dataIndex:'name'},
                {header:"大小", sortable:true, dataIndex:'fileSize', renderer:formatSize},
                {header:"上传时间", sortable:true, dataIndex:'updateTime'}
            ]),
            tbar:[
                {
                    text:'查看',
                    iconCls:'preview',
                    handler:function () {
                        if (ogSm.getSelections().length == 0) {
                            Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                            return;
                        }
                        var nids = [];
                        for (var i = 0; i < ogSm.getSelections().length; i++) {
                            nids.push(ogSm.getSelections()[i].data.id);
                        }
                        showPreview(nids);
                    }
                },
                '->'
//                ,
//                new Ext.ux.form.SearchField({
//                    id:'searchBox1',
//                    style:{'margin':'0,0,0,150px'},
//                    store:ogDs,
//                    width:150,
//                    renderTo:'searchBox'
//                })
            ] ,
            listeners:{
                rowdblclick:function (g, index, e) {
                        var id = ogDs.getAt(index).id;
                        showPreview([id]);
                },
                render:function (g) {
                    var store = g.getStore();
                    var view = g.getView();
                    g.tip = new Archive.OgTip({
                        dismissDelay:0,
                        target:view.mainBody,
                        delegate:'.x-grid3-row',
                        autoWidth:!Ext.isIE6,
                        renderTo:document.body,
                        listeners:{
                            beforeshow:function (tip) {
                                var rowIndex = view.findRowIndex(tip.triggerElement);
                                tip.body.update('<img src="' + 'og!thumb.action?modelName=' +'${modelName}' + '&id=' + store.getAt(rowIndex).id + '"/>');
                            }
                        }
                    });
                }
            }
        });
        ogGrid.render('originalList');
        window.onresize=function(){
            ogGrid.setWidth(Ext.get("originalList").getComputedWidth());
        };
    });
</script>
</@layout.html>