<@layout.admin import="ext">
<div id="treeBox"></div>
<script type="text/javascript">
    $(function() {
        Ext.QuickTips.init();
        function getValue(name) {
            return fp.form.findField(name).getValue();
        }

        function setValue(name, value) {
            return fp.form.findField(name).setValue(value);
        }

        var fp = new Ext.FormPanel({
            labelWidth: 45,
            url:'tree!edit.action?type=model',
            frame:true,
            border:false,
            bodyStyle:'padding:5px',
            defaultType: 'textfield',
            items: [
                {
                    fieldLabel: '名称',
                    name: 'res.name',
                    anchor:'100%',
                    allowBlank:false
                },
                {
                    fieldLabel: '标题',
                    name: 'res.title',
                    anchor:'100%'
                },
                {
                    fieldLabel:'分类号',
                    name:'res.flh',
                    allowBlank:true,
                    anchor:'100%'
                },
                {
                    fieldLabel: '顺序号',
                    xtype:'numberfield',
                    maxLength:5,
                    name: 'res.orderNumber',
                    anchor:'100%'
                },
                {
                    fieldLabel: '内容',
                    xtype:'textarea',
                    name: 'res.content',
                    anchor:'100%'
                },
                {
                    xtype:'hidden',
                    name: 'res.parentId'
                },
                {
                    xtype:'hidden',
                    name: 'res.id'
                }
            ],
            buttons: [
                {
                    text:'保存',
                    handler: function() {
                        if (fp.getForm().isValid()) {
                            var node = tree.getSelectionModel().getSelectedNode();
                            fp.getForm().submit({
                                waitMsg: '正在保存...',
                                success: function() {
                                    win.hide();
                                    if (getValue('res.id')) {
                                        var title = getValue('res.title'),name = getValue('res.name');
                                        node.setText(title ? name + '(' + title + ')' : name);
                                        node.attributes.content = getValue('res.content');
                                        node.attributes.title = getValue('res.title');
                                        node.attributes.orderNumber = getValue('res.orderNumber');
                                        node.attributes.flh=getValue("res.flh");
                                        node.attributes.name = name;
                                    }
                                    node.reload();
                                },
                                failure:function(fp, action) {
                                    if (action.response.responseText)
                                        fp.findField('res.name').markInvalid('该名称已被使用！');
                                },
                                scope:this
                            });
                        }
                    },
                    scope:this
                },
                {
                    text: '关闭',
                    handler: function() {
                        win.hide();
                    }
                }
            ]
        });
        var win = new Ext.Window({
            title:'目录管理',
            layout:'fit',
            width:400,
            height:250,
            border:false,
            closeAction:'hide',
            modal: true,
            plain: true,
            items:fp
        });
        var tree = new Ext.tree.TreePanel({
            height:400,
            autoScroll: true,
            renderTo:'treeBox',
            loader: new Ext.tree.TreeLoader(),
            tbar:[
                {
                    id:'addNode',
                    iconCls:'add-node',
                    text:'新增',
                    handler: function() {
                        var n = tree.getSelectionModel().getSelectedNode();
                        if (n) {
                            var form = fp.form;
                            setValue('res.title',"");
                            setValue('res.content',"");
                            setValue('res.id',"");
                            setValue('res.orderNumber',"");
                            setValue('res.flh',"");
                            setValue('res.parentId',n.id == 'rootNode' ? '' : n.id);
                            win.show();
                        } else {
                            Ext.MessageBox.alert('提示', '请先选择一个目录');
                        }
                    },
                    scope: this
                },
                {
                    id:'editNode',
                    iconCls:'edit-node',
                    text:'修改',
                    handler: function() {
                        var n = tree.getSelectionModel().getSelectedNode();
                        if (n) {
                            var form = fp.form;
                            setValue('res.name',n.attributes.name);
                            setValue('res.title',n.attributes.title);
                            setValue('res.content',n.attributes.content);
                            setValue('res.orderNumber',n.attributes.orderNumber);
                            setValue('res.flh', n.attributes.flh);
                            setValue('res.id',n.id);
                            setValue('res.parentId',n.attributes.parentId);
                            win.show();
                        } else {
                            Ext.MessageBox.alert('提示', '请先选择一个目录');
                        }
                    },
                    scope: this
                },
                {
                    id:'delNode',
                    iconCls:'del-node',
                    text:'删除',
                    handler: function() {
                        var n = tree.getSelectionModel().getSelectedNode();
                        if (n) {
                            Ext.MessageBox.confirm('确认', '确定要删除 ' + n.text + ' 吗?', function(btn) {
                                if (btn != 'yes')
                                    return;
                                Ext.Ajax.request({
                                    url:'tree!del.action',
                                    params:{id:n.id},
                                    success:function() {
                                        n.remove();
                                    },
                                    scope:this
                                });
                            }, this);
                        } else {
                            Ext.MessageBox.alert('提示', '请先选择一个目录');
                        }
                    },
                    scope: this
                }
            ],
            root:new Ext.tree.AsyncTreeNode({
                id:'rootNode',
                text: '根分类',
                iconCls:'root'
            }),
            listeners:{
                render:function(tree) {
                    tree.getRootNode().expand(false, false);
                },
                beforeload:function(node) {
                    this.loader.dataUrl = 'tree!node.action?type=model&id=' + (node.id == 'rootNode' ? '' : node.id);
                }
            }
        });
    });
</script>
</@layout.admin>