/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web.admin;

import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelManager;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.core.generater.ModelCodeGenerater;
import com.gtis.archive.core.support.hibernate.ReloadableSessionFactory;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name="toIndex", location="model.action", type="redirect"), @Result(name="toTplList", location="model!tplList.action?name=${name}", type="redirect")})
public class ModelAction
extends ActionSupport
implements Preparable {
    private static final Pattern MODEL_NAME_PATTERN = Pattern.compile("[a-zA-Z_]\\w*");
    private static final long serialVersionUID = -3310497863268668088L;
    @Autowired
    private ModelManager modelManager;
    @Autowired
    private ModelService modelService;
    @Autowired
    private ReloadableSessionFactory reloadableSessionFactory;
    private String name;
    private Model model;
    private List<String> envName;
    private List<String> envValue;
    private List<String> fieldName;
    private List<String> fieldtitle;
    private List<String> fieldremark;
    private List<String> fieldtype;
    private List<Integer> fieldlength;
    private List<Boolean> fieldnullable;
    private List<String> fieldvalueDict;
    private List<String> fieldvalidation;
    private List<String> fielddefaultValue;
    private String msg;
    private String tplName;
    private String tplContent;

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTplContent() {
        return this.tplContent;
    }

    public void setTplContent(String tplContent) {
        this.tplContent = tplContent;
    }

    public String getTplName() {
        return this.tplName;
    }

    public void setTplName(String tplName) {
        this.tplName = tplName;
    }

    public void setEnvName(List<String> envName) {
        this.envName = envName;
    }

    public void setEnvValue(List<String> envValue) {
        this.envValue = envValue;
    }

    public void setFieldName(List<String> fieldName) {
        this.fieldName = fieldName;
    }

    public void setFielddefaultValue(List<String> fielddefaultValue) {
        this.fielddefaultValue = fielddefaultValue;
    }

    public void setFieldlength(List<Integer> fieldlength) {
        this.fieldlength = fieldlength;
    }

    public void setFieldnullable(List<Boolean> fieldnullable) {
        this.fieldnullable = fieldnullable;
    }

    public void setFieldremark(List<String> fieldremark) {
        this.fieldremark = fieldremark;
    }

    public void setFieldtitle(List<String> fieldtitle) {
        this.fieldtitle = fieldtitle;
    }

    public void setFieldtype(List<String> fieldtype) {
        this.fieldtype = fieldtype;
    }

    public void setFieldvalidation(List<String> fieldvalidation) {
        this.fieldvalidation = fieldvalidation;
    }

    public void setFieldvalueDict(List<String> fieldvalueDict) {
        this.fieldvalueDict = fieldvalueDict;
    }

    public String execute() throws Exception {
        return "success";
    }

    public void prepare() throws Exception {
        this.model = StringUtils.isNotBlank((String)this.name) ? this.modelService.getModel(this.name) : new Model();
    }

    public String edit() throws Exception {
        if (Struts2Utils.isPost()) {
            int i;
            if (this.envName != null) {
                Environment env = new Environment();
                for (i = 0; i < this.envName.size(); ++i) {
                    if (StringUtils.isBlank((String)((String)this.envName.get(i)))) continue;
                    env.put((String)this.envName.get(i), (String)this.envValue.get(i));
                }
                this.model.setEnv(env);
            }
            if (StringUtils.isBlank((String)this.model.getParentName()) || this.model.getParentName().equals(this.model.getName())) {
                this.model.setParentName(null);
            }
            if (StringUtils.isBlank((String)this.model.getTitle())) {
                this.model.setTitle(null);
            }
            if (StringUtils.isBlank((String)this.model.getRemark())) {
                this.model.setRemark(null);
            }
            LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
            if (this.fieldName != null) {
                for (i = 0; i < this.fieldName.size(); ++i) {
                    String name = (String)this.fieldName.get(i);
                    if (StringUtils.isBlank((String)name)) continue;
                    Field field = new Field();
                    field.setName(name);
                    String title = (String)this.fieldtitle.get(i);
                    String remark = (String)this.fieldremark.get(i);
                    String valueDict = (String)this.fieldvalueDict.get(i);
                    String validation = (String)this.fieldvalidation.get(i);
                    String defaultValue = (String)this.fielddefaultValue.get(i);
                    if (this.fieldtype == null) continue;
                    if (this.fieldtype.size() > i) {
                        field.setType(Field.Type.valueOf((String)((String)this.fieldtype.get(i))));
                        if (this.fieldlength.get(i) != null) {
                            field.setLength((Integer)this.fieldlength.get(i));
                        }
                        field.setNullable((Boolean)this.fieldnullable.get(i));
                        if (StringUtils.isNotBlank((String)title)) {
                            field.setTitle(title);
                        }
                        if (StringUtils.isNotBlank((String)remark)) {
                            field.setRemark(remark);
                        }
                        if (StringUtils.isNotBlank((String)valueDict)) {
                            field.setValueDict(valueDict);
                        }
                        if (StringUtils.isNotBlank((String)validation)) {
                            field.setValidation(validation);
                        }
                        if (StringUtils.isNotBlank((String)defaultValue)) {
                            field.setDefaultValue(defaultValue);
                        }
                        fields.add(field);
                        continue;
                    }
                    Field parentField = this.model.getParent().getInheritField(name);
                    boolean fieldChange = false;
                    if (StringUtils.isNotBlank((String)title) && !title.equals(parentField.getTitle())) {
                        field.setTitle(title);
                        fieldChange = true;
                    }
                    if (StringUtils.isNotBlank((String)remark) && !remark.equals(parentField.getRemark())) {
                        field.setRemark(remark);
                        fieldChange = true;
                    }
                    if (StringUtils.isNotBlank((String)valueDict) && !valueDict.equals(parentField.getValueDict())) {
                        field.setValueDict(valueDict);
                        fieldChange = true;
                    }
                    if (StringUtils.isNotBlank((String)validation) && !validation.equals(parentField.getValidation())) {
                        field.setValidation(validation);
                        fieldChange = true;
                    }
                    if (StringUtils.isNotBlank((String)defaultValue) && !defaultValue.equals(parentField.getDefaultValue())) {
                        field.setDefaultValue(defaultValue);
                        fieldChange = true;
                    }
                    if (!fieldChange) continue;
                    fields.add(field);
                }
                this.model.setFields(fields);
            }
            if (StringUtils.isBlank((String)this.name)) {
                try {
                    this.modelService.getModel(this.model.getName());
                    this.msg = "existed";
                    return "edit";
                }
                catch (Exception e) {
                    if (!MODEL_NAME_PATTERN.matcher(this.model.getName()).matches()) {
                        this.msg = "invalid";
                        return "edit";
                    }
                    this.name = this.model.getName();
                }
            }
            this.modelManager.saveModel(this.model);
            this.msg = "successed";
        }
        return "edit";
    }

    public String generate() throws Exception {
        this.model = this.modelService.getModel(this.name);
        StringWriter sw = new StringWriter();
        ModelCodeGenerater.JAVA.generate(this.model, (Writer)sw);
        this.msg = sw.toString();
        return "generate";
    }

    public Collection<Model> getModels() {
        return this.modelService.getModels();
    }

    public Date getNow() {
        return new Date();
    }

    public List<Field> getParentFields() {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Model m = this.model.getParent(); m != null; m = m.getParent()) {
            list.addAll(m.getFields());
        }
        return list;
    }

    public String getTab() {
        return "model";
    }

    public String remove() throws Exception {
        this.modelManager.removeModel(this.name);
        return "toIndex";
    }

    public String tplEdit() {
        if (this.tplContent != null) {
            this.model.getTemplates().put(this.tplName, this.tplContent);
            this.modelManager.saveModel(this.model);
            this.msg = "successed";
        } else {
            this.tplContent = (String)this.model.getTemplates().get(this.tplName);
        }
        return "tplEdit";
    }

    public String tplList() throws Exception {
        return "tplList";
    }

    public String tplRemove() {
        this.model.getTemplates().remove(this.tplName);
        this.modelManager.saveModel(this.model);
        return "toTplList";
    }

    public String update() {
        this.modelService.reload();
        this.reloadableSessionFactory.reload();
        return "toIndex";
    }
}

