/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class PaperAction
extends BaseModelAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private SysUserService userService;
    private String treeId;
    private String type;
    private String archiveId;
    private String linkField;
    private String dwdm;
    private String itemId;
    private Boolean generic;
    private List<Map<String, Object>> tree;
    private Map docArchive;

    public Boolean getGeneric() {
        if (StringUtils.isNotBlank((String)this.itemId)) {
            Item item = this.dictService.getItem(this.itemId);
            this.generic = Boolean.parseBoolean(item.getParentId());
        } else {
            List items = this.dictService.getItems("hc_" + this.userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
            for (Item item : items) {
                if (!item.getValue().equals(this.dwdm)) continue;
                this.generic = Boolean.parseBoolean(item.getParentId());
                break;
            }
        }
        return this.generic;
    }

    public void setGeneric(Boolean generic) {
        this.generic = generic;
    }

    public void setModelName(String modelName) {
        super.setModelName(Archive.toDocumentModelName((String)modelName));
    }

    public String getItemId() {
        if (StringUtils.isBlank((String)this.itemId)) {
            List items = this.dictService.getItems("hc_" + this.userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
            for (Item item : items) {
                if (!item.getValue().equals(this.dwdm)) continue;
                this.itemId = item.getId();
                break;
            }
        }
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public String getType() {
        return this.type;
    }

    public String getDwdm() {
        return this.dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getPermJson() {
        List operations = this.dictService.getItems("operationPerm");
        HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (!item.getName().equals("view")) continue;
            perm.put(item.getName(), true);
        }
        return JSON.toJSONString(perm);
    }

    public List<Map<String, Object>> getTree() {
        if (this.tree == null) {
            ArrayList<Map> listTree = this.treeService.getAllTree(null, new String[]{"model"});
            if (this.itemId == null) {
                List items = this.dictService.getItems("hc_" + this.userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
                for (Item item : items) {
                    if (!item.getValue().equals(this.dwdm)) continue;
                    this.itemId = item.getId();
                    break;
                }
            }
            if (StringUtils.isBlank((String)this.itemId)) {
                for (Map item : listTree) {
                    this.logger.debug(item.toString());
                    if (!item.get("name").equals("generic")) continue;
                    listTree.remove(item);
                    break;
                }
            } else {
                Item item = this.dictService.getItem(this.itemId);
                ArrayList<Map> newTree = new ArrayList<Map>();
                if (item != null && item.getRemark() != null && StringUtils.isNotBlank((String)item.getRemark().toString())) {
                    String remark = item.getRemark().toString();
                    JSONObject job = JSON.parseObject((String)remark);
                    JSONArray array = job.getJSONArray("items");
                    block2: for (int i = 0; i < array.size(); ++i) {
                        String title = ((JSONObject)array.get(i)).get((Object)"item").toString();
                        JSONArray ops = ((JSONObject)array.get(i)).getJSONArray("op");
                        for (Map map : listTree) {
                            if (!map.get("name").equals(title)) continue;
                            List list = (List)map.get("children");
                            ArrayList<Map> newList = new ArrayList<Map>();
                            for (Map child : list) {
                                for (int j = 0; j < ops.size(); ++j) {
                                    if (!child.get("name").equals(ops.get(j))) continue;
                                    newList.add(child);
                                }
                            }
                            map.put("children", newList);
                            newTree.add(map);
                            continue block2;
                        }
                    }
                    listTree = newTree;
                } else {
                    for (Map tempItem : listTree) {
                        this.logger.debug(tempItem.toString());
                        if (!tempItem.get("name").equals("generic")) continue;
                        listTree.remove(tempItem);
                        break;
                    }
                }
            }
            this.tree = listTree;
        }
        return this.tree;
    }

    public String execute() throws Exception {
        Document doc;
        String currentDwdm = this.getCurrentDwdm();
        boolean hasPermission = false;
        try {
            List items = this.dictService.getItems("hc_" + currentDwdm);
            for (Item item : items) {
                if (!item.getValue().equals(this.dwdm)) continue;
                hasPermission = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!hasPermission) {
            return "none";
        }
        if (StringUtils.isNotEmpty((String)this.modelName)) {
            Resource res = this.resourceService.findChildResource(null, Document.toArchiveModelName((String)this.modelName), new String[]{"model"});
            if (res != null) {
                this.treeId = res.getId();
                if (!this.securityService.isPermitted(this.treeId, "view")) {
                    throw new NoPermissionException(this.modelName);
                }
            } else {
                throw new ModelNotFoundException(this.modelName);
            }
        }
        this.modelService.getModel(this.modelName);
        String id = this.getId();
        if (id != null && (doc = this.archiveService.getDocument(this.modelName, id)) != null) {
            this.type = doc.getArchiveId() == null ? "wlj" : "ylj";
        }
        return "success";
    }

    protected Page<Document> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (StringUtils.isNotEmpty((String)this.archiveId)) {
            if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                List documents = this.entityService.search(Archive.toDocumentModelName((String)this.modelName), Collections.singletonList(Restrictions.eq((String)"archiveId", (Object)this.archiveId)), orders, 0, -1).getItems();
                if (documents.size() > 0) {
                    ((Document)documents.get(0)).setArchive(this.archiveService.getArchive(this.modelName, this.archiveId));
                }
                return new Page(documents);
            }
            return new Page(this.entityService.search(Archive.toDocumentModelName((String)this.modelName), Collections.singletonList(Restrictions.eq((String)"archiveId", (Object)this.archiveId)), orders, 0, -1).getItems());
        }
        if (EnvHolder.isEnable((String)"jiangyin.enable")) {
            Page page = super.searchEntity(criterions, orders);
            for (Document document : page.getItems()) {
                if (StringUtils.isNotBlank((String)document.getArchiveId())) {
                    document.setArchive(this.archiveService.getArchive(this.modelName, document.getArchiveId()));
                }
                document.setHasOriginal(Boolean.valueOf(this.originalService.hasOriginal(document.getId())));
            }
            return page;
        }
        return super.searchEntity(criterions, orders);
    }

    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (this.type == null || !this.type.equals("all")) {
            criterions.add("ylj".equals(this.type) ? Restrictions.isNotNull((String)"archiveId") : Restrictions.isNull((String)"archiveId"));
        }
        return super.createCriterions(criterions);
    }

    protected List<Order> createOrders(ArrayList<Order> orders) {
        List superOrders = super.createOrders(orders);
        if (superOrders.size() > 0) {
            return superOrders;
        }
        if (StringUtils.isNotEmpty((String)this.archiveId)) {
            orders.add(Order.desc((String)"sxh"));
        }
        orders.add(Order.desc((String)"id"));
        return super.createOrders(orders);
    }

    public Map getDocArchive() {
        try {
            if (this.docArchive == null) {
                this.docArchive = JSON.parseObject((String)JSON.toJSONString((Object)this.archiveService.getArchive(this.modelName, this.archiveId), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                this.docArchive.remove("id");
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.toString());
        }
        return this.docArchive;
    }

    public String getLinkField() {
        if (this.linkField == null) {
            try {
                this.linkField = this.archiveService.getDocumentModel(this.modelName).getTemplate("linkField");
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.linkField = "tm";
            }
        }
        return this.linkField;
    }

    private String getCurrentDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }
}

