/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.archive.web.GatewayAction;
import com.opensymphony.xwork2.Action;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class GatewayAction
implements Action {
    @Autowired
    private GatewayService gatewayService;
    @Autowired
    private DictService dictService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private EntityService entityService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    private OriginalService originalService;
    private String data;
    private String id;
    private String modelName;
    private String mlh;
    private Map docShowFields;
    private Map docFields;
    private String state;
    private String field;
    private String value;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getState() {
        if (StringUtils.isBlank((String)this.state)) {
            return "0";
        }
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String execute() throws Exception {
        if (StringUtils.isNotBlank((String)this.data)) {
            Struts2Utils.renderXml((String)this.gatewayService.in(this.data), (String[])new String[0]);
        }
        return null;
    }

    public String update() {
        if (StringUtils.isNotBlank((String)this.data)) {
            Struts2Utils.renderXml((String)this.gatewayService.update(this.data), (String[])new String[0]);
        }
        return null;
    }

    public String preIn() throws Exception {
        if (StringUtils.isNotBlank((String)this.data)) {
            Struts2Utils.renderXml((String)this.gatewayService.preIn(this.data), (String[])new String[0]);
        }
        return null;
    }

    public String preDispose() {
        try {
            this.gatewayService.preDispose(this.modelName, this.id, this.mlh);
            Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        }
        catch (Exception ex) {
            Struts2Utils.renderJson((String)ex.toString(), (String[])new String[0]);
        }
        return null;
    }

    public String cancelDispose() {
        try {
            this.gatewayService.cancelDispose(this.modelName, this.id);
            Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String dispose() {
        try {
            Struts2Utils.renderJson((String)this.gatewayService.dispose(this.modelName, this.id), (String[])new String[0]);
        }
        catch (Exception ex) {
            Struts2Utils.renderJson((String)ex.toString(), (String[])new String[0]);
        }
        return null;
    }

    public String edit() {
        return "edit";
    }

    public String originalInfo() {
        return "originalInfo";
    }

    public String inBox() {
        return "inBox";
    }

    public String out() {
        if (StringUtils.isNotBlank((String)this.id) && StringUtils.isNotBlank((String)this.modelName)) {
            Struts2Utils.renderXml((String)this.gatewayService.out(this.id, this.modelName), (String[])new String[0]);
        } else if (StringUtils.isNotBlank((String)this.id)) {
            Struts2Utils.renderXml((String)this.gatewayService.out(this.id), (String[])new String[0]);
        }
        return null;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getId() {
        return this.id;
    }

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }

    public Map getDocShowFields() {
        if (this.docShowFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName + "_jn");
                this.docShowFields = (Map)JSON.parseObject((String)doc.getTemplate("showFields"), LinkedHashMap.class);
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docShowFields = (Map)JSON.parseObject((String)this.getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return this.docShowFields;
    }

    public Map getDocFields() {
        if (this.docFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docFields = doc.getInheritfieldsMap();
            }
            catch (ModelNotFoundException modelNotFoundException) {
                // empty catch block
            }
        }
        return this.docFields;
    }

    public String getDocColumns() {
        if (this.docShowFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docShowFields = (Map)JSON.parseObject((String)doc.getTemplate("showFields"), LinkedHashMap.class);
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docShowFields = (Map)JSON.parseObject((String)this.getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        Map fileds = this.getDocFields();
        StringBuilder sb = new StringBuilder("{\"result\":[");
        Iterator iter = this.docShowFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            StringBuilder content = new StringBuilder("{\"fieldName\":");
            String key = entry.getKey().toString();
            content.append("\"" + key + "\",\"title\":\"" + ((Field)fileds.get(key)).getTitle() + "\",");
            Map val = (Map)entry.getValue();
            Iterator it = val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = it.next();
                String keyV = en.getKey().toString();
                String value = en.getValue().toString();
                content.append("\"" + keyV + "\":\"" + value + "\"");
                if (!it.hasNext()) continue;
                content.append(",");
            }
            if (iter.hasNext()) {
                content.append("},");
                sb.append(content.toString());
                continue;
            }
            content.append("}");
            sb.append(content.toString() + "]}");
        }
        return sb.toString();
    }

    private String getEntityTemplate(String name) {
        return this.getEntityModel().getTemplate(name);
    }

    private Model getEntityModel() {
        return this.modelService.getModel(this.modelName);
    }

    public String getList() {
        Collection models = this.getModels();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Model model : models) {
            if (!"Archive".equals(model.getParentName())) continue;
            map.put(model.getTitle(), model.getName());
        }
        return JSON.toJSONString(map);
    }

    public ArrayList<String> getKeys() {
        Collection models = this.getModels();
        ArrayList<String> keys = new ArrayList<String>();
        for (Model model : models) {
            if (!"Archive".equals(model.getParentName())) continue;
            keys.add(model.getTitle());
        }
        return keys;
    }

    public Collection<Model> getModels() {
        return this.modelService.getModels();
    }

    public String updateDoc() {
        String mssg = "";
        if (StringUtils.isBlank((String)this.field) || StringUtils.isBlank((String)this.modelName) || StringUtils.isBlank((String)this.value) || StringUtils.isBlank((String)this.id)) {
            mssg = "\u83b7\u53d6\u4fee\u6539\u914d\u7f6e\u5f02\u5e38";
        }
        try {
            Document document = (Document)this.entityService.load(Archive.toDocumentModelName((String)this.modelName), this.id);
            Model model = this.archiveService.getDocumentModel(this.modelName);
            Field.Type type = model.getInheritField(this.field).getType();
            switch (1.$SwitchMap$com$gtis$archive$core$Field$Type[type.ordinal()]) {
                case 1: {
                    PropertyUtils.setProperty((Object)document, (String)this.field, (Object)this.value);
                    break;
                }
                case 2: {
                    PropertyUtils.setProperty((Object)document, (String)this.field, (Object)Integer.valueOf(this.value));
                    break;
                }
                case 3: {
                    PropertyUtils.setProperty((Object)document, (String)this.field, (Object)Float.valueOf(this.value));
                    break;
                }
                case 4: {
                    if (StringUtils.isNotBlank((String)this.value)) {
                        PropertyUtils.setProperty((Object)document, (String)this.field, (Object)Constants.DATE_FORMAT.parse(this.value));
                        break;
                    }
                    PropertyUtils.setProperty((Object)document, (String)this.field, null);
                    break;
                }
                case 5: {
                    if (StringUtils.isNotBlank((String)this.value)) {
                        Date date = Constants.DATE_FORMAT.parse(this.value);
                        PropertyUtils.setProperty((Object)document, (String)this.field, (Object)new Timestamp(date.getTime()));
                        break;
                    }
                    PropertyUtils.setProperty((Object)document, (String)this.field, null);
                    break;
                }
                case 6: {
                    PropertyUtils.setProperty((Object)document, (String)this.field, (Object)Boolean.valueOf(this.value));
                }
            }
            this.entityService.save((Object)document);
            mssg = "success";
        }
        catch (Exception ex) {
            mssg = ex.toString();
        }
        Struts2Utils.renderJson((String)mssg, (String[])new String[0]);
        return null;
    }

    public String hasOriginal() {
        if (StringUtils.isBlank((String)this.id)) {
            Struts2Utils.renderJson((Object)false, (String[])new String[0]);
            return null;
        }
        boolean hasOriginal = this.originalService.hasOriginal(this.id);
        Struts2Utils.renderJson((Object)hasOriginal, (String[])new String[0]);
        return null;
    }
}

