/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

public class BorrowAction
extends BaseModelAction<Archive> {
    @Autowired
    private LoanService loanService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private SysUserService userService;
    private String archiveType;
    private String idString;
    private String id;

    public String getArchiveType() {
        return this.archiveType;
    }

    public void setArchiveType(String archiveType) {
        this.archiveType = archiveType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public List<LoanCart> getLoanCar() {
        ArrayList<LoanCart> entities = new ArrayList<LoanCart>();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (!"".equals(this.idString)) {
            Date date = new Date();
            for (String id : this.idString.split(",")) {
                String tmValue;
                String loanTm;
                LoanCart lc = new LoanCart();
                lc.setArchiveId(id.trim());
                lc.setUserId(userInfo.getId());
                lc.setArchiveType(this.archiveType);
                lc.setInDate(date);
                lc.setDwdm(this.getDwdm());
                if (this.archiveType.indexOf("_jn") != -1) {
                    Document document = (Document)this.entityService.load(this.archiveType, id.trim());
                    lc.setSxh(document.getSxh());
                    if (document.getArchive() != null || document.getArchiveId() != null) {
                        Archive archive;
                        Archive archive2 = archive = document.getArchive() == null ? (Archive)this.entityService.load(Archive.class, document.getArchiveId()) : document.getArchive();
                        if (archive != null) {
                            lc.setAjh(String.valueOf(archive.getAjh()));
                            lc.setMlh(archive.getMlh());
                            lc.setDh(archive.getDh());
                        }
                    }
                    loanTm = this.getDocLoanTm(this.archiveType);
                    tmValue = "";
                    try {
                        tmValue = PropertyUtils.getProperty((Object)document, (String)loanTm).toString();
                    }
                    catch (Exception ex) {
                        tmValue = document.getTm();
                    }
                    lc.setTm(tmValue);
                } else if (!(this.archiveType.equals("ythsw") || this.archiveType.equals("ythfw") || this.archiveType.equals("ythnw"))) {
                    Archive arvhice = (Archive)this.entityService.load(this.archiveType, id.trim());
                    loanTm = this.getLoanTm(this.archiveType);
                    tmValue = "";
                    try {
                        tmValue = PropertyUtils.getProperty((Object)arvhice, (String)loanTm).toString();
                    }
                    catch (Exception ex) {
                        tmValue = arvhice.getTm();
                    }
                    lc.setTm(tmValue);
                    lc.setMlh(arvhice.getMlh());
                    lc.setAjh(arvhice.getAjh().toString());
                    lc.setDh(arvhice.getDh());
                }
                entities.add(lc);
            }
        }
        return entities;
    }

    public String borrows() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List criterions = this.createCriterions(new ArrayList());
        if (userInfo.isAdmin()) {
            this.renderJson((Object)this.loanService.getPages(this.start, this.limit, criterions));
        } else {
            SimpleExpression cr = Restrictions.eq((String)"userId", (Object)userInfo.getId());
            criterions.add(cr);
            this.renderJson((Object)this.loanService.getPages(this.start, this.limit, criterions));
        }
        return null;
    }

    private String getLoanTm(String modelName) {
        String tm = "tm";
        try {
            tm = this.archiveService.getArchiveModel(modelName).getTemplate("loanField");
        }
        catch (Exception ex) {
            tm = "tm";
        }
        return tm;
    }

    private String getDocLoanTm(String modelName) {
        String tm = "tm";
        try {
            tm = this.archiveService.getDocumentModel(modelName).getTemplate("loanField");
        }
        catch (Exception ex) {
            tm = "tm";
        }
        return tm;
    }

    public String addLoanCar() {
        for (LoanCart loancar : this.getLoanCar()) {
            this.loanService.addToCart((Object)loancar);
        }
        Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        return null;
    }

    public String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    public String remove() {
        this.loanService.removeFromCart(this.entityService.load(LoanCart.class, this.id));
        Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        return null;
    }

    public Model getEntityModel() {
        return this.modelService.getModel("LoanCart");
    }
}

