/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtTreeServiceImpl
implements ExtTreeService {
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;

    public List<Map<String, Object>> getTree(String resourceId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List ress = this.resourceService.getChildrenResource(resourceId, new String[0]);
        for (Resource res : ress) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List children = this.getTree(res.getId());
            if (!this.securityService.isPermitted(res.getId(), "view") && children.size() <= 0) continue;
            map.put("id", res.getId());
            map.put("name", res.getName());
            map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
            map.put("content", res.getContent());
            if ("checkbox".equals(EnvHolder.getAppEnv().get((Object)"classifyViewMode"))) {
                map.put("checked", false);
            }
            if (children.size() > 0) {
                map.put("children", children);
                map.put("expanded", true);
                map.put("iconCls", "node");
            } else {
                map.put("leaf", true);
                map.put("iconCls", "node left");
            }
            list.add(map);
        }
        return list;
    }

    public List<Map<String, Object>> getALLTree(String resourceId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List ress = this.resourceService.getChildrenResource(resourceId, new String[0]);
        for (Resource res : ress) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List children = this.getTree(res.getId());
            map.put("id", res.getId());
            map.put("name", res.getName());
            map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
            map.put("content", res.getContent());
            if ("checkbox".equals(EnvHolder.getAppEnv().get((Object)"classifyViewMode"))) {
                map.put("checked", false);
            }
            if (children.size() > 0) {
                map.put("children", children);
                map.put("expanded", true);
                map.put("iconCls", "node");
            } else {
                map.put("leaf", true);
                map.put("iconCls", "node left");
            }
            list.add(map);
        }
        return list;
    }

    public List<Map<String, Object>> getTree(String resourceId, String ... name) {
        return this.getTree(this.resourceService.getResource(resourceId, name).getId());
    }

    public List<Map<String, Object>> getAllTree(String resourceId, String ... name) {
        return this.getALLTree(this.resourceService.getResource(resourceId, name).getId());
    }

    public List<Map<String, Object>> getTree2(String resourceId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List ress = this.resourceService.getChildrenResource(resourceId, new String[0]);
        for (Resource res : ress) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List children = this.getTree2(res.getId());
            if (!this.securityService.isPermitted(res.getId(), "view") && children.size() <= 0) continue;
            map.put("id", res.getId());
            map.put("name", res.getName());
            map.put("text", res.getTitle() == null ? res.getName() : res.getTitle());
            map.put("content", res.getContent());
            if (children.size() > 0) {
                map.put("children", children);
                map.put("expanded", true);
                map.put("iconCls", "node");
            } else {
                map.put("leaf", true);
                map.put("iconCls", "node left");
            }
            list.add(map);
        }
        return list;
    }
}

