/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.support.hibernate;

import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.support.hibernate.ReloadableSessionFactory;
import javax.persistence.Entity;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean;

public class ReloadableLocalSessionFactoryBean
extends AnnotationSessionFactoryBean {
    private ModelService modelService;

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        super.setBeanClassLoader(this.modelService.getClassLoader());
    }

    public SessionFactory rebuildSessionFactory() throws Exception {
        return this.buildSessionFactory();
    }

    protected void postProcessMappings(Configuration config) throws HibernateException {
        super.postProcessMappings(config);
        for (Class clazz : this.modelService.getClasses()) {
            if (clazz.getAnnotation(Entity.class) == null) continue;
            config.addAnnotatedClass(clazz);
        }
    }

    protected SessionFactory wrapSessionFactoryIfNecessary(SessionFactory rawSf) {
        return new ReloadableSessionFactory(rawSf, this);
    }
}

