/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.impl;

import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelChangeEvent;
import com.gtis.archive.core.ModelManager;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.core.environment.EnvironmentConverter;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.support.xstream.CDATASupportDom4JDriver;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.io.Resource;

public class ModelManagerImpl
implements ModelManager,
ApplicationEventPublisherAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private XStream sm;
    private Resource location;
    private Map<String, Model> models;
    private ApplicationEventPublisher publisher;

    public void setLocation(Resource modelslocation) {
        this.location = modelslocation;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public Model getModel(String modelName) {
        Model model = (Model)this.models.get(modelName);
        if (model == null) {
            throw new ModelNotFoundException(modelName);
        }
        return model;
    }

    public Model getModelAllowNull(String modelName) {
        Model model = (Model)this.models.get(modelName);
        return model;
    }

    public Collection<Model> getModels() {
        return this.models.values();
    }

    public void removeModel(String modelName) {
        this.models.remove(modelName);
        this.save();
    }

    public void saveModel(Model model) {
        this.models.put(model.getName(), model);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        this.models = new LinkedHashMap();
        this.sm = new XStream((HierarchicalStreamDriver)new CDATASupportDom4JDriver());
        this.sm.alias("environment", Environment.class);
        this.sm.alias("model", Model.class);
        this.sm.alias("field", Field.class);
        this.sm.autodetectAnnotations(true);
        this.sm.registerConverter((Converter)new EnvironmentConverter(this.sm.getMapper()));
        InputStream is = null;
        try {
            is = this.location.getInputStream();
            List list = (List)this.sm.fromXML(is);
            for (Model model : list) {
                this.models.put(model.getName(), model);
            }
        }
        catch (Exception e) {
            this.logger.error("load custom models file [" + this.location + "],error:{}", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
        for (Model model : this.models.values()) {
            if (model.getEnv() == null) {
                model.setEnv(new Environment());
            }
            if (model.getTemplates() == null) {
                model.setTemplates(new LinkedHashMap());
            }
            if (model.getFields() == null) {
                model.setFields(new LinkedHashSet());
            }
            if (model.getParentName() != null && this.models.containsKey(model.getParentName()) && !model.getName().equals(model.getParentName())) {
                model.setParent((Model)this.models.get(model.getParentName()));
            }
            if (model.getParent() != null) {
                model.getEnv().setParent(model.getParent().getEnv());
                continue;
            }
            model.getEnv().setParent(EnvHolder.getAppEnv());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void save() {
        FileOutputStream os = null;
        ArrayList<Model> list = new ArrayList<Model>();
        for (Model model : this.models.values()) {
            list.add(model);
        }
        try {
            os = new FileOutputStream(this.location.getFile());
            this.sm.toXML(list, (OutputStream)os);
        }
        catch (IOException e) {
            this.logger.error("store models file [" + list + "],error:{}", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
        this.publisher.publishEvent((ApplicationEvent)new ModelChangeEvent((Object)this.models));
    }
}

