package com.gtis.archive.web.admin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.archive.Constants;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.ExtTreeService;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.json.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-1
 */
@Results({@Result(name = "toIndex", location = "item.action?dictName=${dictName}", type = "redirect")})
public class ItemAction extends ActionSupport {
    private static final long serialVersionUID = 3736616155649415355L;
    @Autowired
    private DictService dictService;
    @Autowired
    private ExtTreeService treeService;

    private String dictName;
    private String id;
    private Item item;
    private List<Item> items;
    private String msg;
    private String treeJson;    //
    private List<Item> operations; //定义的操作项

    public String getDictName() {
        return dictName;
    }

    public void setDictName(String dictName) {
        this.dictName = dictName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Item getItem() {
        return item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public String getMsg() {
        return msg;
    }

    @Override
    public String execute() throws Exception {
        return super.execute();
    }

    public String edit() throws Exception {
        if (item == null) {
            if (StringUtils.isNotBlank(id)) {
                item = dictService.getItem(id);
            } else {
                item = new Item();
            }
        } else {
            if (StringUtils.isBlank(item.getName()))
                return "edit";
            item.setDictId(dictService.getDict(dictName).getId());
            dictService.saveItem(item);
            msg = "successed";
        }
        return "edit";
    }

    public List<Item> getItems() {
        return dictService.getItems(dictName);
    }

    public String getTab() {
        return "dict";
    }

    public String remove() throws Exception {
        dictService.removeItem(id);
        return "toIndex";
    }

    /**
     * 判断是否为互查的字典项
     * @return
     */
    public boolean getIsCheck(){
        if(dictName.contains(Constants.HUCHA_PREFIX))
            return true;
        return false;
    }

    /**
     * 获取tree json
     * @return
     */
    public String getTreeJson() throws Exception{
        if(StringUtils.isBlank(treeJson)){
            if(operations==null)
                operations=dictService.getItems(Constants.HUCHA_PERM); //互查操作权限字典
            List<Map<String, Object>> tree = rewrite(treeService.getTree(null, Constants.MODEL_ROOT));
            treeJson = JSONUtil.serialize(tree);
        }
        return treeJson;
    }

    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                if(map.containsKey("expanded")){
                    map.put("expanded",false);
                }
                rewrite((List<Map<String, Object>>) map.get("children"));
                String id = (String) map.get("id");
                List<Map<String, Object>> opts = new ArrayList<Map<String, Object>>();
                boolean isParent=map.containsKey("expanded");
                for (Item item : operations) {
                    if(!isParent){
                        Map<String, Object> op = new HashMap<String, Object>();
                        op.put("name", id + "_" + item.getName());
                        op.put("text", item.getValue());
                        op.put("checked", checkValue(id,item));
                        opts.add(op);
                    }
                }
                map.put("data", opts);
            }
        }
        return tree;
    }

    /**
     *
     * @return
     */
    private boolean checkValue(String id,Item perm){
        if(item!=null&&item.getRemark()!=null){
            String remark=item.getRemark().toString();
            if(StringUtils.isBlank(remark))
                return false;
            JSONObject job= JSON.parseObject(remark);
            JSONArray array=job.getJSONArray("items");
            for (int i=0;i<array.size();i++){
                String permId=((JSONObject)array.get(i)).get("id").toString();
                String permName=((JSONObject)array.get(i)).get("perm").toString();
                if(id.equals(permId)&&perm.getName().equals(permName))
                    return true;
            }
        }
        return false;
    }
}
