package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.util.CriteriaCallback;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author xunianfeng
 * @version V1.0, 13-8-19
 */
public class HomeAction extends BaseModelAction {
    @Autowired
    private ExtTreeService treeService;

    @Autowired
    private SysUserService userService;
//    @Override
//    public String execute() throws Exception {
//        return SUCCESS;  //To change body of implemented methods use File | Settings | File Templates.
//    }

    public List<Map<String, Object>> getTree() {
        return treeService.getTree(null, Constants.MODEL_ROOT);
    }

    /**
     * 获取当前用户的欠当
     * @return
     */
    public String exceedLoan(){
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<Criterion> criterions=new ArrayList<Criterion>();
        criterions.add(Restrictions.sqlRestriction("jyrq+jyqx<?", new Date(), StandardBasicTypes.DATE));
        criterions.add(Restrictions.eq("state", 0));

        if(SessionUtil.getCurrentUser().isAdmin()){
            Struts2Utils.renderJson(0);
            return null;
        } else if(EnvHolder.isEnable(Switch.DWDM)){
            criterions.add(Restrictions.or(Restrictions.isNull("dwdm"),Restrictions.eq("dwdm",getDwdm())));
        }
        criterions.add(Restrictions.or(Restrictions.isNull("userId"),Restrictions.eq("userId",userInfo.getId())));
        int count=entityService.search(new CriteriaCallback(){
            public Criteria create(Session session) {
                return session.createCriteria(Loan.class).createAlias("archive", "arc");
            }
        },criterions,null,0,-1).getTotalCount();
        Struts2Utils.renderJson(count);
        return null;
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }
}
