package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-30
 */
public class GatewayAction implements Action {

    @Autowired
    private GatewayService gatewayService;

    @Autowired
    private DictService dictService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private EntityService entityService;

    @Autowired
    protected ModelService modelService;

    @Autowired
    private OriginalService originalService;

    private String data;

    private String id;

    private String modelName;

    private String mlh;  //目录号

    private Map docShowFields;
    private Map docFields;

    private String state;//是否为可以编辑目录号案卷号等，2为可以编辑

    private String field;//更新的字段名

    private String value;//更新的字段值

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getState() {
        if (StringUtils.isBlank(state))
            return "0";
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    /**
     * 默认插入档案
     *
     * @return
     * @throws Exception
     */
    public String execute() throws Exception {
        if (StringUtils.isNotBlank(data))
            Struts2Utils.renderXml(gatewayService.in(data));
        return null;
    }

    /**
     * 更新档案
     *
     * @return
     */
    public String update() {
        if (StringUtils.isNotBlank(data)) {
            Struts2Utils.renderXml(gatewayService.update(data));
        }
        return null;
    }

    /**
     * @return
     * @throws Exception
     */
    public String preIn() throws Exception {
        if (StringUtils.isNotBlank(data))
            Struts2Utils.renderXml(gatewayService.preIn(data));
        return null;
    }

    /**
     * 预处理
     *
     * @return
     */
    public String preDispose() {
        try {
//            ActionContext.getContext().get("")
            gatewayService.preDispose(modelName, id, mlh);
            Struts2Utils.renderJson("success");
        } catch (Exception ex) {
            Struts2Utils.renderJson(ex.toString());
        }
        return null;
    }

    /**
     * 撤销预处理
     *
     * @return
     */
    public String cancelDispose() {
        try {
            gatewayService.cancelDispose(modelName, id);
            Struts2Utils.renderJson("success");
        } catch (Exception ex) {

        }
        return null;
    }


    /**
     * 打印完交接单在档案列表中显示
     *
     * @return
     */
    public String dispose() {
        try {
            Struts2Utils.renderJson(gatewayService.dispose(modelName, id));
        } catch (Exception ex) {
            Struts2Utils.renderJson(ex.toString());
        }
        return null;
    }

    public String edit() {
        return "edit";
    }

    public String originalInfo() {
        return "originalInfo";
    }

    public String inBox() {
        return "inBox";
    }

    public String out() {
        if (StringUtils.isNotBlank(id) && StringUtils.isNotBlank(modelName))
            Struts2Utils.renderXml(gatewayService.out(id, modelName));
        else if (StringUtils.isNotBlank(id))
            Struts2Utils.renderXml(gatewayService.out(id));
        return null;
    }


    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public String getId() {
        return id;
    }

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }


    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName + "_jn");
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
            }
        }
        return docFields;
    }


    public String getDocColumns() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }

        Map<String, Field> fileds = getDocFields();
        StringBuilder sb = new StringBuilder("{\"result\":[");
        Iterator iter = docShowFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            StringBuilder content = new StringBuilder("{\"fieldName\":");
            String key = entry.getKey().toString();
            content.append("\"" + key + "\",\"title\":\"" + fileds.get(key).getTitle() + "\",");
            Map val = (Map) entry.getValue();
            Iterator it = val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = (Map.Entry) it.next();
                String keyV = en.getKey().toString();
                String value = en.getValue().toString();
                content.append("\"" + keyV + "\":\"" + value + "\"");
                if (it.hasNext()) {
                    content.append(",");
                }
            }
            if (iter.hasNext()) {
                content.append("},");
                sb.append(content.toString());
            } else {
                content.append("}");
                sb.append(content.toString() + "]}");
            }
        }
        return sb.toString();
    }

    private String getEntityTemplate(String name) {
        return getEntityModel().getTemplate(name);
    }

    private Model getEntityModel() {
        return modelService.getModel(modelName);
    }


    public String getList() {
        Collection<Model> models = getModels();
        Map<String, String> map = new HashMap<String, String>();
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            Model model = (Model) iterator.next();
            if ("Archive".equals(model.getParentName()))
                map.put(model.getTitle(), model.getName());
        }
        return JSON.toJSONString(map);
    }

    public ArrayList<String> getKeys() {
        Collection<Model> models = getModels();
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            Model model = (Model) iterator.next();
            if ("Archive".equals(model.getParentName()))
                keys.add(model.getTitle());
        }
        return keys;
    }


    public Collection<Model> getModels() {
        return modelService.getModels();
    }

    /**
     * 更新卷内的某个字段
     *
     * @return
     */
    public String updateDoc() {
        String mssg = "";
        if (StringUtils.isBlank(field) || StringUtils.isBlank(modelName)
                || StringUtils.isBlank(value) || StringUtils.isBlank(id))
            mssg = "获取修改配置异常";
        try {
            Document document = entityService.load(Archive.toDocumentModelName(modelName), id);
            Model model = archiveService.getDocumentModel(modelName);//根据类型转换value
            Field.Type type = model.getInheritField(field).getType();
            switch (type) {
                case TEXT:
                    PropertyUtils.setProperty(document, field, value);
                    break;
                case NUMBER:
                    PropertyUtils.setProperty(document, field, Integer.valueOf(value));
                    break;
                case FLOAT:
                    PropertyUtils.setProperty(document, field, Float.valueOf(value));
                    break;
                case DATE:
                    if (StringUtils.isNotBlank(value))
                        PropertyUtils.setProperty(document, field, Constants.DATE_FORMAT.parse(value));
                    else
                        PropertyUtils.setProperty(document, field, null);
                    break;
                case DATETIME:
                    if (StringUtils.isNotBlank(value)) {
                        Date date = Constants.DATE_FORMAT.parse(value);
                        PropertyUtils.setProperty(document, field, new Timestamp(date.getTime()));
                    } else {
                        PropertyUtils.setProperty(document, field, null);
                    }

                    break;
                case BOOLEAN:
                    PropertyUtils.setProperty(document, field, Boolean.valueOf(value));
                    break;
            }
            entityService.save(document);
            mssg = "success";
        } catch (Exception ex) {
            mssg = ex.toString();
        }
        Struts2Utils.renderJson(mssg);
        return null;
    }

    /**
     * 是否存在原文
     * @return
     */
    public String hasOriginal(){
        if(StringUtils.isBlank(id)){
            Struts2Utils.renderJson(false);
            return null;
        }
        boolean hasOriginal = originalService.hasOriginal(id);
        Struts2Utils.renderJson(hasOriginal);
        return null;
    }

}
