package com.gtis.archive.service.impl;

import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.PermissionService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashSet;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">Administrator</a>
 * @version V1.0, 2010-12-8
 */
public class SecurityServiceImpl implements SecurityService {
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private PermissionService permissionService;

    public boolean isPermitted(String permissionString) {
        String[] arr = StringUtils.split(permissionString, ":");
        if (arr.length < 2)
            return false;
        String[] names = StringUtils.split(arr[0], ".");
        String[] operations = StringUtils.split(arr[0], ",");
        if (names.length == 0 || operations.length == 0)
            return false;
        Resource res = resourceService.getResource(null, names);
        for (String op : operations) {
            if (!permissionService.hasPermission(res.getId(), op))
                return false;
        }
        return true;
    }

    public boolean isPermitted(String resourceId, String operation) {
        while (resourceId != null) {
            if (permissionService.hasPermission(resourceId, operation)) {
                return true;
            } else {
                Resource res = resourceService.getResource(resourceId);
                if (res == null) {
                    return false;
                }
                resourceId = res.getParentId();
            }
        }
        return false;
    }

    public Set<String> getReadableRoleIds(String resourceId) {
        Set<String> set = new HashSet<String>();
        while (resourceId != null) {
            set.addAll(permissionService.getReadableRoleIds(resourceId));
            resourceId = resourceService.getResource(resourceId).getParentId();
        }
        return set;
    }
}
