package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * 案卷号范围
 * <p/>
 * Generated 2010-10-13 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_ajh_range")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class AjhRange {
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 模型名称
     */
    @Column(length = 100, nullable = false)
    private String modelName;

    /**
     * 单位代码
     */
    @Column(length=100)
    private String dwdm;

    /**
     * 年份
     */
    @Column(length = 10)
    private String year;

    /**
     * 目录号
     */
    @Column(length = 100, nullable = false)
    private String mlh;

    /**
     * 最小值
     */
    @Column(nullable = false)
    private int minValue;

    /**
     * 最大值
     */
    @Column
    private Integer maxValue;

    /**
     * 当前值
     */
    @Column(nullable = false)
    private int currentValue;

    /**
     * 顺序号
     */
    @Column
    private Integer orderNumber;

    /**
     * 保管期限
     */
    @Column
    private String bgqx;

    public int getCurrentValue() {
        return currentValue;
    }

    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public Integer getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    public int getNextValue() {
        return currentValue + 1;
    }

    public int getRemainCount() {
        if (maxValue == null)
            return -1;
        if (maxValue <= currentValue)
            return 0;
        else
            return maxValue - currentValue;
    }

    public boolean hasExhausted() {
        return maxValue != null && maxValue <= currentValue;
    }

    public void increaseCurrentValue() {
        currentValue++;
    }

    public String getBgqx() {
        return bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }
}