package com.gtis.archive.core.support.spring;

import com.gtis.archive.core.AppPropsManager;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.environment.Environment;
import com.gtis.config.AppConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

import javax.servlet.ServletContext;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-5
 */
public class EnvHolderConfigurer implements InitializingBean, ServletContextAware {
    private AppPropsManager appPropsService;
    private String webroot="./";

    @SuppressWarnings("unchecked")
    public void afterPropertiesSet() throws Exception {
        Environment env = EnvHolder.getSysProps();
        Map props = AppConfig.getProperties();
        props.put("web.root", webroot);
        if (props.size() > 0) {
            env = new Environment(props, env);
        }
        env = new Environment(appPropsService.getAppProps(), env);
        EnvHolder.setAppEnv(env);
    }

    public Environment getAppEnv() {
        return EnvHolder.getAppEnv();
    }

    public void setAppEnvService(AppPropsManager appPropsService) {
        this.appPropsService = appPropsService;
    }

    public void setServletContext(ServletContext servletContext) {
        webroot = servletContext.getRealPath("/");
    }
}
