package com.gtis.archive.core.support.hibernate;

import com.gtis.archive.core.ModelService;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean;

import javax.persistence.Entity;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-7-29
 */
public class ReloadableLocalSessionFactoryBean extends AnnotationSessionFactoryBean {
    private ModelService modelService;

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        super.setBeanClassLoader(modelService.getClassLoader());
    }

    public SessionFactory rebuildSessionFactory() throws Exception {
        return buildSessionFactory();
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void postProcessMappings(Configuration config) throws HibernateException {
        super.postProcessMappings(config);
        for (Class clazz : modelService.getClasses()) {
            if (clazz.getAnnotation(Entity.class) != null) {
                config.addAnnotatedClass(clazz);
            }
        }
    }

    @Override
    protected SessionFactory wrapSessionFactoryIfNecessary(SessionFactory rawSf) {
        return new ReloadableSessionFactory(rawSf, this);
    }
}
