package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Material;
import com.gtis.archive.service.MaterialService;
import com.gtis.web.SessionUtil;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

/**
 * 收件单材料action
 * Created by zhayuwen on 2015/12/9.
 */
public class MaterialAction extends BaseModelAction<Material> {
    @Autowired
    private MaterialService materialService;

    /**
     * 起始页
     */
    private int start;

    /**
     * 分页大小
     */
    private int limit;

    /**
     * 交件单材料的主键id
     */
    private String mId;

    /**
     * 查询条件
     */
    private String condition;

    /**
     * 退回信息
     */
    private String info;

    /**
     * 退回人
     */
    private String thr;

    /**
     * 交接单号
     */
    private String jjdhs;

    /**
     *  主键id
     */
    private String id;

    public int getStart() {
        return start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getLimit() {
        return limit;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getmId() {
        return mId;
    }

    public void setMId(String mId) {
        this.mId = mId;
    }

    public String getCondition() {
        return condition;
    }

    public void setmId(String mId) {
        this.mId = mId;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getThr() {
        return thr;
    }

    public void setThr(String thr) {
        this.thr = thr;
    }

    public String getJjdhs() {
        return jjdhs;
    }

    public void setJjdhs(String jjdhs) {
        this.jjdhs = jjdhs;
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String execute(){
        return "list";
    }

    /**
     * 获取交件单信息
     */
    public void materialList(){
        Map conditions = JSON.parseObject(condition, Map.class);
        renderJson(materialService.searchMaterial(conditions, start, limit));
    }

    /**
     * 获取关联交件单的档案信息
     */
    public void materialArchiveList(){
        Map conditions = JSON.parseObject(condition, Map.class);
        renderJson(materialService.getMaterialArchiveByMaterialId(conditions, mId, start, limit));
    }

    /**
     * 拒绝接收
     */
    public void refuseMateria(){
        renderJson(materialService.refuseMateria(mId, info, thr, jjdhs));
    }

    /**
     * 确认收件单归档
     */
    public void receviceMateria(){
        renderJson(materialService.receviceMateria(mId, id, SessionUtil.getCurrentUserId()));
    }

    /**
     * 获取分类信息
     */
    public void getModelNames(){
        renderJson(materialService.getMaterilType(id));
    }
}
