package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.DailysService;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zhayw on 2015/5/6.
 */
public class DailysAction extends BaseModelAction<Object> {

    @Autowired
    private ArchiveService archiveService ;

    @Autowired
    private DailysService dailysService;

    private String type;

    private String tplName;

    private String linkField;

    private String ids;

    private String modelNames;

    private String year;

    private String exportName;

    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getArchiveModel(modelName).getTemplate("linkField");
            }catch (Exception ex){
                linkField="tm";
            }
        }
        return linkField;
    }


    public String execute(){
        return Action.SUCCESS;
    }

    public String tpl() {
        try {
            if(tplName.indexOf("list")>-1){
                try{
                    renderModelTemplate(tplName);
                }catch(TemplateNotFoundException e){
                    renderModelTemplate("Daily-list");
                }
            }else{
                renderModelTemplate(tplName);
            }
        } catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    /**
     * 删除日常管理数据
     * @return
     */
    public void removeDailys(){
        if(ids==null)
            return ;

        String[] loanIds = ids.split(",");
        entityService.remove(modelName,loanIds);
        return ;
    }

    /**
     * 获取指定模型的档案记录
     */
    public void getArchiveRecords() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {

        List<Map> models = (List) JSON.parseArray(modelNames);
        Map result = new HashMap();     //存储最终的统计结果

        for(Map item : models){
            List<Criterion> criterions = new ArrayList<Criterion>();
            List<Order> orders = new ArrayList<Order>();
            String modelName = "";
            Object key = item.keySet().toArray()[0];

            criterions.add(Restrictions.eq("nd", year));

            int xj = 0, yj = 0, cq = 0, dq = 0;
            List<String> names = (List)((Map)item.get(key.toString())).get("names");
            for(String name : names){
                List<Object> archives = archiveService.searchArchiveList(name,criterions,orders, -1, -1);
                xj+= archives.size();
                for(Object obj : archives){
                    Object bgqx = PropertyUtils.getProperty(obj,"bgqx");
                    if(bgqx!=null){
                        if("zhl".equalsIgnoreCase(key.toString())){ //综合类包含2001年之前的文书档案和综合档案
                            Object nd = PropertyUtils.getProperty(obj,"nd");

                            if(nd!=null && nd.toString().compareTo("2001")<=0){
                                if("永久".equals(bgqx.toString())){
                                    yj++;
                                }else if("长期".equals(bgqx.toString())){
                                    cq++;
                                }else{
                                    dq++;
                                }
                            }
                        }else if("Wdyth".equalsIgnoreCase(key.toString())){
                            Object nd = PropertyUtils.getProperty(obj,"nd");
                            if(nd!=null && nd.toString().compareTo("2002")>=0) {
                                if ("永久".equals(bgqx.toString())) {
                                    yj++;
                                } else if ("长期".equals(bgqx.toString()) || "10年".equals(bgqx.toString())) {
                                    cq++;
                                } else {
                                    dq++;
                                }
                            }
                        }else if("Jhcw".equalsIgnoreCase(key.toString())){
                            if("永久".equals(bgqx.toString())){
                                yj++;
                            }else if("10年".equals(bgqx.toString()) || "30年".equals(bgqx.toString())){
//                                Object nd = PropertyUtils.getProperty(obj,"nd");
                                dq++;  //定期
                            }
                        }else if("永久".equals(bgqx.toString())){
                            yj++;
                        }else if("长期".equals(bgqx.toString())){
                            cq++;
                        }else if("短期".equals(bgqx.toString())){
                            dq++;
                        }
                    }
                }
            }

            Map map = new HashMap();
            map.put("xj",cq+yj+dq);
            map.put("cq", cq);
            map.put("yj",yj);
            map.put("dq",dq);

            result.put(key.toString(),map);
        }

        renderJson(result);
    }

    /**
     *
     */
    public String exportExcel() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=" + modelName + "-export.xls");
        return dailysService.renderExcel(exportName,modelName,ids.split(","));
    }


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTplName() {
        return tplName;
    }

    public void setTplName(String tplName) {
        this.tplName = tplName;
    }

    public int getLimit() {
        return limit;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public String getModelNames() {
        return modelNames;
    }

    public void setModelNames(String modelNames) {
        this.modelNames = modelNames;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getExportName() {
        return exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }
}
