package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.util.Struts2Utils;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * Created by zhayw on 2015/5/7.
 */
public class DailyEntityAction extends BaseEntityAction<Object> {

    @Autowired
    private ArchiveService archiveService;

    private String currentId;

//    public Map getShowFields() {
//        Map showFields = null;
//        try {
//            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
//        } catch (TemplateNotFoundException ex) {
//            logger.error(ex.getMessage());
//        }
//        return showFields == null ? Collections.emptyMap() : showFields;
//    }

    @Override
    protected String getJsCallBack() {
        return "onDailyComplete";
    }

    @Override
    protected void afterSave() {
        try{
            this.currentId= PropertyUtils.getProperty(entity, "id").toString();
        }catch (Exception ex){
            logger.error(ex.toString());
        }
    }

    @Override
    protected String renderJs(Runner runner, String successMessage, String failuremessage, String fn) {
        if (fn == null) {
            fn = "onComplete";
        }
        try {
            runner.run();
            if (successMessage == null) {
                successMessage = "";
            }
            Struts2Utils.renderJs("(opener||parent)." + fn + "(true,'" + successMessage + ";" + this.currentId + "');");
        } catch (Exception e) {
            logger.error("error", e);
            if (failuremessage == null) {
                failuremessage = "失败 " + e.getMessage();
            }
            Struts2Utils.renderJs("(opener||parent)." + fn + "(false,'" + failuremessage + "');");
        }
        return null;
    }
}
