package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Note;
import com.gtis.archive.entity.Original;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.*;

/**
 * Created by FYS on 2015/12/9.
 */
public class CheckAction extends BaseModelAction<Archive> {

    /**
     * 判断查询方式：0 电子档案号，1 业务受理号，2 查询全部
     */
    private Integer sc;
    /**
     * 列表显示数目
     */
    private int limit;
    /**
     * 电子档案号
     */
    private String dah;
    /**
     * 业务受理号
     */
    private String slh;
    /**
     *选中的ids
     */
    private String ids;
    /**
     * 选中的单个id
     */
    private String id;
    /**
     * 是否预览模式
     */
    private boolean preview;
    /**
     * 下载,查看还是打印
     */
    private String action = "view";

    @Autowired
    private ArchiveService archiveservice;

    @Autowired
    private CheckService checkservice;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private OriginalPermissionService originalPermissionService;

    @Autowired
    private NoteService noteService;

    @Autowired
    private SysUserService userService;

    @Override
    public String execute() {
        return Action.SUCCESS;
    }

    /**
     * 获取档案信息
     * @return
     * @throws Exception
     */
    @Override
    public String list() throws Exception {
        if (sc == 0 || sc == 1 || sc ==2) {
            try {
                renderJson(getEntityPage());
            } catch (Exception e) {
                logger.error(e.toString());
            }
        } else{
            return null;
        }

        return null;
    }

    /**
     * 获取所有权信息
     * @throws Exception
     */
    public void getArchiveInfo() throws Exception{
        if(id == null || id.isEmpty()){
            return;
        }else{
            Archive archive = archiveservice.getSimpleArchive(id);
            if(archive != null) {
                Page<Archive> archivePage = new Page<Archive>();
                List<Archive> archives = new ArrayList<Archive>();
                archives.add(archive);
                archivePage.setItems(archives);
                renderJson(archivePage);
            }
        }

        return;
    }

    /**
     * 获取前一手档案信息
     * @throws Exception
     */
    public void getPreArchiveInfo() throws Exception{
        if(id == null || id.isEmpty()){
            return;
        }else{
            Archive archive = archiveservice.getSimpleArchive(id);
            if(archive != null) {
                String slh = archive.getSlh();
                renderJson(archiveservice.getPreOrAfterArchiveInfo(slh, "pre", 0, 2));
            }
        }

        return;
    }

    /**
     * 获取档案的卷内目录信息
     */
    public void getLink(){
        if(id == null || id.isEmpty()){
            return ;
        }else {
            Archive archive = archiveservice.getSimpleArchive(id);
            if(archive == null || archive.getRkzt() == null || archive.getRkzt().equals("0") || archive.getRkzt().equals("未入库")){
                return;
            }

            renderJson(checkservice.getOriginalTreeByOwnerId(id));
        }
    }

    /**
     *检查通过
     * @return
     */
    public String checkIsOK(){
        if(id == null || id.isEmpty()){
            return null;
        }else{
            try {
                Archive archive = archiveservice.getSimpleArchive(id);
                archive.setState(Archive.STATE_YGD);                         ////检查通过，设置已归档
                archive.setJcr(SessionUtil.getCurrentUser().getId());  ////设置检查人，为当前登录系统名
                Calendar cal = Calendar.getInstance();
                archive.setJcsj(cal.getTime());                              ////设置检查时间，当前系统时间
                archiveservice.saveArchive(archive);
                Note note = noteService.getNoteByArchiveId(archive.getId());
                PfUserVo userVo = userService.getUserVo(SessionUtil.getCurrentUserId());
                note.setJcr(Struts2Utils.isNull(userVo)?"":userVo.getUserName());
                noteService.saveOrUpdateNote(note);

            }catch(Exception e){
                logger.error(e.toString());
    }
}
        return Action.SUCCESS;
    }

    /**
     *检查不通过
     * @return
     */
    public String checkIsNotOK(){
        if(id == null || id.isEmpty()){
            return null;
        }else{
            try {
                Archive archive = archiveservice.getSimpleArchive(id);
                archive.setState(Archive.STATE_WGD);                         ////检查不通过，设置未归档
                archive.setJcr(SessionUtil.getCurrentUser().getUsername());  ////设置检查人，为当前登录系统名
                Calendar cal = Calendar.getInstance();
                archive.setJcsj(cal.getTime());                              ////设置检查时间，当前系统时间
                archiveservice.saveArchive(archive);
            }catch (Exception e){
                logger.error(e.toString());
            }
        }
        return Action.SUCCESS;
    }

    /**
     *复检检查通过
     * @return
     */
    public String recheckIsOK(){
        if(id == null || id.isEmpty()){
            return null;
        }else{
            try {
                Archive archive = archiveservice.getSimpleArchive(id);
                archive.setState(Archive.STATE_YGD);                         ////复检通过，设置已归档
                archive.setFjr(SessionUtil.getCurrentUser().getId());  ////设置复检人，为当前登录系统名
                Calendar cal = Calendar.getInstance();
                archive.setFjsj(cal.getTime());                              ////设置复检时间，当前系统时间
                archiveservice.saveArchive(archive);
            }catch(Exception e){
                logger.error(e.toString());
            }
        }
        return Action.SUCCESS;
    }

    @Override
    protected Page<Archive> getEntityPage(){
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        return searchEntity(criterions, orders);
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if(sc == 0) {
            criterions.add(Restrictions.like("dzdah", "%"+dah+"%"));
        }else if(sc == 1){
            criterions.add(Restrictions.like("slh", "%" + slh + "%"));
        }else {
            //criterions.add(Restrictions.eq("1", 1));
        }
        return super.createCriterions(criterions);
    }

    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        Page<Archive> page = entityService.search("Archive", criterions, orders, start, limit);
        Page<Archive> newPage = archiveservice.getNameByid(page);
        return newPage;
    }

    public Integer getSc() {
        return sc;
    }

    public void setSc(Integer sc) {
        this.sc = sc;
    }

    @Override
    public int getLimit() {
        return limit;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getDah() {
        return dah;
    }

    public void setDah(String dah) {
        this.dah = dah;
    }

    public String getSlh() {
        return slh;
    }

    public void setSlh(String slh) {
        this.slh = slh;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ArchiveService getArchiveservice() {
        return archiveservice;
    }

    public void setArchiveservice(ArchiveService archiveservice) {
        this.archiveservice = archiveservice;
    }

    public CheckService getCheckservice() {
        return checkservice;
    }

    public void setCheckservice(CheckService checkservice) {
        this.checkservice = checkservice;
    }

    public OriginalService getOriginalService() {
        return originalService;
    }

    public void setOriginalService(OriginalService originalService) {
        this.originalService = originalService;
    }

    public boolean isPreview() {
        return preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public OriginalPermissionService getOriginalPermissionService() {
        return originalPermissionService;
    }

    public void setOriginalPermissionService(OriginalPermissionService originalPermissionService) {
        this.originalPermissionService = originalPermissionService;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}
