package com.gtis.archive.web;


import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import freemarker.template.TemplateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;


import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

public class BorrowAction extends BaseModelAction<Archive> {

    @Autowired
    private LoanService loanService;

    @Autowired
    protected ModelService modelService;

    @Autowired
    protected EntityService entityService;

    @Autowired
    private SysUserService userService;

    private String archiveType;

    private String idString;

    private String id;


    public String getArchiveType(){
        return this.archiveType;
    }

    public void setArchiveType(String archiveType){
        this.archiveType=archiveType;
    }

    public void  setId(String id){
        this.id=id;
    }

    public void setIdString(String idString){
        this.idString=idString;
    }

    public void setIds(String[] ids){
        this.ids=ids;
    }

    public List<LoanCart> getLoanCar(){
            List<LoanCart> entities =new ArrayList<LoanCart>();
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if(!"".equals(idString)){
                Date date=new Date();
                for(String id:idString.split(",")){
                    LoanCart lc=new LoanCart();
                    lc.setArchiveId(id.trim());
                    lc.setUserId(userInfo.getId());
                    lc.setArchiveType(archiveType);
                    lc.setInDate(date);
                    lc.setDwdm(getDwdm());
                    if(archiveType.indexOf("_jn")!=-1){
                      Document document= entityService.load(archiveType,id.trim());
                        if(document.getArchive()!=null||document.getArchiveId()!=null){
                            Archive archive= document.getArchive()==null?
                                    (Archive) entityService.load(Archive.class, document.getArchiveId()):
                                    document.getArchive();
                            if(archive!=null){
                                lc.setAjh(String.valueOf(archive.getAjh()));
                                lc.setMlh(archive.getMlh());
                                lc.setDh(archive.getDh());
                            }
                        }
                        lc.setTm(document.getTm());
                    }else{
                        Archive arvhice=entityService.load(archiveType,id.trim());
                        lc.setMlh(arvhice.getMlh());
                        lc.setAjh(arvhice.getAjh().toString());
                        lc.setTm(arvhice.getTm());
                        lc.setDh(arvhice.getDh());
                    }
                    entities.add(lc);
                }
            }
        return entities;
    }

    public String borrows(){
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        if(userInfo.isAdmin()){
            renderJson(loanService.getPages(start,limit,criterions));
        }else {
            Criterion cr = Restrictions.eq("userId",userInfo.getId());
            criterions.add(cr);
            renderJson(loanService.getPages(start,limit,criterions));
        }
        return null;
    }

    public String addLoanCar(){
        for(LoanCart loancar:getLoanCar()){
           loanService.addToCart(loancar);
        }
       Struts2Utils.renderJson("success");
        return null;
    }

    public String getDwdm(){
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    public String remove(){
        loanService.removeFromCart(entityService.load(LoanCart.class,id));
        Struts2Utils.renderJson("success");
        return null;
    }

    public Model getEntityModel() {
        return modelService.getModel("LoanCart");
    }

}
