package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.Position;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.BindService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.ResourceService;
import com.gtis.common.Page;
import com.opensymphony.xwork2.Action;
import org.springframework.beans.factory.annotation.Autowired;

import java.awt.*;
import java.util.*;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:USER@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-10-20
 */
public class BindAction extends BaseModelAction<Position> {
    private String type = "model";

    @Autowired
    private BindService bindService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private OriginalService originalService;
    /**
     * 案卷ID
     */
    private String archiveid;
    /**
     * 业务类型
     */
    private String modelname;
    /**
     * id
     */
    private String id;
    /**
     * ids
     */
    private String[] ids;
    /**
     * 架号
     */
    private String jhid;
    /**
     * 架号
     */
    private String jh;
    /**
     * 排号
     */
    private String phid;
    /**
     * 排号
     */
    private String ph;
    /**
     * 盒号
     */
    private String hhid;
    /**
     * 盒号
     */
    private String hh;
    /**
     * 盒号集合
     */
    private String[] hhs;
    /**
     * 排序
     */
    private int ordernumber;
    /**
     * 查询级别 0查询架号，1查询排号，2查询盒号
     */
    private Integer jb;
    /**
     * 电子档案号
     */
    private String dahid;
    /**
     * 电子档案号
     */
    private String dzdah;
    /**
     * 档案数
     */
    private String das;
    /**
     * 分类号
     */
    private String flh;

    private Position positionid;

    @Override
    public String execute() {
        return SUCCESS;
    }

    /**
     * 获取架号，排号，盒号信息
     */
    public void jhList() throws Exception {
        try {
            renderJson(bindService.getEntityPage(jb, id, limit, start));
        } catch (Exception e) {
            logger.error("获取架号（排号、盒号）惊现异常：{}", e.toString());
        }
        return;
    }

    /**
     * 获取档案信息
     */
    public void daxxList() throws Exception {
        try {
            renderJson(archiveService.searchArchive(jh, ph, hh, start, limit));
        } catch (Exception e) {
            logger.error("获取电子档案号惊现异常：{}", e.toString());
        }
        return;
    }

    /**
     * 获取所有权信息
     * @throws Exception
     */
    public void getArchiveInfo() throws Exception {
        try {
            Page<Archive> archivePage = new Page<Archive>();
            if (archiveid == null || archiveid == "" || archiveid.isEmpty()) {
                renderJson(archivePage);
                return;
            } else {
                Archive archive = archiveService.getSimpleArchive(archiveid);
                if (archive != null) {
                    List<Archive> archives = new ArrayList<Archive>();
                    archives.add(archive);
                    archivePage.setItems(archives);
                    Page<Archive> newPage = archiveService.getNameByid(archivePage);
                    renderJson(newPage);
                }
            }
        }
        catch(Exception e){
            logger.error("获取所有权信息失败：" + e.toString());
        }
        return;
    }

    /**
     * 删除架号、排号、盒号信息
     */
    public void delete() {
        try {
            if (ids == null || ids.length == 0) {
                renderJson("");
            }

            String sMessage = "";
            if (jb == 0 || jb == 1) {
                for (int i = 0; i < ids.length; i++) {
                    Position position = bindService.getSimplePosition(ids[i]);
                    if (position == null) {
                        continue;
                    }

                    if (position.getChilds().size() > 0) {
                        if (jb == 0) {
                            sMessage = sMessage + "请先删除架号（" + position.getJh() + "）下的所有排号！" + "\n";
                        } else if (jb == 1) {
                            sMessage = sMessage + "请先删除排号（" + position.getPh() + "）下的所有盒号！" + "\n";
                        }
                        continue;
                    }

                    entityService.remove(Position.class, ids);
                }
            } else {
                if (modifyArchiveInfo()) {
                    entityService.remove(Position.class, ids);
                }
            }

            renderJson(sMessage);
        } catch (Exception e) {
            logger.error("删除架号（排号、盒号）惊现异常：{}", e.toString());
            renderJson("");
        }
    }

    /**
     * 修改案卷信息（架号、排号、盒号）
     */
    public boolean modifyArchiveInfo(){
        if(jh == null || jh.isEmpty() || ph == null || ph.isEmpty() || hhs == null || hhs.length ==0){
            return false;
        }

        try{
            for(int i = 0; i< hhs.length; i++){
                String hh = hhs[i];
                List list = archiveService.getArchive(jh, ph, hh);
                if(list == null || list.size() == 0){
                    continue;
                }

                for(int j = 0; j < list.size(); j++){
                    Archive archive = (Archive)list.get(j);
                    archive.setJh("");
                    archive.setPh("");
                    archive.setHh("");
                    archiveService.saveArchive(archive);
                }
            }

        }catch (Exception e){
            logger.error("删除盒号时修改案卷信息惊现异常：{}", e.toString());
            return false;
        }

        return true;
    }

    /**
     * 保存架号
     */
    public String saveJh() {
        try {
            //获取最大排序号OrderNum
            int iMaxNum = bindService.getMaxOrderNum();
            iMaxNum = iMaxNum + 1;
            //获取最大架号（三位）
            int iJh = bindService.getMaxJh();
            iJh = iJh + 1;
            String sJh = "000" + iJh;
            sJh = sJh.substring(sJh.length() - 3);
            //设置数值，保存
            Position position = new Position();
            position.setJh(sJh);
            position.setOrderNum(iMaxNum);
            bindService.savePosition(position);
        } catch (Exception e) {
            logger.error("保存架号（排号、盒号）惊现异常：{}", e.toString());
            return null;
        }

        return Action.SUCCESS;
    }

    /**
     * 保存排号
     */
    public String savePh() {
        try {
            if(id == null || id == "" || id.isEmpty()){
                return null;
            }

            //获取父节点
            Position parent = bindService.getSimplePosition(id);
            if(parent == null){
                return null;
            }

            //获取最大排序号OrderNum
            int iMaxNum = bindService.getMaxOrderNum();
            iMaxNum = iMaxNum + 1;
            //获取最大架号（三位）
            int iPh = bindService.getMaxPh(id);
            iPh = iPh + 1;
            String sPh = "000" + iPh;
            sPh = sPh.substring(sPh.length() - 3);
            //设置数值，保存
            Position position = new Position();
            position.setPh(sPh);
            position.setOrderNum(iMaxNum);
            position.setParent(parent);
            bindService.savePosition(position);
        } catch (Exception e) {
            logger.error("保存架号（排号、盒号）惊现异常：{}", e.toString());
            return null;
        }

        return Action.SUCCESS;
    }

    /**
     * 保存档案信息
     * @return
     */
    public void saveArchiveInfo() {
        try {
            if (id == null || id.isEmpty() ||
                    flh == null || flh.isEmpty() ||
                    jh == null || jh.isEmpty() ||
                    ph == null || ph.isEmpty() ||
                    dzdah == null || dzdah.isEmpty() ||
                    das == null || das.isEmpty()) {
                renderJson("");
            }

            Position position = getAndSaveHh();
            if (position == null || position.getHh() == "" || position.getHh().isEmpty()) {
                renderJson("");
            }

            boolean bIsSuccess = archiveService.saveArchiveInfo(jh, ph, position.getHh(), flh, dzdah, das);
            if (!bIsSuccess) {
                renderJson("修改案卷信息失败！");
            }

            bindService.savePosition(position);
        } catch (Exception e) {
            logger.error(e.toString());
            return;
        }
    }

    /**
     * 保存盒号,并获取到最新的盒号值
     * @return （返回最大的盒号）
     */
    public Position getAndSaveHh(){
        String sHh = "";
        try {
            if(id == null || id == "" || id.isEmpty()){
                return null;
            }

            //获取父节点
            Position parent = bindService.getSimplePosition(id);
            if(parent == null){
                return null;
            }

            //获取最大排序号OrderNum
            int iMaxNum = bindService.getMaxOrderNum();
            iMaxNum = iMaxNum + 1;
            //获取最大架号（三位）
            int iHh = bindService.getMaxHh();
            iHh = iHh + 1;
            sHh = "0000000" + iHh;
            sHh = sHh.substring(sHh.length() - 7);
            //设置数值，保存
            Position position = new Position();
            position.setHh(sHh);
            position.setParent(parent);
            position.setOrderNum(iMaxNum);

            return position;
        } catch (Exception e) {
            logger.error("保存架号（排号、盒号）惊现异常：{}", e.toString());
            return null;
        }
    }

    /**
     * 获取档案信息的电子档案号（最近一条未进行上架的电子档案号）
     */
    public void getArchiveDzdah(){
        try{
            Archive archive = bindService.getArchiveDzdah(flh);
            if(archive == null || archive.getDzdah().isEmpty()){
                renderJson("NULL");
            }

            renderJson(archive.getDzdah());
        }catch (Exception e){
            logger.error(e.toString());
            renderJson("NULL");
        }
    }

    /**
     * 获取档案类型
     * @return
     */
    public Map getSearchModelFields() {
        List<Resource> ress = resourceService.getChildrenResource(resourceService.getResource(null, type).getId());
        Map map = new LinkedHashMap();
        for (Resource resource : ress) {
            List<Resource> childress = resourceService.getChildrenResource(resource.getId());
            for (Resource childres : childress) {
                map.put(childres.getName(), childres);
            }
        }
        return map;
    }

    /**
     * 获取卷内信息
     */
    public void getDocument(){
        try{
            Page<Original> originalPage = new Page<Original>();
            if(archiveid == "" || archiveid.isEmpty()) {
                renderJson(originalPage);
                return;
            }else{
                List list = originalService.getOriginallist(archiveid);
                if(list == null || list.size() == 0){
                    renderJson(originalPage);
                    return;
                }

                List<Original> originals = (List<Original>)list;
                originalPage.setItems(originals);
                renderJson(originalPage);
            }
        }catch (Exception e){
            logger.error("删除架号（排号、盒号）惊现异常：{}",e.toString());
        }
        return;
    }

    public String getArchiveid() {
        return archiveid;
    }

    public void setArchiveid(String archiveid) {
        this.archiveid = archiveid;
    }

    public String getModelname() {
        return modelname;
    }

    public void setModelname(String modelname) {
        this.modelname = modelname;
    }

    public String[] getIds() {
        return ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJhid() {
        return jhid;
    }

    public void setJhid(String jhid) {
        this.jhid = jhid;
    }

    public String getPhid() {
        return phid;
    }

    public void setPhid(String phid) {
        this.phid = phid;
    }

    public String getJh() {
        return jh;
    }

    public void setJh(String jh) {
        this.jh = jh;
    }

    public String getPh() {
        return ph;
    }

    public void setPh(String ph) {
        this.ph = ph;
    }

    public String getHhid() {
        return hhid;
    }

    public void setHhid(String hhid) {
        this.hhid = hhid;
    }

    public String getHh() {
        return hh;
    }

    public void setHh(String hh) {
        this.hh = hh;
    }

    public String[] getHhs() {
        return hhs;
    }

    public void setHhs(String[] hhs) {
        this.hhs = hhs;
    }

    public int getOrdernumber() {
        return ordernumber;
    }

    public void setOrdernumber(int ordernumber) {
        this.ordernumber = ordernumber;
    }

    public String getDahid() {
        return dahid;
    }

    public void setDahid(String dahid) {
        this.dahid = dahid;
    }

    public String getDzdah() {
        return dzdah;
    }

    public void setDzdah(String dzdah) {
        this.dzdah = dzdah;
    }

    public String getDas() {
        return das;
    }

    public void setDas(String das) {
        this.das = das;
    }

    public String getFlh() {
        return flh;
    }

    public void setFlh(String flh) {
        this.flh = flh;
    }

    public Position getPositionid() {
        return positionid;
    }

    public void setPositionid(Position positionid) {
        this.positionid = positionid;
    }

    public Integer getJb() {
        return jb;
    }

    public void setJb(Integer jb) {
        this.jb = jb;
    }
}
