package com.gtis.archive.service.sv;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by zhayw on 2015/6/5.
 */
public class SqlServerServiceImpl implements SqlServerService {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerServiceImpl.class);
    private String driverName;
    private String dbUrl;
    private String dbUsername;
    private String password;

    Connection conn = null;
    PreparedStatement preparedStatement = null;

    @Override
    public Map insertOpenCmd(String content, String cmd, String operator) {
        Map map = new HashMap();
//        String sql = "insert into wdCmd (operator,cmd,qh,lh,wlh,jh,ch,lwz,czsj,isDo) values (?,?,?,?,?,?,?,?,?,?)";
        String sql = "insert into wdCmd (operator,cmd,lch,kfh,qh,wqh,lh,wlh,jh,ch,lwz,czsj,isDo) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String[] values = content.split("-");

        try {
            conn = getConnection();
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setString(1, "超级用户");
            preparedStatement.setString(2, cmd);
            preparedStatement.setInt(3, 1);
            preparedStatement.setInt(4, 1);
            preparedStatement.setInt(5, Integer.parseInt(values[0]));
            preparedStatement.setInt(6, Integer.parseInt(values[0]));
            preparedStatement.setInt(7, Integer.parseInt(values[1]));
            preparedStatement.setInt(8, Integer.parseInt(values[1]));
            preparedStatement.setInt(9, Integer.parseInt(values[2]));
            preparedStatement.setInt(10, Integer.parseInt(values[3]));
            preparedStatement.setString(11, values[4]);
            preparedStatement.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setInt(13,0);

            int row = preparedStatement.executeUpdate();

            if (row>0){
                map.put("success", true);
            }else{
                map.put("success", false);
                map.put("msg", "操作失败！");
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("jdbc error:" + e.toString());
            map.put("success", false);
            map.put("msg", "操作异常:" + e.toString());
        }finally {
            try {
                if (preparedStatement == null)
                    preparedStatement.close();
                if (conn == null)
                    conn.close();
            }catch (Exception ex) {

            }
        }

        return map;
    }

    private Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.driverName);
        return DriverManager.getConnection(this.dbUrl,dbUsername,this.password);
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
