package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.entity.Material;
import com.gtis.archive.entity.PrintConfig;
import com.gtis.archive.service.PrintService;
import com.gtis.config.AppConfig;
import com.gtis.support.hibernate.HibernateDao;
import com.gtis.web.SessionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.awt.*;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.*;
import java.util.List;

/**
 * Created by zhayuwen on 2015/12/12.
 */
@Service
public class PrintServiceImpl extends HibernateDao implements PrintService {

    @Autowired
    private DictService dictService;

    @Autowired
    private EntityService entityService;

    private String parseUrlWithParams(String url, Map<String, Object> params){
        StringBuffer buffer = new StringBuffer(url);
        for (String key : params.keySet()){
            buffer.append("&").append(key).append("=").append(params.get(key));
        }
        return buffer.toString();
    }

    private void parseBatchConfig(Map batchMap, Map<String, Object> params){
        for (String key : params.keySet()){
            if(!"op".equals(key)){
                batchMap.put(key, params.get(key));
            }
        }
    }

    @Override
    public Map getUserPrintTpl(String userid, Integer type, Map params) {
        Map configInfo = new HashMap();            //所有配置信息
        List<Map> configs = new ArrayList<Map>();  //配置模板信息
        List<Map> batchPrintCfg = new ArrayList<Map>(); //批量打印配置
        String reportUrl = AppConfig.getProperty("report.url");
        String path = AppConfig.getProperty("fine.report.dir.name");

        Map sqlParams = new HashMap();
        String hql = "FROM PrintConfig p WHERE p.userid =:userId AND p.type=:type";
        sqlParams.put("userId", userid);
        sqlParams.put("type", type);
        List<PrintConfig> configList = new ArrayList<PrintConfig>();

        List<Item> items = null;
        configList.addAll(find(hql, sqlParams));
        try {
            items = dictService.getItems("printTplMgr");
        } catch (Exception e) {
            logger.error("您的字典【printTplMgr】，不存在，请在【字典管理】当中配置字典信息！");
            return null;
        }
        for(Item item : items){
            for(PrintConfig printConfig:configList){
                if(printConfig.getTplId().equals(item.getId())){
                    Map map = new LinkedHashMap();
                    Map batchMap = new LinkedHashMap();
                    try {
                        map.put("name", item.getName());
                        map.put("url", reportUrl + "/ReportServer?reportlet="+ URLEncoder.encode(path) +"%2F"  + parseUrlWithParams(URLEncoder.encode(item.getValue(),"UTF-8"), params));
                        batchMap.put("reportlet", URLEncoder.encode(path) +"%2F"  + URLEncoder.encode(item.getValue(), "UTF-8"));
                        parseBatchConfig(batchMap, params);
                    } catch (UnsupportedEncodingException e) {
                        logger.error("转换URL出现异常：{}", e.toString());
                    }
                    batchPrintCfg.add(batchMap);
                    configs.add(map);
                }
            }
        }

        configInfo.put("tpls", configs);
        configInfo.put("reportlets", batchPrintCfg);
        configInfo.put("printurl", reportUrl+"/ReportServer");

        return configInfo;
    }

    @Override
    public Map getTplDatas(int type, String userId) {
        Map datas = new HashMap();
        List<Item> items = null;
        List<Map> types = new ArrayList<Map>();
        Set<String> tplIdSet = new HashSet<String>();
        try {
            items = dictService.getItems("printTplMgr");
        } catch (Exception e) {
            logger.error("您的字典【printTplMgr】，不存在，请在【字典管理】当中配置字典信息！");
        }

        Map sqlParams = new HashMap();
        String hql = "FROM PrintConfig p WHERE p.userid =:userId AND p.type=:type";
        sqlParams.put("userId", userId);
        sqlParams.put("type", type);

        List<PrintConfig> list = find(hql, sqlParams);

        for(PrintConfig printConfig : list){
            tplIdSet.add(printConfig.getTplId());
        }

        for(Item item : items){
            if(item.getRemark().equals(String.valueOf(type)) && !tplIdSet.contains(item.getId())){
                Map map = new HashMap();
                map.put("did", item.getId());
                map.put("name", item.getName());
                map.put("fileName", item.getValue());
                types.add(map);
            }
        }

//        if(list.size() == 0){
//            for(Item item : items){
//                if(item.getRemark().equals(String.valueOf(type))){
//                    Map map = new HashMap();
//                    map.put("did", item.getId());
//                    map.put("name", item.getName());
//                    map.put("fileName", item.getValue());
//                    types.add(map);
//                }
//            }
//        }

        datas.put("datas", types);
        return datas;
    }

    @Override
    public Map getUserTplDatas(int type, String userId) {
        Map datas = new HashMap();
        List<Map> items = new ArrayList<Map>();
        Map sqlParams = new HashMap();
        String hql = "FROM PrintConfig p WHERE p.userid =:userId AND p.type=:type";
        sqlParams.put("userId", userId);
        sqlParams.put("type", type);

        List<PrintConfig> list = find(hql, sqlParams);
        List<Item> typeItems = null;
        try {
            typeItems = dictService.getItems("printTplMgr");
        } catch (Exception e) {
            logger.error("您的字典【printTplMgr】，不存在，请在【字典管理】当中配置字典信息！");
        }

        for(Item item : typeItems){
            for (PrintConfig printConfig : list){
                if(item.getId().equals(printConfig.getTplId())){
                    Map map = new HashMap();
                    map.put("id", printConfig.getId());
                    map.put("did", item.getId());
                    map.put("name", item.getName());
                    map.put("fileName", item.getValue());
                    items.add(map);
                }
            }
        }
        datas.put("datas", items);

        return datas;
    }

    @Transactional
    public Map addTpl(int type, String tplId) {
        String userid = SessionUtil.getCurrentUserId();
        PrintConfig printConfig = new PrintConfig();
        printConfig.setTplId(tplId);
        printConfig.setType(type);
        printConfig.setUserid(userid);
        getSession().save(printConfig);
        return null;
    }

    @Override
    public Map removeUserTpl(String tplPk) {
        entityService.remove(PrintConfig.class, new String[]{tplPk});
        return null;
    }
}
