package com.gtis.archive.service.impl;

import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.OriginalPermission;
import com.gtis.archive.service.OriginalPermissionService;
import com.gtis.common.Page;
import com.gtis.plat.vo.UserInfo;
import com.gtis.support.hibernate.HibernateTemplate;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-5-12
 */
public class OriginalPermissionServiceImpl extends HibernateTemplate<OriginalPermission, String> implements OriginalPermissionService {
    private boolean originalPermissionEnable = false;

    public void setOriginalPermissionEnable(boolean originalPermissionEnable) {
        this.originalPermissionEnable = originalPermissionEnable;
    }

    public boolean isOriginalPermissionEnable() {
        return originalPermissionEnable;
    }

    public boolean hasOriginalPermission(String originalId) {
        if (!originalPermissionEnable)
            return true;
        UserInfo user = SessionUtil.getCurrentUser();
        return SessionUtil.getCurrentUser().isAdmin() || findUnique(Restrictions.eq("userId", user.getId()), Restrictions.eq("originalId", originalId)) != null;
    }

    @Transactional
    public OriginalPermission saveOriginalPermission(OriginalPermission originalPermission) {
        if (!originalPermissionEnable)
            return null;
        OriginalPermission op1 = findUnique(Restrictions.eq("originalId", originalPermission.getOriginalId()), Restrictions.eq("userId", originalPermission.getUserId()));
        if (op1 != null) {
            op1.setOperation(originalPermission.getOperation());
            op1.setExpireTime(originalPermission.getExpireTime());
            originalPermission = op1;
        }
        originalPermission.setAuthorizer(SessionUtil.getCurrentUser().getUsername());
        originalPermission.setCreateTime(new Date());
        save(originalPermission);
        return originalPermission;
    }

    @Transactional
    public void removeOriginalPermission(String id) {
        delete(id);
    }

    @SuppressWarnings("unchecked")
    public List<OriginalPermission> getOriginalPermissions(String originalId) {
        return find(Restrictions.eq("originalId", originalId));
    }

    @SuppressWarnings("unchecked")
    public Page<OriginalPermission> searchOriginalPermission(String name, int start, int limit) {
        List<Criterion> criterions = new ArrayList<Criterion>();
        if (StringUtils.isNotBlank(name))
            criterions.add(Restrictions.like("original.name", "%" + name + "%"));
        return search(criterions, Collections.singletonList(Order.desc("id")), start, limit);
    }

    @SuppressWarnings("unchecked")
    public Page<Original> searchOriginal(String ownerId, String name, int start, int limit) {
        UserInfo user = SessionUtil.getCurrentUser();
        StringBuilder sb = new StringBuilder(" from OriginalPermission as op inner join op.original as o where op.userId=:userId and o.ownerId=:ownerId and (op.expireTime > :now or op.expireTime is null)");
        Map map = new HashMap();
        map.put("userId", user.getId());
        map.put("ownerId", ownerId);
        map.put("now", DateUtils.addDays(new Date(), -1));
        if (name != null) {
            map.put("name", "%" + name + "%");
            sb.append(" and o.name like :name");
        }
        sb.append(" order by o.id desc");
        String hql = "select o" + sb;
        String countHql = "select count(o)" + sb;
        Page page = new Page(Page.toIndex(start, limit), limit);
        page.setItems(createQuery(hql, map).setFirstResult(start).setMaxResults(limit).list());
        page.setTotalCount(((Long) (findUnique(countHql, map))).intValue());
        return page;
    }
}
