package com.gtis.archive.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.service.invoke.ArchiveReceiveSecivce;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.InvocationTargetException;
import java.util.*;

/**
 * Created by zhayuwen on 2015/12/9.
 */
public class MaterialServiceImpl extends HibernateTemplate implements MaterialService {
    @Autowired
    private EntityService entityService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private ArchiveReceiveSecivce archiveReceiveSecivce;

    @Autowired
    private ResourceService resourceService;

    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    @Autowired
    private SysUserService userService;

    private Logger logger = LoggerFactory.getLogger(MaterialServiceImpl.class);

    /**
     * is null
     *
     * @param value
     * @return
     */
    protected boolean isNull(Object value) {
        if (value == null) return true;
        if (value instanceof String) return StringUtils.isBlank((String) value);
        return false;
    }

    protected boolean hasProperty(Object bean, String propertyName) {
        try {
            BeanUtils.getProperty(bean, propertyName);
        } catch (IllegalAccessException e) {
            return false;
        } catch (InvocationTargetException e) {
            return false;
        } catch (NoSuchMethodException e) {
            return false;
        }

        return true;
    }

    private void parseCondition(Map<String, Object> conditions, List<Criterion> list) {
        if (isNull(conditions))
            return;

        for (String key : conditions.keySet()) {
            if(!Struts2Utils.isNull(conditions.get(key))){
                list.add(Restrictions.like(key, "%" + conditions.get(key) + "%"));
            }
        }
    }

    /**
     * 获取当前用户的单位代码
     *
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    protected void updateEntity(Object bean, Map values) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (Object key : values.keySet()) {
            if (hasProperty(bean, key.toString()))
                PropertyUtils.setProperty(bean,  key.toString(), values.get(key));
        }
    }

    @Override
    public Page<Material> searchMaterial(Map conditions, int start, int limit) {
        Page<Material> materialPage = null;
        List<Criterion> list = new ArrayList<Criterion>();
        list.add(Restrictions.eq("enabled", true));
        parseCondition(conditions, list);

        materialPage = entityService.search(Material.class, list, null, start, limit);
        if (materialPage == null)
            return new Page<Material>();
        return materialPage;
    }


    @Override
    public Page<MaterialArchive> getMaterialArchiveByMaterialId(Map conditions, String id, int start, int limit) {
        Page<MaterialArchive> materialArchivePage = null;
        List<Order> orders = null;
        List<Criterion> list = new ArrayList<Criterion>();
        if (!isNull(id)) {
            list.add(Restrictions.eq("material.id", id));
        }
        list.add(Restrictions.eq("enabled", true));
        parseCondition(conditions, list);
        materialArchivePage = entityService.search(MaterialArchive.class, list, orders, start, limit);
        for (MaterialArchive materialArchive : materialArchivePage.getItems()) {
            if (!isNull(materialArchive.getMaterial()))
                materialArchive.setMaterial(null);
        }

        if (materialArchivePage == null) {
            materialArchivePage = new Page<MaterialArchive>();
        }
        return materialArchivePage;
    }

    /**
     * 清除交接单的缓存信息，讲退回的交接单反馈给不动产系统
     *
     * @param mId
     * @param info
     * @param thr
     * @param jjdhs
     * @return
     */
    public Map refuseMateria(String mId, String info, String thr, String jjdhs) {
        Map result = new HashMap();
        List msg = new ArrayList();

        String[] mIds = mId.split(",");
        String[] jjdhList = jjdhs.split(",");

        for(String jjdh : jjdhList){
            Map data = new HashMap();
            data.put("thyy", info);
            data.put("thr", thr);
            data.put("jjdbh", jjdh);
            data.put("jjsfcg", 2);     //是否交接成功，退回为2， 接口约定不变的数字
            msg.add(data);
        }

        try {
            archiveReceiveSecivce.receive(JSONArray.toJSONString(msg));
            entityService.remove(Material.class, mIds);
            result.put("success", true);
        } catch (Exception e) {
            result.put("success", false);
            logger.error("退回收件单出现异常信息【{}】", e.toString());
        }

        return result;
    }

    /**
     * 把收件单的内容归档为档案信息
     * @param mId
     * @param rid
     * @return
     */
    @Transactional
    public Map receviceMateria(String mId,  String rid, String userid) {
        Map result = new HashMap();
        String[] mIds = mId.split(",");
        List msg = new ArrayList();
        List<Archive> archives = new ArrayList<Archive>();
        List<Material> materials = new ArrayList<Material>();
        Resource resource = resourceService.getResource(rid);
        String modelName = resource.getName();
        boolean flag = true; //默认没有异常

//        Session session = getSession();
//        Transaction transaction = session.getTransaction();
//        transaction.begin();
        try {
            for (String id : mIds) {
                Material material = entityService.load(Material.class, id);
                for (MaterialArchive materialArchive : material.getMaterialArchives()) {
                    Archive archive = entityService.newInstance(modelName);
                    archive.setResourceId(rid);
                    archive.setJjdbh(material.getJjdbh());
                    archive.setSjr(userid);
                    archive.setJsrq(material.getJsrq());
                    archive.setCreatedAt(new Date());

                    materialArchive.setMaterial(null);
                    Map map = JSONObject.parseObject(JSON.toJSONString(materialArchive), Map.class);
                    updateEntity(archive, map);
                    materialArchive.setMaterial(material);
                    archives.add(archive);
                }

                materials.add(material);
                result.put("success", true);

                //组织接收成功的信息反馈回不动产接口
                Map data  = new HashMap();
                data.put("jjdbh", material.getJjdbh());
                data.put("jjsfcg", 1);     //是否交接成功，归档成功为1， 接口约定不变的数字
                data.put("sjr", SessionUtil.getCurrentUser().getUsername());
                msg.add(data);
            }
            archiveReceiveSecivce.receive(JSONArray.toJSONString(msg));
        } catch (IllegalAccessException e) {
            flag = false;
            result.put("success", false);
            logger.error("MaterialArchive transfer to Archive with IllegalAccessException：{}", e.toString());
        } catch (InvocationTargetException e) {
            flag = false;
            result.put("success", false);
            logger.error("MaterialArchive transfer to Archive with InvocationTargetException：{}", e.toString());
        } catch (NoSuchMethodException e) {
            flag = false;
            result.put("success", false);
            logger.error("MaterialArchive transfer to Archive with NoSuchMethodException：{}", e.toString());
        } catch (Exception e) {
            flag = false;
            result.put("success", false);
            logger.error("【确认收件单】归档反馈信息至不动产接口出现异常信息【{}】", e.toString());
        }finally {
           if(flag) {
               try {
                   AjhRange ajhRange = null;
                   RecordAjhRange recordAjhRange = null;
                   for(Archive archive : archives){
                       recordAjhRange = recordAjhRangeService.getAvailable(archive.getMlh(), modelName, getDwdm());
                       if (recordAjhRange != null) {
                           archive.setFlh(resource.getFlh());
                           archive.setAjh(recordAjhRange.getAjh());
                           archive.setDzdah(resource.getFlh()+archiveService.getdzdah(recordAjhRange.getAjh()));
                       } else {
                           ajhRange = ajhRangeService.getAvailableAjhRange(modelName, archive.getMlh());
                           archive.setAjh(ajhRange.getNextValue());
                           archive.setDzdah(resource.getFlh()+archiveService.getdzdah(ajhRange.getNextValue()));
                           archive.setFlh(resource.getFlh());
                       }

                       if(recordAjhRange != null){
                           recordAjhRangeService.remove(recordAjhRange.getId());
                       }else{
                           ajhRange.setCurrentValue(ajhRange.getNextValue());
                           ajhRangeService.saveAjhRange(ajhRange);
                       }
                       archiveService.saveArchive(archive);
                   }

                   for(Material material :materials){
                       material.setEnabled(false);
                       for(MaterialArchive materialArchive : material.getMaterialArchives()){
                           materialArchive.setEnabled(false);
                       }
                   }
               } catch (Exception e) {
                   logger.error("归档存储出现异常：{}",e.toString());
                   throw new RuntimeException(e);
               }finally {
                   return result;
               }
           }
            return result;
        }
    }

    @Transactional
    public Map materilIn(String bdcjjd, String bdcjjdXx) {
        Map result = new HashMap();
        try {
            if(isNull(bdcjjd) || isNull(bdcjjdXx)){
                result.put("success", false);
                return result;
            }
            Material material = JSONObject.parseObject(bdcjjd, Material.class);
            List<MaterialArchive> materialArchives = JSONArray.parseArray(bdcjjdXx, MaterialArchive.class);
            for(MaterialArchive materialArchive : materialArchives){
                materialArchive.setEnabled(true);
                materialArchive.setMaterial(material);
            }

            material.setMaterialArchives(new HashSet(materialArchives));
            material.setEnabled(true);
            material.setJsrq(new Date());
            getSession().save(material);
            result.put("success", true);
        }catch (Exception e) {
            result.put("success", false);
            logger.error("归档异常{}", e.toString());
        }
        return result;
    }

    @Override
    public Map getMaterilType(String id) {
        Map root = new HashMap();
        List result = new ArrayList();
        List<Resource> resources = null;
        if(!Struts2Utils.isNull(id)){
            resources = resourceService.getChildrenResource(id);
        }else {
            resources = resourceService.getChildrenResource(resourceService.getResource(null, "model").getId());
        }
        for (Resource resource : resources){
            List<Map> item = new ArrayList<Map>();
            Map map = new HashMap();
            map.put("name", resource.getTitle());
            map.put("value", resource.getId());
            result.add(map);
        }
        root.put("data", result);
        return root;
    }
}
