package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.CheckService;
import com.gtis.support.hibernate.HibernateTemplate;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-11-30
 */
@Service
public class CheckServiceImpl extends HibernateTemplate<Original, String> implements CheckService {

    public static boolean flag = false;

    public static int fileSize = -1;

    private final static Logger logger = LoggerFactory.getLogger(CheckServiceImpl.class);
    @Autowired
    protected EntityService entityService;

    public static int getFileSize() {
        return fileSize;
    }

    public static void setFileSize(int fileSize) {
        CheckServiceImpl.fileSize = fileSize;
    }

    @Override
    public List getOriginalTreeByOwnerId(String ownerId){
        List<Original> originals = createCriteria(Restrictions.eq("ownerId", ownerId)).addOrder(Order.asc("updateTime")).list(); //根据案卷ID获取材料
        //List<Original> originals = originalService.getOriginals(ownerId); //根据案卷ID获取材料
        originals = sortListByMaterialNumber(originals);                  //根据材料编号升序排序
        if (originals.size() == 0) {
            return null;
        }

        List detailRoot = new ArrayList();     //每个文件的根目录
        Map detailNameMap = new HashMap();     //用于标记类别

        for (int i = 0; i < originals.size(); i++) {
            String materialNumber = originals.get(i).getMaterialNumber();           //获取材料类别
            if(materialNumber == null || materialNumber.isEmpty()){                                             //如果材料类别为空，则不加载
                continue;
            }

            if (!detailNameMap.containsKey(materialNumber) ) {
                detailNameMap.put(materialNumber, null);                            //将材料类别加载到Map中，用于标记
                String materialName = originals.get(i).getMaterialName();           //获取材料名称
                int iOrgCnt = getOriginalCountByMaterialNumber(materialNumber, originals); //获取材料页数
                String detailName = materialName + "（" + iOrgCnt + "）页";            //文件根目录组织形式：材料名称[材料份数]

                ////文件根目录信息加载
                Map item = new HashMap();
                item.put("text", detailName);
                item.put("cls", "folder");

                if(iOrgCnt > 0) {
                    List children = new ArrayList();       //文件节点
                    for(int j = 0; j < originals.size(); j++) {
                        if(originals.get(j).getMaterialNumber() == null){
                            continue;
                        }

                        if(originals.get(j).getMaterialNumber().equals(materialNumber)){
                            String orginaleName = originals.get(j).getName();               //获取材料名称
                            ////文件材料加载
                            Map childItem = new HashMap();
                            childItem.put("text", orginaleName);
                            childItem.put("id", originals.get(j).getId());
                            childItem.put("iconCls", "no-icon");
                            childItem.put("leaf", true);
                            children.add(childItem);
                        }
                    }

                    item.put("children", children);
                }

                detailRoot.add(item);
            }
        }
        return detailRoot;
    }

    /**
     * 根据材料类型对文件进行排序
     * @param originals
     * @return
     */
    private List<Original> sortListByMaterialNumber(List<Original> originals){
        try{
            Original original = originals.get(0);
            for(int i = 0; i < originals.size(); ++i) {
                for(int j = originals.size() - 1; j > i; --j){
                    String originalsNumberStrOne = originals.get(j).getMaterialNumber();
                    int originalsNumberOne = Integer.parseInt(originalsNumberStrOne);
                    String originalsNumberStrTwo = originals.get(j - 1).getMaterialNumber();
                    int originalsNumberTwo = Integer.parseInt(originalsNumberStrTwo);
                    if(originalsNumberOne < originalsNumberTwo){
                        original = originals.get(j);
                        originals.set(j, originals.get(j - 1));
                        originals.set(j - 1, original);
                    }
                }
            }
            return originals;
        }catch(Exception e){
            logger.error(e.toString());
        }

        return originals;
    }

    /**
     * 根据材料类别获取该材料类别下的材料数目
     * @param sMaterialNumber
     * @param originals
     * @return 材料数目
     */
    private int getOriginalCountByMaterialNumber(String sMaterialNumber, List<Original> originals){
        int iCnt = 0;
        try{
            if(sMaterialNumber == null || originals == null || originals.size() == 0){
                return 0;
            }

            for(int i = 0; i < originals.size(); i++){
                Original original = originals.get(i);
                if(original == null || original.getMaterialNumber() == null){
                    continue;
                }
                if(original.getMaterialNumber().equals(sMaterialNumber)){
                    iCnt = iCnt + 1;
                }
            }
        }catch (Exception e) {
            logger.error(e.toString());
            return  0;
        }

        return iCnt;
    }

}
