package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Position;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.BindService;
import com.gtis.common.Page;
import com.gtis.support.hibernate.HibernateDao;
import com.gtis.support.hibernate.HibernateTemplate;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.management.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-11-30
 */
@Service
public class BindServiceImpl extends HibernateDao implements BindService {
    @Autowired
    protected EntityService entityService;

    /**
     * 保存卷内目录信息
     * @param position （卷内目录）
     * @return
     */
    @Transactional
    public Position savePosition(Position position){
         getSession().save(position);
        return position;
//        return entityService.save(position);
    }

    /**
     * 获取卷内目录信息
     * @param id
     * @return
     */
    public Position getSimplePosition(String id){
        return (Position) getSession().createSQLQuery("select t.*,0 clazz_ from t_position t where t.id=?").addEntity(Position.class).setParameter(0, id).uniqueResult();
    }

    public Page<Position> getEntityPage(Integer jb,String parentid, int limit, int start) {
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>(),jb, parentid);
        List<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("orderNum"));

        return searchEntity(criterions, orders, limit, start);
    }

    public List<Criterion> createCriterions(ArrayList<Criterion> criterions, Integer jb,String parentid) {
        try{
            if (jb == 0 || jb == null) {
                criterions.add(Restrictions.isNotNull("jh"));
            } else {
                criterions.add(Restrictions.eq("parent.id", parentid));
            }

        } catch (Exception e) {
            logger.error("获取架号（排号、盒号）惊现异常：{}",e.toString());
        }
        return criterions;
    }

    public Page<Position> searchEntity(List<Criterion> criterions, List<Order> orders, int limit, int start) {
        Page<Position> positionPage = entityService.search(Position.class, criterions, orders, start, limit);
        for(Position position : positionPage.getItems()){
            position.setParent(null);
            position.setChilds(null);
        }
        return positionPage;
    }

    public int jhcount(Class clazz, String jhid, Integer jb){
        List<Criterion> criterions = new ArrayList<Criterion>();
        try{
            if (jb == 0 || jb == null) {
                criterions.add(Restrictions.eq("jh", jhid));
            } else if(jb == 1){
                criterions.add(Restrictions.eq("ph", jhid));
            }else{
                criterions.add(Restrictions.eq("hh", jhid));
            }
        } catch (Exception e) {
            logger.error("获取架号(排号，盒号)惊现异常：{}",e.toString());
        }
        int count = entityService.getCount(clazz, criterions);
        return count;
    }

    /**
     * 获取最大OrderNum
     * @return
     */
    public int getMaxOrderNum(){
        int iMaxNum = 0;
        String sSQL = "FROM Position ORDER BY orderNum DESC";
        Map map = new HashMap();
        List list =  find(sSQL,map);
        if(list.size() == 0){
            iMaxNum = 0;
        }else{
            Position position = (Position)list.get(0);
            iMaxNum = position.getOrderNum();
        }

        return iMaxNum;
    }

    /**
     * 获取最大架号
     * @return
     */
    public int getMaxJh(){
        int iMaxNum = 0;
        String sSQL = "FROM Position WHERE jh IS NOT NULL ORDER BY orderNum DESC";
        Map map = new HashMap();
        List list =  find(sSQL,map);
        if(list.size() == 0){
            iMaxNum = 0;
        }else {
            Position position = (Position) list.get(0);
            String maxJh = position.getJh();
            iMaxNum = Integer.parseInt(maxJh);
        }

        return iMaxNum;
    }

    /**
     * 获取最大排号
     * @param id（架号id）
     * @return
     */
    public int getMaxPh(String id){
        int iMaxNum = 0;
        String sSQL = "FROM Position WHERE Parent = '"+ id +"' AND ph IS NOT NULL ORDER BY orderNum DESC";
        Map map = new HashMap();
        List list =  find(sSQL,map);
        if(list == null){
            return iMaxNum;
        }

        if(list.size() == 0){
            iMaxNum = 0;
        }else {
            Position position = (Position) list.get(0);
            String maxph = position.getPh();
            iMaxNum = Integer.parseInt(maxph);
        }

        return iMaxNum;
    }

    /**
     * 获取最大盒号
     * @return
     */
    public int getMaxHh(){
        int iMaxNum = 0;
        String sSQL = "FROM Position WHERE hh IS NOT NULL ORDER BY orderNum DESC";
        Map map = new HashMap();
        List list =  find(sSQL,map);
        if(list.size() == 0){
            iMaxNum = 0;
        }else {
            Position position = (Position) list.get(0);
            String maxHh = position.getHh();
            iMaxNum = Integer.parseInt(maxHh);
        }

        return iMaxNum;
    }

    /**
     * 获取最近一条未上架的电子档案号
     * @param flh 分类号
     * @return
     */
    @Override
    public Archive getArchiveDzdah(String flh){
        try {
            String sSQL = "FROM Archive WHERE flh = '"+ flh +"' AND dzdah IS NOT NULL AND jh IS NULL AND ph IS NULL AND hh IS NULL ORDER BY createdAt ASC";
            Map map = new HashMap();
            List list = find(sSQL, map);
            if (list.size() == 0) {
                return null;
            }

            return (Archive)list.get(0);
        }catch (Exception e) {
            logger.error(e.toString());
            return null;
        }
    }
}
