package com.gtis.archive.service.aspectJ.impl;

import com.gtis.archive.entity.*;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.NoteService;
import com.gtis.archive.service.aspectJ.ArchiveNoteService;
import com.gtis.archive.service.invoke.ArchiveReceiveSecivce;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.orm.hibernate3.HibernateTemplate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * Created by zhayuwen on 2015/12/15.
 */
@Aspect
public class ArchiveNoteServiceImpl extends HibernateTemplate implements ArchiveNoteService {
    Logger logger = LoggerFactory.getLogger(ArchiveNoteServiceImpl.class);

    private SessionFactory sessionFactory ;

    @Autowired
    private TaskExecutor taskExecutor;

    @Autowired
    private SysUserService userService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private ArchiveReceiveSecivce archiveReceiveSecivce;

    @Autowired
    private NoteService noteService;

    @Override
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    @Override
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /**
     * 返回通知：当批次任务转发完成后，采用异步方式生成备考表的上一手下一手信息
     * @param joinPoint
     */
    @After(value = "execution(* com.gtis.archive.service.impl.MaterialServiceImpl.receviceMateria(String,String,String))")
    public void addNote(final JoinPoint joinPoint) {
        taskExecutor.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    Thread.sleep(10000); //异步任务睡眠十秒后执行
                } catch (InterruptedException e) {
                    logger.error("线程异常：{}", e.toString());
                }
                Object[] args = joinPoint.getArgs();
                String mid = (String) args[0];   //获取第一个材料清单的参数
                String userid = (String) args[2];
                String[] mIds = mid.split(",");
                List<String> sysList = new ArrayList<String>();
                List<String> xysList = new ArrayList<String>();
                List<Note> notes = new ArrayList<Note>();
                List<Note> preNotes = new ArrayList<Note>();

                Session session = getSession();
                Transaction transaction = session.getTransaction();
                transaction.begin();
                Note note = null;
                for (String id : mIds) {
                    Material material = (Material) session.get(Material.class, id);
                    Set<MaterialArchive> materialArchives = (Set<MaterialArchive>) material.getMaterialArchives();

                    for (MaterialArchive materialArchive : materialArchives) {
                        Archive archive = archiveService.getArchiveBySlh(materialArchive.getSlh());
                        if(Struts2Utils.isNull(archive))
                            continue;
                        note = new Note();
                        note.setArchive(archive);
                        note.setArchiveId(archive.getId());
                        try {
                            note.setLjr(userService.getUserVo(userid).getUserName());
                        } catch (Exception e) {
                            logger.error("获取立卷人姓名出现异常：{}", e.toString());
                        }
                        note.setLjrq(new Date());

                        try {
                            sysList = archiveReceiveSecivce.beforeSlh(archive.getSlh());
                            xysList = archiveReceiveSecivce.afterSlh(archive.getSlh());
                        } catch (Exception e) {
                            logger.error("获取不动产接口前一手信息或者下一手信息出现异常：{}", e.toString());
                        }

//                        sysList.add("20151126095407968");

                        /**
                         * 转化为备考表
                         * 1.更新上一手档案信息至当前档案
                         * 2.更新上一手档案的下一手信息（即为当前档案）
                         */
                        if(!Struts2Utils.isNull(sysList)){
                            for(String slh : sysList){
                                Archive archive1 = archiveService.getArchiveBySlh(slh);
                                if(archive1 == null){
                                    logger.error("不动产系统推送受理号存在异常，无法找到这条档案受理号为："+slh);
                                    continue;
                                }
                                NoteInfo noteInfo = new NoteInfo();
                                noteInfo.setNote(note);
                                noteInfo.setJjdbh(archive1.getJjdbh());
                                noteInfo.setDzdah(archive1.getDzdah());
                                noteInfo.setHm(archive1.getSqr());
                                noteInfo.setCqzh(archive1.getCqzh());
                                noteInfo.setDjrq(material.getJjrq());
                                noteInfo.setType(0);
                                noteInfo.setSlh(archive1.getSlh());
                                note.getNoteInfoSet().add(noteInfo);


                                //当前档案信息即为上一手档案的下一手信息
                                Note preNote = noteService.getNoteByArchiveId(archive1.getId()); //上一手档案的备考表
                                if(!Struts2Utils.isNull(preNote)){
                                    NoteInfo nextNoteInfo = new NoteInfo();
                                    nextNoteInfo.setNote(preNote);
                                    nextNoteInfo.setJjdbh(archive.getJjdbh());
                                    nextNoteInfo.setDzdah(archive.getDzdah());
                                    nextNoteInfo.setHm(archive.getSqr());
                                    nextNoteInfo.setCqzh(archive.getCqzh());
                                    nextNoteInfo.setDjrq(material.getJjrq());
                                    nextNoteInfo.setType(1);
                                    nextNoteInfo.setSlh(archive.getSlh());
                                    preNote.getNoteInfoSet().add(nextNoteInfo);
                                    preNotes.add(preNote);
                                }
                            }
                        }

                        /**
                         * 下一手信息存储
                         */
                        if(!Struts2Utils.isNull(xysList)){
                            for(String slh : xysList){
                                Archive archive1 = archiveService.getArchiveBySlh(slh);
                                if(archive1 == null){
                                    logger.error("不动产系统推送受理号存在异常，无法找到这条档案受理号为：{}", slh);
                                    continue;
                                }
                                NoteInfo noteInfo = new NoteInfo();
                                noteInfo.setNote(note);
                                noteInfo.setJjdbh(archive1.getJjdbh());
                                noteInfo.setDzdah(archive1.getDzdah());
                                noteInfo.setHm(archive1.getSqr());
                                noteInfo.setCqzh(archive1.getCqzh());
                                noteInfo.setDjrq(material.getJjrq());
                                noteInfo.setType(1);
                                noteInfo.setSlh(archive1.getSlh());
                                note.getNoteInfoSet().add(noteInfo);
                            }
                        }
                        notes.add(note);
                    }
                }
                saveOrUpdateAll(notes);
                transaction.commit();
                saveOrUpdateAll(preNotes);
            }
        });
    }
}
